/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;

public class ImplicitCollectFilter
extends AbstractOperationFilter {
    protected final Type iteratorType;

    public ImplicitCollectFilter(MetaModelManager metaModelManager, CollectionType sourceType, Type iteratorType) {
        super(metaModelManager, (Type)sourceType);
        this.iteratorType = iteratorType;
    }

    public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
        if (!(eObject instanceof Iteration)) {
            return false;
        }
        Iteration candidateIteration = (Iteration)eObject;
        int iteratorCount = candidateIteration.getOwnedIterator().size();
        if (iteratorCount != 1) {
            return false;
        }
        int accumulatorCount = candidateIteration.getOwnedAccumulator().size();
        if (accumulatorCount != 0) {
            return false;
        }
        TemplateSignature templateSignature = candidateIteration.getOwningType().getOwnedTemplateSignature();
        if (templateSignature == null) {
            return false;
        }
        EList templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() != 1) {
            return false;
        }
        Map bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, (TemplateableElement)this.sourceType);
        TemplateParameter iteratorParameter = (TemplateParameter)templateParameters.get(0);
        bindings.put(iteratorParameter, this.iteratorType);
        this.installBindings(environmentView, forType, eObject, bindings);
        return true;
    }
}

