/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationFilter
extends AbstractOperationFilter {
    protected final List<NavigatingArgCS> csArguments;
    protected final int iterators;
    protected final int accumulators;
    protected final int expressions;

    public OperationFilter(MetaModelManager metaModelManager, Type sourceType, InvocationExpCS csNavigatingExp) {
        super(metaModelManager, sourceType);
        int accumulators = 0;
        int iterators = 0;
        int expressions = 0;
        this.csArguments = csNavigatingExp.getArgument();
        for (NavigatingArgCS csNavigatingArg : this.csArguments) {
            if (csNavigatingArg.getRole() == NavigationRole.ITERATOR) {
                ++iterators;
                continue;
            }
            if (csNavigatingArg.getRole() == NavigationRole.ACCUMULATOR) {
                ++accumulators;
                continue;
            }
            if (csNavigatingArg.getRole() != NavigationRole.EXPRESSION) continue;
            ++expressions;
        }
        this.iterators = iterators;
        this.accumulators = accumulators;
        this.expressions = expressions;
    }

    protected OCLExpression getExpressionArgument(int index) {
        int expIndex = 0;
        for (NavigatingArgCS csNavigatingArg : this.csArguments) {
            if (csNavigatingArg.getRole() != NavigationRole.EXPRESSION) continue;
            if (expIndex == index) {
                return (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csNavigatingArg);
            }
            ++expIndex;
        }
        return null;
    }

    protected Map<TemplateParameter, ParameterableElement> getIterationBindings(Iteration candidateIteration) {
        Type sourceType = this.sourceType;
        if (!(sourceType instanceof CollectionType) && candidateIteration.getOwningType() instanceof CollectionType) {
            sourceType = this.metaModelManager.getCollectionType("Set", sourceType);
        }
        if (!(sourceType instanceof CollectionType)) {
            return null;
        }
        HashMap<TemplateParameter, ParameterableElement> bindings = new HashMap<TemplateParameter, ParameterableElement>();
        bindings.put((TemplateParameter)candidateIteration.getOwningType().getOwnedTemplateSignature().getOwnedParameter().get(0), (ParameterableElement)((CollectionType)sourceType).getElementType());
        PivotUtil.getAllTemplateParameterSubstitutions(bindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateIteration.getOwnedTemplateSignature();
        if (templateSignature != null) {
            EList templateParameters = templateSignature.getOwnedParameter();
            int accIndex = 0;
            for (NavigatingArgCS csArgument : this.csArguments) {
                if (csArgument.getRole() != NavigationRole.ACCUMULATOR) continue;
                if (accIndex < templateParameters.size()) {
                    Variable argument = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csArgument);
                    Type argumentType = argument.getType();
                    TemplateParameter accParameter = (TemplateParameter)templateParameters.get(accIndex);
                    bindings.put(accParameter, (ParameterableElement)argumentType);
                }
                ++accIndex;
            }
        }
        return bindings;
    }

    @Override
    protected Map<TemplateParameter, ParameterableElement> getOperationBindings(Operation candidateOperation) {
        Type sourceType = this.sourceType;
        HashMap<TemplateParameter, Type> bindings = null;
        Type containingType = candidateOperation.getOwningType();
        if (containingType instanceof CollectionType) {
            if (!(sourceType instanceof CollectionType)) {
                sourceType = this.metaModelManager.getCollectionType("Set", sourceType);
            }
            Object elementType = sourceType instanceof CollectionType ? ((CollectionType)sourceType).getElementType() : this.metaModelManager.getOclInvalidType();
            bindings = new HashMap<TemplateParameter, Type>();
            bindings.put((TemplateParameter)containingType.getOwnedTemplateSignature().getOwnedParameter().get(0), (Type)elementType);
        }
        bindings = PivotUtil.getAllTemplateParameterSubstitutions(bindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = candidateOperation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameter()) {
                if (bindings == null) {
                    bindings = new HashMap();
                }
                bindings.put(templateParameter, null);
            }
        }
        return bindings;
    }

    @Override
    protected void installBindings(EnvironmentView environmentView, Type forType, EObject eObject, Map<TemplateParameter, ParameterableElement> bindings) {
        EList parameters = ((Operation)eObject).getOwnedParameter();
        int iMax = parameters.size();
        if (iMax > 0) {
            int i = 0;
            while (i < iMax) {
                Type parameterType;
                Parameter parameter = (Parameter)parameters.get(i);
                OCLExpression argument = this.getExpressionArgument(i);
                if (argument != null && (parameterType = parameter.getType()) instanceof LambdaType) {
                    PivotUtil.getAllTemplateParameterSubstitutions(bindings, (Type)argument.getType(), (LambdaType)((LambdaType)parameterType));
                }
                ++i;
            }
        }
        super.installBindings(environmentView, forType, eObject, bindings);
    }

    public boolean matches(EnvironmentView environmentView, Type forType, EObject eObject) {
        if (eObject instanceof Iteration) {
            Iteration candidateIteration = (Iteration)eObject;
            int iteratorCount = candidateIteration.getOwnedIterator().size();
            if (this.iterators > 0 && iteratorCount != this.iterators) {
                return false;
            }
            int accumulatorCount = candidateIteration.getOwnedAccumulator().size();
            if (accumulatorCount != this.accumulators) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getIterationBindings(candidateIteration);
            if (bindings != null) {
                this.installBindings(environmentView, forType, eObject, bindings);
            }
            return true;
        }
        if (eObject instanceof Operation) {
            if (this.iterators > 0) {
                return false;
            }
            if (this.accumulators > 0) {
                return false;
            }
            Operation candidateOperation = (Operation)eObject;
            EList candidateParameters = candidateOperation.getOwnedParameter();
            if (this.expressions != candidateParameters.size()) {
                return false;
            }
            Map<TemplateParameter, ParameterableElement> bindings = this.getOperationBindings(candidateOperation);
            int i = 0;
            while (i < this.expressions) {
                Parameter candidateParameter = (Parameter)candidateParameters.get(i);
                NavigatingArgCS csExpression = this.csArguments.get(i);
                OCLExpression expression = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csExpression);
                if (expression == null) {
                    return false;
                }
                Type candidateType = this.metaModelManager.getTypeWithMultiplicity((TypedMultiplicityElement)candidateParameter);
                if (candidateType instanceof SelfType) {
                    candidateType = candidateOperation.getOwningType();
                }
                Type expressionType = expression.getType();
                if (!this.metaModelManager.conformsTo(expressionType = PivotUtil.getBehavioralType((Type)expressionType), candidateType, bindings)) {
                    return false;
                }
                ++i;
            }
            if (bindings != null) {
                this.installBindings(environmentView, forType, eObject, bindings);
            }
            return true;
        }
        return false;
    }
}

