/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.LibraryValidator;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.NumericLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.scoping.BaseScopeView;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.BinaryOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ImplicitCollectFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.ImplicitCollectionFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.UnaryOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.AbstractEssentialOCLLeft2RightVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BinaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ConstructorExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ConstructorPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IndexExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LetExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LetVariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NamedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLUtils;

public class EssentialOCLLeft2RightVisitor
extends AbstractEssentialOCLLeft2RightVisitor {
    private static final Logger logger = Logger.getLogger(EssentialOCLLeft2RightVisitor.class);
    protected final MetaModelManager metaModelManager;

    public EssentialOCLLeft2RightVisitor(CS2PivotConversion context) {
        super(context);
        this.metaModelManager = context.getMetaModelManager();
    }

    protected OCLExpression checkImplementation(NamedExpCS csNavigatingExp, Feature feature, CallExp callExp, OCLExpression expression) {
        Diagnostic diagnostic;
        LibraryValidator validator;
        LibraryFeature implementation;
        try {
            implementation = this.metaModelManager.getImplementation(feature);
        }
        catch (Exception e) {
            return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNavigatingExp, "Failed to load '" + feature.getImplementationClass() + "': " + e);
        }
        if (implementation != null && (validator = implementation.getValidator((DomainStandardLibrary)this.metaModelManager)) != null && (diagnostic = validator.validate((DomainStandardLibrary)this.metaModelManager, (DomainCallExp)callExp)) != null) {
            ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csNavigatingExp, diagnostic);
        }
        return expression;
    }

    protected Operation getBadOperation() {
        InvalidType invalidType = this.metaModelManager.getOclInvalidType();
        Operation badOperation = (Operation)PivotUtil.getNamedElement((Iterable)invalidType.getOwnedOperation(), (String)"oclBadOperation");
        return badOperation;
    }

    protected Property getBadProperty() {
        InvalidType invalidType = this.metaModelManager.getOclInvalidType();
        Property badProperty = (Property)PivotUtil.getNamedElement((Iterable)invalidType.getOwnedAttribute(), (String)"oclBadProperty");
        return badProperty;
    }

    protected VariableDeclaration getImplicitSource(ModelElementCS csExp, Feature feature) {
        EObject eContainer = csExp.eContainer();
        if (csExp instanceof InvocationExpCS) {
            Type namedElementType = PivotUtil.getOwningType((Feature)feature);
            InvocationExpCS csNavigatingExp = (InvocationExpCS)csExp;
            CallExp iteratorExp = (CallExp)PivotUtil.getPivot(CallExp.class, (Pivotable)csNavigatingExp);
            if (iteratorExp instanceof LoopExp) {
                Type type;
                Variable iterator2;
                for (Variable iterator2 : ((LoopExp)iteratorExp).getIterator()) {
                    Type type2 = iterator2.getType();
                    if (!this.metaModelManager.conformsTo(type2, namedElementType)) continue;
                    return iterator2;
                }
                if (iteratorExp instanceof IterateExp && this.metaModelManager.conformsTo(type = (iterator2 = ((IterateExp)iteratorExp).getResult()).getType(), namedElementType)) {
                    return iterator2;
                }
            }
        } else if (eContainer instanceof InvocationExpCS) {
            EReference eContainmentFeature = csExp.eContainmentFeature();
            if (eContainmentFeature == EssentialOCLCSTPackage.Literals.INVOCATION_EXP_CS__ARGUMENT) {
                Type namedElementType = PivotUtil.getOwningType((Feature)feature);
                InvocationExpCS csNavigatingExp = (InvocationExpCS)eContainer;
                CallExp iteratorExp = (CallExp)PivotUtil.getPivot(CallExp.class, (Pivotable)csNavigatingExp);
                if (iteratorExp instanceof LoopExp) {
                    Variable iterator;
                    Iterator type2 = ((LoopExp)iteratorExp).getIterator().iterator();
                    while (type2.hasNext()) {
                        iterator = (Variable)type2.next();
                        Type type = iterator.getType();
                        if (!this.metaModelManager.conformsTo(type, namedElementType)) continue;
                        return iterator;
                    }
                    if (iteratorExp instanceof IterateExp && this.metaModelManager.conformsTo((Type)(type2 = (iterator = ((IterateExp)iteratorExp).getResult()).getType()), namedElementType)) {
                        return iterator;
                    }
                }
            }
        } else {
            if (csExp instanceof ContextCS) {
                ContextCS csContext = (ContextCS)csExp;
                ExpressionInOCL pivotElement = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csContext);
                return pivotElement.getContextVariable();
            }
            if (csExp instanceof ExpSpecificationCS) {
                ExpressionInOCL pivotElement = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csExp);
                return pivotElement.getContextVariable();
            }
        }
        if (eContainer instanceof ContextCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        if (eContainer instanceof ExpSpecificationCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        if (eContainer instanceof ExpCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        if (eContainer instanceof NavigatingArgCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        return null;
    }

    protected Type getSourceElementType(InvocationExpCS csNavigatingExp, OCLExpression source) {
        Type sourceType = source.getType();
        boolean isCollectionNavigation = "->".equals(csNavigatingExp.getParent().getName());
        if (!isCollectionNavigation) {
            return sourceType;
        }
        if (sourceType instanceof CollectionType) {
            return ((CollectionType)sourceType).getElementType();
        }
        return sourceType;
    }

    protected EnumLiteralExp resolveEnumLiteral(ExpCS csExp, EnumerationLiteral enumerationLiteral) {
        EnumLiteralExp expression = (EnumLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(EnumLiteralExp.class, PivotPackage.Literals.ENUM_LITERAL_EXP, (ModelElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)enumerationLiteral.getEnumeration());
        expression.setReferredEnumLiteral(enumerationLiteral);
        return expression;
    }

    protected void resolveIterationAccumulators(InvocationExpCS csNavigatingExp, LoopExp expression) {
        Iteration iteration = expression.getReferredIteration();
        ArrayList<Variable> pivotAccumulators = new ArrayList<Variable>();
        int argIndex = 0;
        while (argIndex < csNavigatingExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csNavigatingExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ACCUMULATOR) {
                if (csArgument.getInit() == null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Missing initializer for accumulator");
                }
                ExpCS csName = csArgument.getName();
                Variable acc = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csName);
                acc.setRepresentedParameter((Parameter)iteration.getOwnedAccumulator().get(pivotAccumulators.size()));
                pivotAccumulators.add(acc);
            }
            ++argIndex;
        }
        if (expression instanceof IterateExp) {
            IterateExp iterateExp = (IterateExp)expression;
            if (pivotAccumulators.size() > 1) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csNavigatingExp, "Iterate calls cannot have more than one accumulator");
            } else {
                iterateExp.setResult((Variable)pivotAccumulators.get(0));
            }
        } else if (pivotAccumulators.size() > 0) {
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csNavigatingExp, "Iteration calls cannot have an accumulator");
        }
    }

    protected void resolveIterationBody(InvocationExpCS csNavigatingExp, LoopExp expression) {
        ArrayList<OCLExpression> pivotBodies = new ArrayList<OCLExpression>();
        for (NavigatingArgCS csArgument : csNavigatingExp.getArgument()) {
            if (csArgument.getRole() != NavigationRole.EXPRESSION) continue;
            if (csArgument.getInit() != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for expression");
            }
            if (csArgument.getOwnedType() != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected type for expression");
            }
            OCLExpression exp = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csArgument.getName());
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)exp);
            pivotBodies.add(exp);
        }
        if (pivotBodies.size() != 1) {
            expression.setBody(((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNavigatingExp, "Iteration calls must have exactly one body"));
        } else {
            expression.setBody((OCLExpression)pivotBodies.get(0));
        }
    }

    protected LoopExp resolveIterationCall(InvocationExpCS csNavigatingExp, OCLExpression source, Iteration iteration) {
        InvocationExpCS csNamedExp = csNavigatingExp;
        LoopExp expression = iteration.getOwnedAccumulator().size() > 0 ? (LoopExp)((CS2PivotConversion)this.context).refreshModelElement(IterateExp.class, PivotPackage.Literals.ITERATE_EXP, (ModelElementCS)csNamedExp) : (LoopExp)((CS2PivotConversion)this.context).refreshModelElement(IteratorExp.class, PivotPackage.Literals.ITERATOR_EXP, (ModelElementCS)csNamedExp);
        ((CS2PivotConversion)this.context).setReferredIteration(expression, iteration);
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNavigatingExp, (Element)expression);
        this.resolveIterationAccumulators(csNavigatingExp, expression);
        this.resolveIterationIterators(csNavigatingExp, source, expression);
        this.resolveOperationReturnType((CallExp)expression);
        return expression;
    }

    protected void resolveIterationExplicitAccumulators(InvocationExpCS csNavigatingExp) {
        int argIndex = 0;
        while (argIndex < csNavigatingExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csNavigatingExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ACCUMULATOR) {
                ExpCS csName = csArgument.getName();
                Variable acc = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csName);
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)acc);
                OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csArgument.getInit());
                acc.setInitExpression(initExpression);
                TypedRefCS csAccType = csArgument.getOwnedType();
                Type accType = csAccType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csAccType) : initExpression.getType();
                ((CS2PivotConversion)this.context).setType((TypedElement)acc, accType);
            }
            ++argIndex;
        }
    }

    protected void resolveIterationIterators(InvocationExpCS csNavigatingExp, OCLExpression source, LoopExp expression) {
        Iteration iteration = expression.getReferredIteration();
        ArrayList<Variable> pivotIterators = new ArrayList<Variable>();
        int iterationIteratorsSize = iteration.getOwnedIterator().size();
        int argIndex = 0;
        while (argIndex < csNavigatingExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csNavigatingExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ITERATOR) {
                if (iterationIteratorsSize <= argIndex) {
                    ((CS2PivotConversion)this.context).addWarning((ModelElementCS)csArgument, OCLMessages.RedundantIterator_WARNING_, new Object[]{iteration.getName()});
                } else {
                    Type varType;
                    if (csArgument.getInit() != null) {
                        ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for iterator");
                    }
                    ExpCS csName = csArgument.getName();
                    Variable iterator = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csName);
                    ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)iterator);
                    iterator.setRepresentedParameter((Parameter)iteration.getOwnedIterator().get(pivotIterators.size()));
                    TypedRefCS csType = csArgument.getOwnedType();
                    Type type = varType = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : null;
                    if (varType == null) {
                        varType = this.getSourceElementType(csNavigatingExp, source);
                    }
                    ((CS2PivotConversion)this.context).setType((TypedElement)iterator, varType);
                    pivotIterators.add(iterator);
                }
            }
            ++argIndex;
        }
        while (pivotIterators.size() < iterationIteratorsSize) {
            String varName = String.valueOf(Integer.toString(pivotIterators.size() + 1)) + "_";
            Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.VARIABLE, null);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, varName);
            Type varType = this.getSourceElementType(csNavigatingExp, source);
            ((CS2PivotConversion)this.context).setType((TypedElement)iterator, varType);
            iterator.setImplicit(true);
            iterator.setRepresentedParameter((Parameter)iteration.getOwnedIterator().get(pivotIterators.size()));
            pivotIterators.add(iterator);
        }
        ((CS2PivotConversion)this.context).refreshList((List)expression.getIterator(), pivotIterators);
    }

    protected CallExp resolveNavigationFeature(NamedExpCS csElement, OCLExpression source, Feature feature, CallExp callExp) {
        Type actualSourceType;
        NavigationOperatorCS navigationOperatorCS;
        CallExp navigationExp = callExp;
        Type requiredSourceType = PivotUtil.getOwningType((Feature)feature);
        boolean isDotNavigation = false;
        OperatorCS parent = csElement.getParent();
        if (parent instanceof NavigationOperatorCS && parent.getSource() != csElement && (isDotNavigation = ".".equals((navigationOperatorCS = (NavigationOperatorCS)parent).getName())) && (actualSourceType = source.getType()) instanceof CollectionType && !(requiredSourceType instanceof CollectionType)) {
            Type elementType = ((CollectionType)actualSourceType).getElementType();
            IteratorExp iteratorExp = (IteratorExp)((CS2PivotConversion)this.context).refreshModelElement(IteratorExp.class, PivotPackage.Literals.ITERATOR_EXP, null);
            iteratorExp.setImplicit(true);
            EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)PivotPackage.Literals.LOOP_EXP__REFERRED_ITERATION, "collect");
            environmentView.addFilter((ScopeFilter)new ImplicitCollectFilter(this.metaModelManager, (CollectionType)actualSourceType, elementType));
            Type lowerBoundType = (Type)PivotUtil.getLowerBound((Element)actualSourceType);
            environmentView.computeLookups((Element)lowerBoundType, null, null, null);
            Iteration resolvedIteration = (Iteration)environmentView.getContent();
            ((CS2PivotConversion)this.context).setReferredIteration((LoopExp)iteratorExp, resolvedIteration);
            Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshModelElement(Variable.class, PivotPackage.Literals.VARIABLE, null);
            Parameter resolvedIterator = (Parameter)resolvedIteration.getOwnedIterator().get(0);
            iterator.setRepresentedParameter(resolvedIterator);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, "1_");
            ((CS2PivotConversion)this.context).setType((TypedElement)iterator, elementType);
            iterator.setImplicit(true);
            iteratorExp.getIterator().add((Object)iterator);
            VariableExp variableExp = (VariableExp)((CS2PivotConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, null);
            variableExp.setReferredVariable((VariableDeclaration)iterator);
            variableExp.setImplicit(true);
            ((CS2PivotConversion)this.context).setType((TypedElement)variableExp, elementType);
            callExp.setSource((OCLExpression)variableExp);
            iteratorExp.setBody((OCLExpression)callExp);
            navigationExp = iteratorExp;
        }
        navigationExp.setSource(source);
        return navigationExp;
    }

    protected OCLExpression resolveNavigationSource(NamedExpCS csNameExp, Feature feature) {
        ModelElementCS csPivoted;
        ElementCS csChild;
        ModelElementCS csParent;
        ModelElementCS csPivotedParent;
        VariableDeclaration implicitSource;
        ExpCS csSource;
        boolean isCollectionNavigation = false;
        OperatorCS csOperator = csNameExp.getParent();
        OCLExpression source = null;
        if (csOperator instanceof NavigationOperatorCS && (csSource = csOperator.getSource()) != csNameExp) {
            source = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csSource);
            isCollectionNavigation = csOperator.getName().equals("->");
        }
        if (source == null && (implicitSource = this.getImplicitSource(csPivotedParent = EssentialOCLUtils.getPivotedCS((EObject)(csParent = EssentialOCLUtils.getPivotingParentCS(csChild = EssentialOCLUtils.getPivotingChildCS((ElementCS)(csPivoted = EssentialOCLUtils.getPivotedCS((EObject)(csOperator != null ? csOperator : csNameExp))))))), feature)) != null) {
            VariableExp sourceAccess = PivotFactory.eINSTANCE.createVariableExp();
            sourceAccess.setReferredVariable(implicitSource);
            ((CS2PivotConversion)this.context).setType((TypedElement)sourceAccess, implicitSource.getType());
            sourceAccess.setImplicit(true);
            source = sourceAccess;
        }
        if (source != null) {
            Type actualSourceType = source.getType();
            if (isCollectionNavigation && !(actualSourceType instanceof CollectionType)) {
                OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csOperator);
                expression.setImplicit(true);
                expression.setSource(source);
                expression.setName("oclAsSet");
                this.resolveOperationCall(expression, csOperator, new ImplicitCollectionFilter(this.metaModelManager, actualSourceType));
                source = expression;
            }
        }
        return source;
    }

    protected OCLExpression resolveOperation(InvocationExpCS csNavigatingExp) {
        InvocationExpCS csNamedExp = csNavigatingExp;
        this.resolveOperationArgumentTypes(csNavigatingExp);
        this.resolveIterationExplicitAccumulators(csNavigatingExp);
        NamedElement namedElement = csNamedExp.getNamedElement();
        if (namedElement == null || namedElement.eIsProxy()) {
            namedElement = this.getBadOperation();
            OperationCallExp operationCallExp = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csNamedExp);
            ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, null);
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNavigatingExp, (Element)operationCallExp);
            ((CS2PivotConversion)this.context).setType((TypedElement)operationCallExp, (Type)this.metaModelManager.getOclInvalidType());
            return operationCallExp;
        }
        if (namedElement instanceof Operation) {
            CallExp outerExpression;
            LoopExp innerExpression;
            Operation operation = (Operation)namedElement;
            Operation baseOperation = this.metaModelManager.resolveBaseOperation(operation);
            OCLExpression source = this.resolveNavigationSource(csNavigatingExp, (Feature)operation);
            if (operation instanceof Iteration) {
                Iteration iteration = (Iteration)operation;
                innerExpression = this.resolveIterationCall(csNavigatingExp, source, iteration);
                outerExpression = this.resolveNavigationFeature(csNavigatingExp, source, (Feature)baseOperation, (CallExp)innerExpression);
                this.resolveIterationBody(csNavigatingExp, innerExpression);
            } else {
                OperationCallExp operationCallExp = (OperationCallExp)((CS2PivotConversion)this.context).refreshModelElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (ModelElementCS)csNamedExp);
                ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, operation);
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNavigatingExp, (Element)operationCallExp);
                innerExpression = operationCallExp;
                outerExpression = this.resolveNavigationFeature(csNavigatingExp, source, (Feature)baseOperation, (CallExp)innerExpression);
                this.resolveOperationArguments(csNavigatingExp, source, operation, operationCallExp);
            }
            this.resolveOperationReturnType((CallExp)innerExpression);
            if (outerExpression != innerExpression) {
                this.resolveOperationReturnType(outerExpression);
            }
            return this.checkImplementation(csNavigatingExp, (Feature)operation, (CallExp)innerExpression, (OCLExpression)outerExpression);
        }
        return this.resolveUnknownOperation(csNamedExp);
    }

    protected OCLExpression resolveUnknownOperation(NamedExpCS csNamedExp) {
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNamedExp, "Operation name expected");
    }

    protected void resolveOperationArgumentTypes(InvocationExpCS csNavigatingExp) {
        for (NavigatingArgCS csArgument : csNavigatingExp.getArgument()) {
            OCLExpression arg;
            if (csArgument.getRole() == NavigationRole.ITERATOR || csArgument.getRole() == NavigationRole.ACCUMULATOR) break;
            if (csArgument.getRole() != NavigationRole.EXPRESSION || (arg = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csArgument.getName())) == null) continue;
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csArgument, (Element)arg);
        }
    }

    protected void resolveOperationArguments(InvocationExpCS csNavigatingExp, OCLExpression source, Operation operation, OperationCallExp expression) {
        ArrayList<OCLExpression> pivotArguments = new ArrayList<OCLExpression>();
        EList<NavigatingArgCS> csArguments = csNavigatingExp.getArgument();
        EList ownedParameters = operation.getOwnedParameter();
        int parametersCount = ownedParameters.size();
        int csArgumentCount = csArguments.size();
        if (csArgumentCount > 0) {
            if (((NavigatingArgCS)csArguments.get(0)).getRole() != NavigationRole.EXPRESSION) {
                ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csNavigatingExp, "Operation calls can only specify expressions");
            }
            int argIndex = 0;
            while (argIndex < csArgumentCount) {
                OCLExpression arg;
                NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(argIndex);
                if (csArgument.getInit() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected initializer for expression");
                }
                if (csArgument.getOwnedType() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csArgument, "Unexpected type for expression");
                }
                if ((arg = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csArgument)) != null) {
                    pivotArguments.add(arg);
                }
                ++argIndex;
            }
        }
        if (csArgumentCount != parametersCount && operation != this.getBadOperation()) {
            String boundMessage = DomainUtil.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object[])new Object[]{csArgumentCount, parametersCount});
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csNavigatingExp, boundMessage);
        }
        ((CS2PivotConversion)this.context).refreshList((List)expression.getArgument(), pivotArguments);
    }

    protected void resolveOperationCall(OperationCallExp expression, OperatorCS csOperator, ScopeFilter filter) {
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)PivotPackage.Literals.OPERATION_CALL_EXP__REFERRED_OPERATION, expression.getName());
        environmentView.addFilter(filter);
        Type sourceType = expression.getSource().getType();
        if (sourceType instanceof LambdaType) {
            sourceType = ((LambdaType)sourceType).getResultType();
        }
        int size = 0;
        if (sourceType != null) {
            Type lowerBoundType = (Type)PivotUtil.getLowerBound((Element)sourceType);
            size = environmentView.computeLookups((Element)lowerBoundType, null, null, null);
        }
        if (size == 1) {
            Operation operation = (Operation)environmentView.getContent();
            ((CS2PivotConversion)this.context).setReferredOperation(expression, operation);
            this.resolveOperationReturnType((CallExp)expression);
        } else {
            StringBuilder s = new StringBuilder();
            for (OCLExpression argument : expression.getArgument()) {
                Type argumentType = argument.getType();
                if (argumentType instanceof LambdaType) {
                    argumentType = ((LambdaType)argumentType).getResultType();
                }
                if (s.length() > 0) {
                    s.append(",");
                }
                if (argumentType == null) continue;
                s.append(argumentType.toString());
            }
            String boundMessage = s.length() > 0 ? DomainUtil.bind((String)OCLMessages.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{csOperator, sourceType, s.toString()}) : DomainUtil.bind((String)OCLMessages.UnresolvedOperation_ERROR_, (Object[])new Object[]{csOperator, sourceType});
            ((CS2PivotConversion)this.context).addDiagnostic((ElementCS)csOperator, boundMessage);
            Operation badOperation = this.getBadOperation();
            ((CS2PivotConversion)this.context).setReferredOperation(expression, badOperation);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getOclInvalidType());
        }
    }

    protected void resolveOperationReturnType(CallExp callExp) {
        Type bodyType;
        OCLExpression body;
        EList parameters;
        Operation operation = null;
        if (callExp instanceof OperationCallExp) {
            operation = ((OperationCallExp)callExp).getReferredOperation();
        } else if (callExp instanceof LoopExp) {
            operation = ((LoopExp)callExp).getReferredIteration();
        }
        if (operation == null) {
            return;
        }
        HashMap<TemplateParameter, Type> templateBindings = new HashMap<TemplateParameter, Type>();
        Type sourceType = null;
        OCLExpression source = callExp.getSource();
        if (source != null) {
            sourceType = source.getType();
        }
        if (sourceType != null) {
            if (operation.isStatic() && sourceType instanceof ClassifierType) {
                sourceType = ((ClassifierType)sourceType).getInstanceType();
            }
            templateBindings.put(null, sourceType);
        }
        PivotUtil.getAllTemplateParameterSubstitutions(templateBindings, (TemplateableElement)sourceType);
        TemplateSignature templateSignature = operation.getOwnedTemplateSignature();
        if (templateSignature != null) {
            for (TemplateParameter templateParameter : templateSignature.getOwnedParameter()) {
                templateBindings.put(templateParameter, null);
            }
        }
        boolean isConformant = true;
        if (callExp instanceof OperationCallExp) {
            parameters = operation.getOwnedParameter();
            EList arguments = ((OperationCallExp)callExp).getArgument();
            int iMax = Math.min(parameters.size(), arguments.size());
            int i = 0;
            while (i < iMax) {
                Parameter parameter = (Parameter)parameters.get(i);
                OCLExpression argument = (OCLExpression)arguments.get(i);
                if (parameter != null && argument != null) {
                    Type parameterType = PivotUtil.getBehavioralType((Type)this.metaModelManager.getTypeWithMultiplicity((TypedMultiplicityElement)parameter));
                    Type argumentType = PivotUtil.getBehavioralType((Type)argument.getType());
                    if (!this.metaModelManager.conformsTo(argumentType, parameterType, templateBindings)) {
                        isConformant = false;
                    }
                }
                ++i;
            }
        } else if (callExp instanceof LoopExp) {
            EList accumulators;
            if (callExp instanceof IterateExp && (accumulators = ((Iteration)operation).getOwnedAccumulator()).size() >= 1) {
                Parameter accumulator = (Parameter)accumulators.get(0);
                Variable result = ((IterateExp)callExp).getResult();
                if (accumulator != null && result != null) {
                    Type accumulatorType = PivotUtil.getBehavioralType((Type)accumulator.getType());
                    Type resultType = PivotUtil.getBehavioralType((Type)result.getType());
                    if (!this.metaModelManager.conformsTo(resultType, accumulatorType, templateBindings)) {
                        isConformant = false;
                    }
                }
            }
            if ((parameters = ((Iteration)operation).getOwnedParameter()).size() >= 1) {
                Parameter parameter = (Parameter)parameters.get(0);
                OCLExpression body2 = ((LoopExp)callExp).getBody();
                if (parameter != null && body2 != null) {
                    Type bodyType2;
                    Type parameterType = parameter.getType();
                    if (parameterType instanceof LambdaType) {
                        parameterType = ((LambdaType)parameterType).getResultType();
                    }
                    if (!this.metaModelManager.conformsTo(bodyType2 = PivotUtil.getBehavioralType((Type)body2.getType()), parameterType, templateBindings)) {
                        isConformant = false;
                    }
                }
            }
        }
        Type returnType = this.metaModelManager.getSpecializedType(this.metaModelManager.getTypeWithMultiplicity((TypedMultiplicityElement)operation), templateBindings);
        if (operation instanceof Iteration && "collect".equals(operation.getName()) && callExp instanceof LoopExp && returnType instanceof CollectionType && (body = ((LoopExp)callExp).getBody()) != null && (bodyType = PivotUtil.getBehavioralType((Type)body.getType())) instanceof CollectionType) {
            Type elementType = bodyType;
            while (elementType instanceof CollectionType) {
                elementType = ((CollectionType)elementType).getElementType();
            }
            boolean isOrdered = ((CollectionType)bodyType).isOrdered() && ((CollectionType)returnType).isOrdered();
            returnType = this.metaModelManager.getCollectionType(isOrdered, false, elementType);
        }
        ((CS2PivotConversion)this.context).setType((TypedElement)callExp, returnType);
    }

    protected OCLExpression resolvePropertyCallExp(NamedExpCS csNameExp, Property property) {
        OCLExpression source = this.resolveNavigationSource(csNameExp, (Feature)property);
        PropertyCallExp innerExpression = (PropertyCallExp)((CS2PivotConversion)this.context).refreshModelElement(PropertyCallExp.class, PivotPackage.Literals.PROPERTY_CALL_EXP, (ModelElementCS)csNameExp);
        innerExpression.setReferredProperty(property);
        ((CS2PivotConversion)this.context).setTypeWithMultiplicity((TypedElement)innerExpression, (TypedMultiplicityElement)property);
        CallExp outerExpression = this.resolveNavigationFeature(csNameExp, source, (Feature)property, (CallExp)innerExpression);
        if (outerExpression != innerExpression) {
            this.resolveOperationReturnType(outerExpression);
        }
        return outerExpression;
    }

    protected OCLExpression resolvePropertyNavigation(NamedExpCS csNamedExp) {
        NamedElement namedElement = csNamedExp.getNamedElement();
        if (namedElement == null || namedElement.eIsProxy()) {
            namedElement = this.getBadProperty();
            PropertyCallExp expression = (PropertyCallExp)((CS2PivotConversion)this.context).refreshModelElement(PropertyCallExp.class, PivotPackage.Literals.PROPERTY_CALL_EXP, (ModelElementCS)csNamedExp);
            expression.setReferredProperty(null);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getOclInvalidType());
            return expression;
        }
        if (namedElement instanceof Property) {
            return this.resolvePropertyCallExp(csNamedExp, (Property)namedElement);
        }
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNamedExp, "Property name expected");
    }

    protected TypeExp resolveTypeExp(ExpCS csExp, Type type) {
        TypeExp expression = (TypeExp)((CS2PivotConversion)this.context).refreshModelElement(TypeExp.class, PivotPackage.Literals.TYPE_EXP, (ModelElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getClassifierType(type));
        expression.setReferredType(type);
        return expression;
    }

    protected VariableExp resolveVariableExp(NameExpCS csNameExp, VariableDeclaration variableDeclaration) {
        VariableExp expression = (VariableExp)((CS2PivotConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (ModelElementCS)csNameExp);
        expression.setReferredVariable(variableDeclaration);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, variableDeclaration.getType());
        return expression;
    }

    public Element visitBinaryOperatorCS(BinaryOperatorCS csOperator) {
        OperationCallExp expression = (OperationCallExp)PivotUtil.getPivot(OperationCallExp.class, (Pivotable)csOperator);
        OCLExpression source = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csOperator.getSource());
        expression.setSource(source);
        OCLExpression argument = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csOperator.getArgument());
        ((CS2PivotConversion)this.context).refreshList((List)expression.getArgument(), Collections.singletonList(argument));
        this.resolveOperationCall(expression, csOperator, new BinaryOperationFilter(this.metaModelManager, source.getType(), argument.getType()));
        return expression;
    }

    public Element visitBooleanLiteralExpCS(BooleanLiteralExpCS csBooleanLiteralExp) {
        BooleanLiteralExp expression = (BooleanLiteralExp)PivotUtil.getPivot(BooleanLiteralExp.class, (Pivotable)csBooleanLiteralExp);
        expression.setBooleanSymbol(Boolean.valueOf(csBooleanLiteralExp.getName()).booleanValue());
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getBooleanType());
        return expression;
    }

    public Element visitCollectionLiteralExpCS(CollectionLiteralExpCS csCollectionLiteralExp) {
        Type commonType = null;
        for (CollectionLiteralPartCS csPart : csCollectionLiteralExp.getOwnedParts()) {
            CollectionLiteralPart pivotPart = (CollectionLiteralPart)((CS2PivotConversion)this.context).visitLeft2Right(CollectionLiteralPart.class, (VisitableCS)csPart);
            Type type = pivotPart.getType();
            commonType = commonType == null ? type : this.metaModelManager.getCommonType(commonType, type, null);
        }
        CollectionLiteralExp expression = (CollectionLiteralExp)PivotUtil.getPivot(CollectionLiteralExp.class, (Pivotable)csCollectionLiteralExp);
        CollectionTypeCS ownedCollectionType = csCollectionLiteralExp.getOwnedType();
        String collectionTypeName = ownedCollectionType.getName();
        TypedRefCS ownedElementType = ownedCollectionType.getOwnedType();
        if (ownedElementType != null) {
            commonType = (Type)ownedElementType.getPivot();
        }
        if (commonType == null) {
            commonType = this.metaModelManager.createUnspecifiedType();
        }
        Type type = this.metaModelManager.getLibraryType(collectionTypeName, Collections.singletonList(commonType));
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, type);
        expression.setKind(PivotUtil.getCollectionKind((CollectionType)((CollectionType)type)));
        return expression;
    }

    public Element visitCollectionLiteralPartCS(CollectionLiteralPartCS csCollectionLiteralPart) {
        OCLExpression pivotLast;
        CollectionItem expression;
        ExpCS csFirst = csCollectionLiteralPart.getExpressionCS();
        OCLExpression pivotFirst = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csFirst);
        ExpCS csLast = csCollectionLiteralPart.getLastExpressionCS();
        if (csLast == null) {
            expression = (CollectionItem)PivotUtil.getPivot(CollectionItem.class, (Pivotable)csCollectionLiteralPart);
            expression.setItem(pivotFirst);
        } else {
            expression = (CollectionRange)PivotUtil.getPivot(CollectionRange.class, (Pivotable)csCollectionLiteralPart);
            expression.setFirst(pivotFirst);
            pivotLast = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csLast);
            expression.setLast(pivotLast);
        }
        Type type = pivotFirst.getType();
        if (csLast != null) {
            pivotLast = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csLast);
            Type secondType = pivotLast.getType();
            type = this.metaModelManager.getCommonType(type, secondType, null);
        }
        CollectionLiteralPart expression2 = (CollectionLiteralPart)PivotUtil.getPivot(CollectionLiteralPart.class, (Pivotable)csCollectionLiteralPart);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression2, type);
        return expression2;
    }

    public Element visitCollectionTypeCS(CollectionTypeCS object) {
        return null;
    }

    public Element visitConstructorExpCS(ConstructorExpCS csConstructorExp) {
        ConstructorExp expression = (ConstructorExp)PivotUtil.getPivot(ConstructorExp.class, (Pivotable)csConstructorExp);
        expression.setType((Type)csConstructorExp.getNamedElement());
        for (ConstructorPartCS csPart : csConstructorExp.getOwnedParts()) {
            ((CS2PivotConversion)this.context).visitLeft2Right(ConstructorPart.class, (VisitableCS)csPart);
        }
        return expression;
    }

    public Element visitConstructorPartCS(ConstructorPartCS csConstructorPart) {
        ConstructorPart pivotElement = (ConstructorPart)PivotUtil.getPivot(ConstructorPart.class, (Pivotable)csConstructorPart);
        pivotElement.setReferredProperty(csConstructorPart.getProperty());
        OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csConstructorPart.getInitExpression());
        pivotElement.setInitExpression(initExpression);
        return pivotElement;
    }

    public Element visitContextCS(ContextCS csContext) {
        ExpressionInOCL pivotElement = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)csContext);
        ExpCS csExpression = csContext.getOwnedExpression();
        OCLExpression expression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csExpression);
        if (expression != null) {
            if (pivotElement.getBodyExpression() == null) {
                pivotElement.setBodyExpression(expression);
                ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, expression.getType());
            } else {
                pivotElement.setMessageExpression(expression);
            }
        }
        return pivotElement;
    }

    public Element visitExpCS(ExpCS object) {
        return null;
    }

    public Element visitExpSpecificationCS(ExpSpecificationCS object) {
        ExpressionInOCL pivotElement = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)object);
        pivotElement.getLanguage().add((Object)"OCL");
        OCLExpression expression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)object.getOwnedExpression());
        pivotElement.setBodyExpression(expression);
        return pivotElement;
    }

    public Element visitIfExpCS(IfExpCS csIfExp) {
        IfExp expression = (IfExp)PivotUtil.getPivot(IfExp.class, (Pivotable)csIfExp);
        expression.setCondition((OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csIfExp.getCondition()));
        OCLExpression thenExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csIfExp.getThenExpression());
        expression.setThenExpression(thenExpression);
        OCLExpression elseExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csIfExp.getElseExpression());
        expression.setElseExpression(elseExpression);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, this.metaModelManager.getCommonType(thenExpression.getType(), elseExpression.getType(), null));
        return expression;
    }

    public Element visitIndexExpCS(IndexExpCS csIndexExp) {
        return null;
    }

    public Element visitInfixExpCS(InfixExpCS csInfixExp) {
        OperatorCS csRoot = (OperatorCS)csInfixExp.getOwnedOperator().get(0);
        OperatorCS csParent = csRoot.getParent();
        while (csParent != null) {
            csRoot = csParent;
            csParent = csParent.getParent();
        }
        OCLExpression pivot = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csRoot);
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csInfixExp, (Element)pivot);
        return pivot;
    }

    public Element visitInvalidLiteralExpCS(InvalidLiteralExpCS csInvalidLiteralExp) {
        InvalidLiteralExp expression = (InvalidLiteralExp)PivotUtil.getPivot(InvalidLiteralExp.class, (Pivotable)csInvalidLiteralExp);
        if (expression == null) {
            expression = this.metaModelManager.createInvalidExpression();
        }
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csInvalidLiteralExp, (Element)expression);
        return expression;
    }

    public Element visitInvocationExpCS(InvocationExpCS csNavigatingExp) {
        OperatorCS csParent = csNavigatingExp.getParent();
        if (csParent instanceof NavigationOperatorCS && csNavigatingExp != csParent.getSource()) {
            return PivotUtil.getPivot(OCLExpression.class, (Pivotable)csNavigatingExp);
        }
        return this.resolveOperation(csNavigatingExp);
    }

    public Element visitLetExpCS(LetExpCS csLetExp) {
        OCLExpression firstLetExp = null;
        LetExp lastLetExp = null;
        for (LetVariableCS csLetVariable : csLetExp.getVariable()) {
            Type variableType;
            Variable variable = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csLetVariable);
            EObject variableContainer = variable.eContainer();
            LetExp letExp = variableContainer instanceof LetExp ? (LetExp)variableContainer : (LetExp)((CS2PivotConversion)this.context).refreshModelElement(LetExp.class, PivotPackage.Literals.LET_EXP, null);
            letExp.setVariable(variable);
            ExpCS csInitExpression = csLetVariable.getInitExpression();
            OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csInitExpression);
            variable.setInitExpression(initExpression);
            Type initType = initExpression != null ? initExpression.getType() : null;
            TypedRefCS csVariableType = csLetVariable.getOwnedType();
            Type type = variableType = csVariableType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csVariableType) : null;
            if (variableType == null) {
                variableType = initType;
            }
            ((CS2PivotConversion)this.context).setType((TypedElement)variable, variableType);
            if (lastLetExp != null) {
                lastLetExp.setIn((OCLExpression)letExp);
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csLetExp, (Element)letExp);
            } else {
                firstLetExp = letExp;
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csLetExp, (Element)firstLetExp);
            }
            lastLetExp = letExp;
        }
        if (lastLetExp != null) {
            OCLExpression in = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csLetExp.getIn());
            lastLetExp.setIn(in);
            Type type = in.getType();
            OCLExpression letExp = firstLetExp;
            while (letExp != in && letExp != null) {
                ((CS2PivotConversion)this.context).setType(letExp, type);
                letExp = ((LetExp)letExp).getIn();
            }
        }
        return firstLetExp;
    }

    public Element visitLetVariableCS(LetVariableCS csLetVariable) {
        return null;
    }

    public Element visitNameExpCS(NameExpCS csNameExp) {
        EObject eContainer = csNameExp.eContainer();
        if (eContainer instanceof InvocationExpCS) {
            EObject eContainerContainer = eContainer.eContainer();
            if (eContainerContainer instanceof NamedExpCS) {
                logger.warn((Object)("Unsupported '" + eContainerContainer.eClass().getName() + "' for () navigation"));
            }
            return null;
        }
        Element element = csNameExp.getPathName().getElement();
        if (element == null || element.eIsProxy()) {
            Element pivot = csNameExp.getPivot();
            if (pivot instanceof InvalidLiteralExp) {
                return pivot;
            }
            InvalidLiteralExp invalidLiteralExp = this.metaModelManager.createInvalidExpression();
            ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNameExp, (Element)invalidLiteralExp);
            return invalidLiteralExp;
        }
        if (element instanceof VariableDeclaration) {
            return this.resolveVariableExp(csNameExp, (VariableDeclaration)element);
        }
        if (element instanceof Property) {
            return this.resolvePropertyCallExp(csNameExp, (Property)element);
        }
        if (element instanceof Operation) {
            return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "No parameters for operation " + ((Operation)element).getName());
        }
        if (element instanceof Type) {
            return this.resolveTypeExp(csNameExp, (Type)element);
        }
        if (element instanceof EnumerationLiteral) {
            return this.resolveEnumLiteral(csNameExp, (EnumerationLiteral)element);
        }
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "Unsupported NameExpCS " + element.eClass().getName());
    }

    public Element visitNavigatingArgCS(NavigatingArgCS csNavigatingArg) {
        OCLExpression pivot = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csNavigatingArg.getName());
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNavigatingArg, (Element)pivot);
        return pivot;
    }

    public OCLExpression visitNavigationOperatorCS(NavigationOperatorCS csOperator) {
        OCLExpression sourceExp = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csOperator.getSource());
        OCLExpression navigatingExp = null;
        ExpCS argument = csOperator.getArgument();
        navigatingExp = argument instanceof InvocationExpCS ? this.resolveOperation((InvocationExpCS)argument) : (argument instanceof NamedExpCS ? this.resolvePropertyNavigation((NamedExpCS)argument) : ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)argument, "bad navigation argument"));
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csOperator, (Element)navigatingExp);
        return navigatingExp;
    }

    public Element visitNestedExpCS(NestedExpCS csNestedExp) {
        OCLExpression pivot = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csNestedExp.getSource());
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csNestedExp, (Element)pivot);
        return pivot;
    }

    public Element visitNullLiteralExpCS(NullLiteralExpCS csNullLiteralExp) {
        NullLiteralExp expression = (NullLiteralExp)PivotUtil.getPivot(NullLiteralExp.class, (Pivotable)csNullLiteralExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getOclVoidType());
        return expression;
    }

    public Element visitNumberLiteralExpCS(NumberLiteralExpCS csNumberLiteralExp) {
        NumericLiteralExp expression = (NumericLiteralExp)PivotUtil.getPivot(NumericLiteralExp.class, (Pivotable)csNumberLiteralExp);
        if (expression instanceof UnlimitedNaturalLiteralExp) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getUnlimitedNaturalType());
        } else if (expression instanceof IntegerLiteralExp) {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getIntegerType());
        } else {
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getRealType());
        }
        return expression;
    }

    public Element visitOperatorCS(OperatorCS object) {
        return null;
    }

    public Element visitPrefixExpCS(PrefixExpCS csPrefixExp) {
        UnaryOperatorCS csRoot = (UnaryOperatorCS)csPrefixExp.getOwnedOperator().get(0);
        if (!(csPrefixExp.eContainer() instanceof InfixExpCS)) {
            ((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csRoot);
        }
        OCLExpression pivotElement = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csRoot);
        ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csPrefixExp, (Element)pivotElement);
        return pivotElement;
    }

    public Element visitSelfExpCS(SelfExpCS csSelfExp) {
        VariableExp expression = (VariableExp)PivotUtil.getPivot(VariableExp.class, (Pivotable)csSelfExp);
        EnvironmentView environmentView = new EnvironmentView(this.metaModelManager, (EStructuralFeature)PivotPackage.Literals.EXPRESSION_IN_OCL__CONTEXT_VARIABLE, "self");
        ElementCS parent = csSelfExp.getLogicalParent();
        BaseScopeView.computeLookups((EnvironmentView)environmentView, (ElementCS)parent, (EObject)csSelfExp, (EStructuralFeature)csSelfExp.eContainingFeature(), null);
        VariableDeclaration variableDeclaration = (VariableDeclaration)environmentView.getContent();
        expression.setReferredVariable(variableDeclaration);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)(variableDeclaration != null ? variableDeclaration.getType() : this.metaModelManager.getOclVoidType()));
        return expression;
    }

    public Element visitStringLiteralExpCS(StringLiteralExpCS csStringLiteralExp) {
        StringLiteralExp pivotElement = (StringLiteralExp)PivotUtil.getPivot(StringLiteralExp.class, (Pivotable)csStringLiteralExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, (Type)this.metaModelManager.getStringType());
        return pivotElement;
    }

    public Element visitTupleLiteralExpCS(TupleLiteralExpCS csTupleLiteralExp) {
        TupleLiteralExp expression = (TupleLiteralExp)PivotUtil.getPivot(TupleLiteralExp.class, (Pivotable)csTupleLiteralExp);
        for (TupleLiteralPartCS csPart : csTupleLiteralExp.getOwnedParts()) {
            ((CS2PivotConversion)this.context).visitLeft2Right(TupleLiteralPart.class, (VisitableCS)csPart);
        }
        String tupleTypeName = "Tuple";
        TupleType type = this.metaModelManager.getTupleType(tupleTypeName, (Collection)expression.getPart(), null);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)type);
        return expression;
    }

    public Element visitTupleLiteralPartCS(TupleLiteralPartCS csTupleLiteralPart) {
        TupleLiteralPart pivotElement = (TupleLiteralPart)PivotUtil.getPivot(TupleLiteralPart.class, (Pivotable)csTupleLiteralPart);
        OCLExpression initExpression = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csTupleLiteralPart.getInitExpression());
        pivotElement.setInitExpression(initExpression);
        TypedRefCS csType = csTupleLiteralPart.getOwnedType();
        Type type = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : initExpression.getType();
        ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, type);
        return pivotElement;
    }

    public Element visitTypeLiteralExpCS(TypeLiteralExpCS csTypeLiteralExp) {
        TypedRefCS csType = csTypeLiteralExp.getOwnedType();
        Type type = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType);
        return this.resolveTypeExp(csTypeLiteralExp, type);
    }

    public Element visitUnaryOperatorCS(UnaryOperatorCS csOperator) {
        OperationCallExp expression = (OperationCallExp)PivotUtil.getPivot(OperationCallExp.class, (Pivotable)csOperator);
        OCLExpression source = (OCLExpression)((CS2PivotConversion)this.context).visitLeft2Right(OCLExpression.class, (VisitableCS)csOperator.getSource());
        expression.setSource(source);
        this.resolveOperationCall(expression, csOperator, new UnaryOperationFilter(this.metaModelManager, source.getType()));
        return expression;
    }

    public Element visitUnlimitedNaturalLiteralExpCS(UnlimitedNaturalLiteralExpCS csUnlimitedNaturalLiteralExp) {
        UnlimitedNaturalLiteralExp expression = (UnlimitedNaturalLiteralExp)PivotUtil.getPivot(UnlimitedNaturalLiteralExp.class, (Pivotable)csUnlimitedNaturalLiteralExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.metaModelManager.getUnlimitedNaturalType());
        return expression;
    }

    public Element visitVariableCS(VariableCS csVariable) {
        Variable variable = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csVariable);
        OCLExpression initExpression = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)csVariable.getInitExpression());
        TypedRefCS csType = csVariable.getOwnedType();
        Type type = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : initExpression.getType();
        variable.setInitExpression(initExpression);
        ((CS2PivotConversion)this.context).setType((TypedElement)variable, type);
        return variable;
    }
}

