/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.serializer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootPackageCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.ocl.examples.xtext.base.scoping.QualifiedPath;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.tokens.CrossReferenceSerializer;

public class EssentialOCLCrossReferenceSerializer
extends CrossReferenceSerializer {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private IValueConverterService valueConverter;

    protected String getCrossReferenceNameFromScope(EObject semanticObject, CrossReference crossref, EObject target, IScope scope, ISerializationDiagnostic.Acceptor errors) {
        Iterable elements;
        Iterator iterator;
        String ruleName = this.linkingHelper.getRuleNameFrom((EObject)crossref);
        if ("URI".equals(ruleName) && (iterator = (elements = scope.getElements(target)).iterator()).hasNext()) {
            IEObjectDescription desc = (IEObjectDescription)iterator.next();
            URI uri = URI.createURI((String)desc.getName().toString());
            URI baseURI = semanticObject.eResource().getURI();
            URI deresolvedURI = uri.deresolve(baseURI, true, true, false);
            return this.valueConverter.toString((Object)deresolvedURI.toString(), ruleName);
        }
        if (semanticObject instanceof PathElementCS) {
            PathElementCS pathElement = (PathElementCS)semanticObject;
            PathNameCS pathName = pathElement.getPathName();
            int index = pathName.getPath().indexOf((Object)pathElement);
            Element element = pathElement.getElement();
            NamedElement namedElement = ElementUtil.isPathable((EObject)element);
            if (namedElement != null) {
                String name = namedElement.getName();
                if (index == 0 && namedElement instanceof Package) {
                    String alias;
                    AliasAnalysis adapter;
                    Resource elementResource;
                    EObject root = EcoreUtil.getRootContainer((EObject)semanticObject);
                    Resource csResource = root.eResource();
                    Resource asResource = null;
                    if (root instanceof RootPackageCS) {
                        Element root2 = ((RootPackageCS)root).getPivot();
                        asResource = EcoreUtil.getRootContainer((EObject)root2).eResource();
                    }
                    if ((elementResource = namedElement.eResource()) != csResource && elementResource != asResource && (adapter = AliasAnalysis.getAdapter((Resource)csResource)) != null && (alias = adapter.getAlias((EObject)namedElement)) != null) {
                        name = alias;
                    }
                }
                return this.valueConverter.toString((Object)name, ruleName);
            }
            EObject eTarget = element.getETarget();
            URI uri = eTarget != null ? EcoreUtil.getURI((EObject)eTarget) : EcoreUtil.getURI((EObject)element);
            URI baseURI = semanticObject.eResource().getURI();
            URI deresolvedURI = uri.deresolve(baseURI, true, true, false);
            return this.valueConverter.toString((Object)deresolvedURI.toString(), ruleName);
        }
        boolean foundOne = false;
        List recordedErrros = null;
        Iterable elements2 = scope.getElements(target);
        if ("URI".equals(ruleName)) {
            Iterator<Object> iterator2 = elements2.iterator();
            if (iterator2.hasNext()) {
                IEObjectDescription desc = (IEObjectDescription)iterator2.next();
                foundOne = true;
                URI uri = URI.createURI((String)desc.getName().toString());
                URI baseURI = semanticObject.eResource().getURI();
                URI deresolvedURI = uri.deresolve(baseURI, true, true, false);
                return this.valueConverter.toString((Object)deresolvedURI.toString(), ruleName);
            }
        } else {
            for (IEObjectDescription desc : elements2) {
                foundOne = true;
                QualifiedName name = desc.getName();
                List segments = name instanceof QualifiedPath ? ((QualifiedPath)name).getSegments(semanticObject) : name.getSegments();
                int iMax = segments.size();
                String[] converted = new String[iMax];
                String unconverted = null;
                try {
                    int i = 0;
                    while (i < iMax) {
                        unconverted = (String)segments.get(i);
                        converted[i] = i > 0 && "UnrestrictedName".equals(ruleName) ? this.valueConverter.toString((Object)unconverted, "UnreservedName") : this.valueConverter.toString((Object)unconverted, ruleName);
                        ++i;
                    }
                    return this.qualifiedNameConverter.toString(new QualifiedName(converted){});
                }
                catch (ValueConverterException e) {
                    if (errors == null) continue;
                    if (recordedErrros == null) {
                        recordedErrros = Lists.newArrayList();
                    }
                    recordedErrros.add(this.diagnostics.getValueConversionExceptionDiagnostic(semanticObject, (AbstractElement)crossref, (Object)unconverted, (Throwable)e));
                }
            }
        }
        if (errors != null) {
            if (recordedErrros != null) {
                for (ISerializationDiagnostic diag : recordedErrros) {
                    errors.accept(diag);
                }
            }
            if (!foundOne) {
                errors.accept(this.diagnostics.getNoEObjectDescriptionFoundDiagnostic(semanticObject, crossref, target, scope));
            }
        }
        return null;
    }
}

