/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.services;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ExceptionAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.BaseScopeProvider;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2Moniker;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLLinkingService
extends DefaultLinkingService {
    private static int depth = -1;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        try {
            ++depth;
            String text = this.getText(node);
            boolean traceLookup = BaseScopeProvider.LOOKUP.isActive();
            if (text == null) {
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup null");
                }
                List<EObject> list = Collections.emptyList();
                return list;
            }
            IScope scope = null;
            String uri = "http://www.eclipse.org/xtext/common/JavaVMTypes";
            if (ref.getEReferenceType().getEPackage().getNsURI().equals(uri)) {
                scope = this.globalScopeProvider.getScope(context.eResource(), ref, null);
            } else {
                scope = this.getScope(context, ref);
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text);
                }
            }
            if (scope == null) {
                List<EObject> list = Collections.emptyList();
                return list;
            }
            QualifiedName qualifiedName = QualifiedName.create((String)text);
            ArrayList<EObject> linkedObjects = new ArrayList<EObject>();
            for (IEObjectDescription eObjectDescription : scope.getElements(qualifiedName)) {
                EObject eObjectOrProxy = eObjectDescription.getEObjectOrProxy();
                linkedObjects.add(eObjectOrProxy);
                if (!traceLookup) continue;
                if (eObjectOrProxy instanceof ModelElementCS) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " => " + CS2Moniker.toString((ElementCS)((ModelElementCS)eObjectOrProxy)));
                    continue;
                }
                BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " => " + eObjectOrProxy);
            }
            if (traceLookup) {
                BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " failed");
            }
            if (linkedObjects.size() > 1) {
                scope.getElements(qualifiedName);
                List<EObject> list = Collections.emptyList();
                return list;
            }
            if (linkedObjects.size() <= 0) {
                scope.getElements(qualifiedName);
            }
            ArrayList<EObject> arrayList = linkedObjects;
            return arrayList;
        }
        catch (IllegalLibraryException e) {
            context.eAdapters().add((Object)new ExceptionAdapter((Exception)((Object)e)));
            List<EObject> list = Collections.emptyList();
            return list;
        }
        finally {
            --depth;
        }
    }

    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = this.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        return scopeProvider.getScope(context, reference);
    }

    public String getText(INode node) {
        ILeafNode leafNode = ElementUtil.getLeafNode((INode)node);
        if (leafNode == null) {
            return null;
        }
        EObject grammarElement = leafNode.getGrammarElement();
        String ruleName = this.getLinkingHelper().getRuleNameFrom(grammarElement);
        return (String)this.valueConverterService.toValue(leafNode.getText(), ruleName, (INode)leafNode);
    }
}

