/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.services;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLValueConverterService
extends AbstractDeclarativeValueConverterService {
    private static DoubleQuotedStringConverter doubleQuotedStringConverter = null;
    private static EscapedIDConverter escapedIDConverter = null;
    private IDConverter idConverter = null;
    private static MultiLineSingleQuotedStringConverter multiLineSingleQuotedStringConverter = null;
    private NameConverter nameConverter = null;
    private static NumberConverter numberConverter = null;
    private static SimpleIDConverter simpleIDConverter = null;
    private static SingleQuotedStringConverter singleQuotedStringConverter = null;
    private static UnquotedStringConverter unquotedStringConverter = null;
    private UnreservedNameConverter unreservedNameConverter = null;
    private UnrestrictedNameConverter unrestrictedNameConverter = null;
    private static SingleQuotedStringConverter uriConverter = null;

    public static String escapeIdentifier(String value) {
        return "_'" + value + "'";
    }

    public static Set<String> getAllKeywords(Grammar g, String name) {
        HashSet<String> kws = new HashSet<String>();
        List rules = GrammarUtil.allParserRules((Grammar)g);
        for (ParserRule parserRule : rules) {
            if (!parserRule.getName().equals(name)) continue;
            EssentialOCLValueConverterService.getAllKeywords(kws, (AbstractRule)parserRule);
        }
        return kws;
    }

    private static void getAllKeywords(Set<String> kws, AbstractRule parserRule) {
        TreeIterator tit = parserRule.eAllContents();
        while (tit.hasNext()) {
            Object ele = tit.next();
            if (ele instanceof Keyword) {
                kws.add(((Keyword)ele).getValue());
                continue;
            }
            if (!(ele instanceof RuleCall)) continue;
            EssentialOCLValueConverterService.getAllKeywords(kws, ((RuleCall)ele).getRule());
        }
    }

    @ValueConverter(rule="DOUBLE_QUOTED_STRING")
    public IValueConverter<String> DOUBLE_QUOTED_STRING() {
        if (doubleQuotedStringConverter == null) {
            doubleQuotedStringConverter = new DoubleQuotedStringConverter();
        }
        return doubleQuotedStringConverter;
    }

    @ValueConverter(rule="ESCAPED_ID")
    public IValueConverter<String> ESCAPED_ID() {
        if (escapedIDConverter == null) {
            escapedIDConverter = new EscapedIDConverter();
        }
        return escapedIDConverter;
    }

    @ValueConverter(rule="ID")
    public IValueConverter<String> ID() {
        if (this.idConverter == null) {
            this.idConverter = new IDConverter(this.getGrammar());
        }
        return this.idConverter;
    }

    @ValueConverter(rule="Identifier")
    public IValueConverter<String> Identifier() {
        return this.ID();
    }

    @ValueConverter(rule="ML_SINGLE_QUOTED_STRING")
    public IValueConverter<String> ML_SINGLE_QUOTED_STRING() {
        if (multiLineSingleQuotedStringConverter == null) {
            multiLineSingleQuotedStringConverter = new MultiLineSingleQuotedStringConverter();
        }
        return multiLineSingleQuotedStringConverter;
    }

    @ValueConverter(rule="Name")
    public IValueConverter<String> Name() {
        if (this.nameConverter == null) {
            this.nameConverter = new NameConverter(this.getGrammar());
        }
        return this.nameConverter;
    }

    @ValueConverter(rule="NUMBER_LITERAL")
    public IValueConverter<Number> NUMBER_LITERAL() {
        if (numberConverter == null) {
            numberConverter = new NumberConverter();
        }
        return numberConverter;
    }

    @ValueConverter(rule="SIMPLE_ID")
    public IValueConverter<String> SIMPLE_ID() {
        if (simpleIDConverter == null) {
            simpleIDConverter = new SimpleIDConverter();
        }
        return simpleIDConverter;
    }

    @ValueConverter(rule="SINGLE_QUOTED_STRING")
    public IValueConverter<String> SINGLE_QUOTED_STRING() {
        if (singleQuotedStringConverter == null) {
            singleQuotedStringConverter = new SingleQuotedStringConverter();
        }
        return singleQuotedStringConverter;
    }

    @ValueConverter(rule="StringLiteral")
    public IValueConverter<String> StringLiteral() {
        return this.SINGLE_QUOTED_STRING();
    }

    @ValueConverter(rule="UNQUOTED_STRING")
    public IValueConverter<String> UNQUOTED_STRING() {
        if (unquotedStringConverter == null) {
            unquotedStringConverter = new UnquotedStringConverter();
        }
        return unquotedStringConverter;
    }

    @ValueConverter(rule="URI")
    public IValueConverter<String> URI() {
        if (uriConverter == null) {
            uriConverter = new SingleQuotedStringConverter();
        }
        return uriConverter;
    }

    @ValueConverter(rule="UnreservedName")
    public IValueConverter<String> UnreservedName() {
        if (this.unreservedNameConverter == null) {
            this.unreservedNameConverter = new UnreservedNameConverter(this.getGrammar());
        }
        return this.unreservedNameConverter;
    }

    @ValueConverter(rule="UnrestrictedName")
    public IValueConverter<String> UnrestrictedName() {
        if (this.unrestrictedNameConverter == null) {
            this.unrestrictedNameConverter = new UnrestrictedNameConverter(this.getGrammar());
        }
        return this.unrestrictedNameConverter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractIDConverter
    extends AbstractNullSafeConverter<String> {
        protected AbstractIDConverter() {
        }

        protected String internalToValue(String string, INode node) {
            int length = string.length();
            if (string.startsWith("_'") && length >= 3 && string.endsWith("'")) {
                return string.substring(2, length - 1);
            }
            if (string.startsWith("'") && length >= 2 && string.endsWith("'")) {
                return string.substring(1, length - 1);
            }
            if (string.startsWith("\"") && length >= 2 && string.endsWith("\"")) {
                return string.substring(1, length - 1);
            }
            return string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DoubleQuotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected DoubleQuotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                return PivotUtil.convertFromOCLString((String)string.substring(1, string.length() - 1));
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return String.valueOf('\"') + PivotUtil.convertToOCLString((String)value) + '\"';
        }
    }

    protected static class EscapedIDConverter
    extends AbstractIDConverter {
        protected EscapedIDConverter() {
        }

        protected String internalToString(String value) {
            return value;
        }
    }

    protected static class IDConverter
    extends AbstractIDConverter {
        private final Set<String> allKeywords;

        public IDConverter(Grammar grammar) {
            this.allKeywords = GrammarUtil.getAllKeywords((Grammar)grammar);
        }

        protected String internalToString(String value) {
            if (this.allKeywords.contains(value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtil.isValidIdentifier((String)value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MultiLineSingleQuotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected MultiLineSingleQuotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                return PivotUtil.convertFromOCLString((String)string.substring(2, string.length() - 2));
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return "'" + PivotUtil.convertToOCLString((String)value) + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NameConverter
    extends AbstractIDConverter {
        private final Set<String> nameKeywords;

        protected static Set<String> computeKeywords(Grammar grammar) {
            HashSet<String> keywords = new HashSet<String>(GrammarUtil.getAllKeywords((Grammar)grammar));
            keywords.removeAll(EssentialOCLValueConverterService.getAllKeywords(grammar, "UnrestrictedName"));
            keywords.removeAll(EssentialOCLValueConverterService.getAllKeywords(grammar, "EssentialOCLReservedKeyword"));
            keywords.removeAll(EssentialOCLValueConverterService.getAllKeywords(grammar, "RestrictedKeywords"));
            keywords.removeAll(EssentialOCLValueConverterService.getAllKeywords(grammar, "CollectionTypeIdentifier"));
            keywords.removeAll(EssentialOCLValueConverterService.getAllKeywords(grammar, "PrimitiveTypeIdentifier"));
            return keywords;
        }

        public NameConverter(Grammar grammar) {
            this.nameKeywords = NameConverter.computeKeywords(grammar);
        }

        protected String internalToString(String value) {
            if (this.nameKeywords.contains(value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtil.isValidIdentifier((String)value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NumberConverter
    implements IValueConverter<Number> {
        protected NumberConverter() {
        }

        public Number toValue(String string, INode node) {
            if (Strings.isEmpty((String)string)) {
                throw new ValueConverterException("Couldn't convert empty string to number", node, null);
            }
            try {
                if (string.contains(".") || string.contains("e") || string.contains("e")) {
                    return new BigDecimal(string);
                }
                return new BigInteger(string);
            }
            catch (NumberFormatException e) {
                throw new ValueConverterException("Couldn't convert '" + string + "' to number", node, (Exception)e);
            }
        }

        public String toString(Number value) {
            return value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SimpleIDConverter
    extends AbstractNullSafeConverter<String> {
        protected SimpleIDConverter() {
        }

        protected String internalToValue(String string, INode node) {
            return string;
        }

        protected String internalToString(String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SingleQuotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected SingleQuotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                return PivotUtil.convertFromOCLString((String)string.substring(1, string.length() - 1));
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return "'" + PivotUtil.convertToOCLString((String)value) + "'";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnquotedStringConverter
    extends AbstractNullSafeConverter<String> {
        protected UnquotedStringConverter() {
        }

        protected String internalToValue(String string, INode node) {
            try {
                return PivotUtil.convertFromOCLString((String)string.substring(1, string.length() - 1));
            }
            catch (IllegalArgumentException e) {
                throw new ValueConverterException(e.getMessage(), node, (Exception)e);
            }
        }

        protected String internalToString(String value) {
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnreservedNameConverter
    extends AbstractIDConverter {
        private final Set<String> reservedKeywords;

        protected static Set<String> computeReservedKeywords(Grammar grammar) {
            HashSet<String> keywords = new HashSet<String>(GrammarUtil.getAllKeywords((Grammar)grammar));
            Set<String> unreservedNames = EssentialOCLValueConverterService.getAllKeywords(grammar, "UnreservedName");
            keywords.removeAll(unreservedNames);
            return keywords;
        }

        public UnreservedNameConverter(Grammar grammar) {
            this.reservedKeywords = UnreservedNameConverter.computeReservedKeywords(grammar);
        }

        protected String internalToString(String value) {
            if (this.reservedKeywords.contains(value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtil.isValidIdentifier((String)value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class UnrestrictedNameConverter
    extends AbstractIDConverter {
        private final Set<String> restrictedKeywords;

        protected static Set<String> computeRestrictedKeywords(Grammar grammar) {
            HashSet<String> keywords = new HashSet<String>(GrammarUtil.getAllKeywords((Grammar)grammar));
            Set<String> unrestrictedNames = EssentialOCLValueConverterService.getAllKeywords(grammar, "UnrestrictedName");
            keywords.removeAll(unrestrictedNames);
            return keywords;
        }

        public UnrestrictedNameConverter(Grammar grammar) {
            this.restrictedKeywords = UnrestrictedNameConverter.computeRestrictedKeywords(grammar);
        }

        protected String internalToString(String value) {
            if (this.restrictedKeywords.contains(value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            if (!PivotUtil.isValidIdentifier((String)value)) {
                return EssentialOCLValueConverterService.escapeIdentifier(value);
            }
            return value;
        }
    }
}

