/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui.model;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.uml.UML2Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotResourceFactoryImpl;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.oclinecore.ui.OCLinEcoreUiPluginHelper;
import org.eclipse.ocl.examples.xtext.oclinecore.ui.model.OCLinEcoreDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;

public class OCLinEcoreDocumentProvider
extends XtextDocumentProvider {
    private static final Logger log = Logger.getLogger(OCLinEcoreDocumentProvider.class);
    public static final String PERSIST_AS_ECORE = "as-ecore";
    public static final String PERSIST_IN_ECORE = "in-ecore";
    public static final String PERSIST_AS_PIVOT = "pivot";
    public static final String PERSIST_AS_OCLINECORE = "oclinecore";
    public static final String PERSIST_AS_UML = "uml";
    private Map<IDocument, String> loadedAsMap = new HashMap<IDocument, String>();
    private Map<IDocument, String> saveAsMap = new HashMap<IDocument, String>();
    private Map<IDocument, URI> uriMap = new HashMap<IDocument, URI>();
    private final MetaModelManager metaModelManager = new MetaModelManager();

    public static InputStream createResettableInputStream(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int len;
            byte[] buffer = new byte[4096];
            while ((len = inputStream.read(buffer, 0, buffer.length)) > 0) {
                outputStream.write(buffer, 0, len);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            outputStream.close();
        }
    }

    protected void diagnoseErrors(XtextResource xtextResource, Exception e) throws CoreException {
        List diagnostics = xtextResource.validateConcreteSyntax();
        if (diagnostics.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append("Concrete Syntax validation failed");
            for (Diagnostic diagnostic : diagnostics) {
                s.append("\n");
                s.append(diagnostic.toString());
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", s.toString(), (Throwable)e));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", "Failed to load", (Throwable)e));
    }

    private void diagnoseErrors(Resource resource) throws CoreException {
        EList errors = resource.getErrors();
        if (errors.size() > 0) {
            String formattedMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)"Failed to load", (String)"\n");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", formattedMessage));
        }
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        String saveAs = this.saveAsMap.get(document);
        if (element instanceof IFileEditorInput && document instanceof OCLinEcoreDocument && !PERSIST_AS_OCLINECORE.equals(saveAs)) {
            StringWriter xmlWriter = new StringWriter();
            try {
                URI uri = EditUIUtil.getURI((IEditorInput)((IFileEditorInput)element));
                if (PERSIST_AS_ECORE.equals(saveAs)) {
                    ((OCLinEcoreDocument)document).saveAsEcore(xmlWriter, uri);
                } else if (PERSIST_IN_ECORE.equals(saveAs)) {
                    ((OCLinEcoreDocument)document).saveInEcore(xmlWriter, uri);
                } else if (PERSIST_AS_PIVOT.equals(saveAs)) {
                    ((OCLinEcoreDocument)document).saveAsPivot(xmlWriter);
                } else if (PERSIST_AS_UML.equals(saveAs)) {
                    ((OCLinEcoreDocument)document).saveAsUML(xmlWriter, uri);
                } else {
                    log.warn((Object)("Unknown saveAs '" + saveAs + "'"));
                }
                Document saveDocument = new Document();
                saveDocument.set(xmlWriter.toString());
                super.doSaveDocument(monitor, element, (IDocument)saveDocument, overwrite);
                this.loadedAsMap.put(document, saveAs);
            }
            catch (Exception e) {
                OCLinEcoreUiPluginHelper helper = OCLinEcoreUiPluginHelper.INSTANCE;
                String title = helper.getString("_UI_SaveFailure_title", true);
                String message = helper.getString("_UI_SaveFailure_message", true);
                ErrorDialog.openError(null, (String)title, (String)message, (IStatus)helper.createErrorStatus(e));
                monitor.setCanceled(true);
            }
        } else {
            super.doSaveDocument(monitor, element, document, overwrite);
        }
    }

    public boolean isDeleted(Object element) {
        IDocument document = this.getDocument(element);
        String loadIsEcore = this.loadedAsMap.get(document);
        String saveIsEcore = this.saveAsMap.get(document);
        if (loadIsEcore != null && !loadIsEcore.equals(saveIsEcore)) {
            return true;
        }
        return super.isDeleted(element);
    }

    protected boolean isXML(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line = reader.readLine();
            inputStream.reset();
            boolean bl = line != null && line.startsWith("<?xml");
            return bl;
        }
        finally {
            reader.close();
        }
    }

    protected void loadResource(XtextResource resource, String document, String encoding) throws CoreException {
        MetaModelManagerResourceAdapter.getAdapter((Resource)resource, (MetaModelManager)this.metaModelManager);
        super.loadResource(resource, document, encoding);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        URI uri = EditUIUtil.getURI((IEditorInput)editorInput);
        this.uriMap.put(document, uri);
        return super.setDocumentContent(document, editorInput, encoding);
    }

    protected void setDocumentContent(IDocument document, InputStream inputStream, String encoding) throws CoreException {
        try {
            if (!inputStream.markSupported()) {
                inputStream = OCLinEcoreDocumentProvider.createResettableInputStream(inputStream);
            }
            boolean isXML = this.isXML(inputStream);
            String persistAs = PERSIST_AS_OCLINECORE;
            if (isXML) {
                ResourceSet resourceSet = this.metaModelManager.getExternalResourceSet();
                URI uri = this.uriMap.get(document);
                Resource xmiResource = resourceSet.createResource(uri, null);
                xmiResource.load(inputStream, null);
                ArrayList allErrors = null;
                for (Resource resource : resourceSet.getResources()) {
                    EList errors = resource.getErrors();
                    if (errors.size() <= 0) continue;
                    if (allErrors == null) {
                        allErrors = new ArrayList();
                    }
                    allErrors.addAll(errors);
                }
                if (allErrors != null) {
                    StringBuilder s = new StringBuilder();
                    for (Resource.Diagnostic diagnostic : allErrors) {
                        s.append("\n");
                        s.append(diagnostic.toString());
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", s.toString()));
                }
                Resource pivotResource = null;
                if (xmiResource.getContents().size() > 0) {
                    org.eclipse.ocl.examples.pivot.Package pivotRoot;
                    EObject xmiRoot = (EObject)xmiResource.getContents().get(0);
                    if (xmiRoot instanceof EPackage) {
                        Ecore2Pivot ecore2Pivot = Ecore2Pivot.getAdapter((Resource)xmiResource, (MetaModelManager)this.metaModelManager);
                        pivotRoot = ecore2Pivot.getPivotRoot();
                        pivotResource = pivotRoot.eResource();
                        this.diagnoseErrors(pivotResource);
                        persistAs = PERSIST_AS_ECORE;
                    } else if (xmiRoot instanceof org.eclipse.ocl.examples.pivot.Package) {
                        pivotResource = xmiResource;
                        persistAs = PERSIST_AS_PIVOT;
                    } else if (xmiRoot instanceof Package) {
                        UML2Ecore2Pivot uml2Pivot = UML2Ecore2Pivot.getAdapter((Resource)xmiResource, (MetaModelManager)this.metaModelManager);
                        pivotRoot = uml2Pivot.getPivotRoot();
                        pivotResource = pivotRoot.eResource();
                        persistAs = PERSIST_AS_OCLINECORE;
                    }
                }
                ResourceSet csResourceSet = resourceSet;
                csResourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/ocl/3.1.0/Pivot", (Object)PivotPackage.eINSTANCE);
                URI oclinecoreURI = xmiResource.getURI().appendFileExtension(PERSIST_AS_OCLINECORE);
                BaseResource csResource = (BaseResource)resourceSet.createResource(oclinecoreURI, "org.eclipse.ocl.examples.xtext.oclinecore");
                csResource.setURI(xmiResource.getURI());
                csResource.updateFrom(pivotResource, this.metaModelManager);
                BaseResource xtextResource = csResource;
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    xtextResource.save((OutputStream)outputStream, null);
                }
                catch (IConcreteSyntaxValidator.InvalidConcreteSyntaxException e) {
                    this.diagnoseErrors((XtextResource)xtextResource, (Exception)((Object)e));
                }
                catch (XtextSerializationException e) {
                    this.diagnoseErrors((XtextResource)xtextResource, (Exception)((Object)e));
                }
                xtextResource.unload();
                resourceSet.getResources().remove((Object)xtextResource);
                inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            } else if (inputStream.available() == 0) {
                URI uri = this.uriMap.get(document);
                Resource.Factory factory = Resource.Factory.Registry.INSTANCE.getFactory(uri);
                if (factory instanceof EcoreResourceFactoryImpl) {
                    persistAs = PERSIST_AS_ECORE;
                } else if (factory instanceof PivotResourceFactoryImpl) {
                    persistAs = PERSIST_AS_PIVOT;
                }
                String lastSegment = uri.trimFileExtension().lastSegment();
                if (lastSegment == null) {
                    lastSegment = "Default";
                }
                String testDocument = "package " + lastSegment + " : pfx = '" + uri + "' {\n" + "}\n";
                inputStream = new ByteArrayInputStream(testDocument.getBytes());
            }
            this.loadedAsMap.put(document, persistAs);
            this.saveAsMap.put(document, persistAs);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ocl.examples.common", "Failed to load", (Throwable)e));
        }
        super.setDocumentContent(document, inputStream, encoding);
    }

    public void setPersistAs(Object element, String persistAs) {
        this.saveAsMap.put(this.getDocument(element), persistAs);
        this.setCanSaveDocument(element);
    }
}

