/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.common.internal.delegate;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.ocl.common.delegate.VirtualDelegateMapping;
import org.eclipse.ocl.common.internal.options.CommonOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLValidationDelegateMapping
implements EValidator.ValidationDelegate {
    protected final EValidator.ValidationDelegate.Registry validationDelegateRegistry;
    protected final VirtualDelegateMapping virtualDelegateMapping;
    private EValidator.ValidationDelegate delegate = null;

    public OCLValidationDelegateMapping() {
        this(EValidator.ValidationDelegate.Registry.INSTANCE, CommonOptions.DEFAULT_DELEGATION_MODE);
    }

    public OCLValidationDelegateMapping(EValidator.ValidationDelegate.Registry validationDelegateRegistry, VirtualDelegateMapping virtualDelegateMapping) {
        this.validationDelegateRegistry = validationDelegateRegistry;
        this.virtualDelegateMapping = virtualDelegateMapping;
    }

    public void reset() {
        this.delegate = null;
    }

    protected EValidator.ValidationDelegate resolveDelegate(Map<Object, Object> context) {
        String delegatedURI = (String)this.virtualDelegateMapping.getDefaultValue();
        return this.validationDelegateRegistry.getValidationDelegate(delegatedURI);
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        if (this.delegate == null) {
            this.delegate = this.resolveDelegate(context);
            if (this.delegate == null) {
                return false;
            }
        }
        return this.delegate.validate(eClass, eObject, context, invariant, expression);
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraint, String expression) {
        if (this.delegate == null) {
            this.delegate = this.resolveDelegate(context);
            if (this.delegate == null) {
                return false;
            }
        }
        return this.delegate.validate(eClass, eObject, context, constraint, expression);
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraint, String expression) {
        if (this.delegate == null) {
            this.delegate = this.resolveDelegate(context);
            if (this.delegate == null) {
                return false;
            }
        }
        return this.delegate.validate(eDataType, value, context, constraint, expression);
    }
}

