/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.TupleValue;

public abstract class AbstractConstraintEvaluator<T> {
    @NonNull
    protected final ExpressionInOCL query;
    @NonNull
    protected final OCLExpression body;

    @NonNull
    public static OCLExpression getConstraintExpression(@NonNull ExpressionInOCL query) {
        PropertyCallExp propertyCallExp;
        Property referredProperty;
        OCLExpression body = query.getOwnedBody();
        if (body instanceof PropertyCallExp && (referredProperty = (propertyCallExp = (PropertyCallExp)body).getReferredProperty()) != null && referredProperty.getOwningClass() instanceof TupleType && "status".equals(referredProperty.getName())) {
            body = propertyCallExp.getOwnedSource();
        }
        return ClassUtil.nonNullState(body);
    }

    public AbstractConstraintEvaluator(@NonNull ExpressionInOCL query) {
        this.query = query;
        this.body = AbstractConstraintEvaluator.getConstraintExpression(query);
    }

    public T evaluate(@NonNull EvaluationVisitor evaluationVisitor) {
        if (this.query.getOwnedContext() == null && this.body instanceof StringLiteralExp) {
            String stringSymbol = ((StringLiteralExp)this.body).getStringSymbol();
            return this.handleInvalidExpression(stringSymbol);
        }
        Object result = null;
        boolean status = false;
        try {
            result = this.body.accept(evaluationVisitor);
            status = this.getConstraintResultStatus(result);
        }
        catch (InvalidValueException e) {
            return this.handleInvalidResult(e);
        }
        catch (Throwable e) {
            return this.handleExceptionResult(e);
        }
        if (status) {
            return this.handleSuccessResult();
        }
        return this.handleFailureResult(result);
    }

    protected String getConstraintName() {
        Constraint constraint = PivotUtil.getContainingConstraint(this.query);
        if (constraint != null) {
            return constraint.getName();
        }
        return "<<unknown>>";
    }

    @NonNull
    protected String getConstraintResultMessage(@Nullable Object result) {
        if (result instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)result;
            TupleTypeId tupleTypeId = tupleValue.getTypeId();
            TuplePartId messagePartId = tupleTypeId.getPartId("message");
            if (messagePartId != null) {
                String string = String.valueOf(tupleValue.getValue(messagePartId));
                return string;
            }
        } else if (result == null) {
            return StringUtil.bind(PivotMessagesInternal.ValidationResultIsNull_ERROR_, this.getConstraintTypeName(), this.getConstraintName(), this.getObjectLabel());
        }
        return StringUtil.bind(PivotMessages.ValidationConstraintIsNotSatisfied_ERROR_, String.valueOf(this.getConstraintTypeName()) + "::" + this.getConstraintName(), this.getObjectLabel());
    }

    protected int getConstraintResultSeverity(@Nullable Object result) {
        if (result instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)result;
            TupleTypeId tupleTypeId = tupleValue.getTypeId();
            TuplePartId severityPartId = tupleTypeId.getPartId("severity");
            if (severityPartId != null) {
                IntegerValue value = ValueUtil.integerValueOf(tupleValue.getValue(severityPartId));
                int signum = value.signum();
                if (signum < 0) {
                    return 4;
                }
                if (signum == 0) {
                    return 1;
                }
                return 2;
            }
            TuplePartId statusPartId = tupleTypeId.getPartId("status");
            if (statusPartId != null) {
                result = tupleValue.getValue(statusPartId);
            }
        }
        return result == null ? 4 : 2;
    }

    protected boolean getConstraintResultStatus(@Nullable Object result) {
        if (result == Boolean.TRUE) {
            return true;
        }
        if (result instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)result;
            TupleTypeId tupleTypeId = tupleValue.getTypeId();
            TuplePartId statusPartId = tupleTypeId.getPartId("status");
            if (statusPartId == null) {
                return false;
            }
            Object value = tupleValue.getValue(statusPartId);
            if (value == Boolean.TRUE) {
                return true;
            }
        }
        return false;
    }

    protected String getConstraintTypeName() {
        Type type = PivotUtil.getContainingType(this.query);
        if (type != null) {
            return type.getName();
        }
        return "<<unknown>>";
    }

    protected abstract String getObjectLabel();

    protected abstract T handleExceptionResult(@NonNull Throwable var1);

    protected abstract T handleFailureResult(@Nullable Object var1);

    protected abstract T handleInvalidExpression(@NonNull String var1);

    protected abstract T handleInvalidResult(@NonNull InvalidValueException var1);

    protected abstract T handleSuccessResult();

    protected boolean isBooleanConstraint() {
        TypeId typeId = this.query.getTypeId();
        return typeId == TypeId.BOOLEAN;
    }
}

