/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.LoopExpImpl;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionExcludingOperation;
import org.eclipse.ocl.pivot.library.collection.CollectionSizeOperation;
import org.eclipse.ocl.pivot.library.iterator.ClosureIteration;
import org.eclipse.ocl.pivot.library.iterator.SortedByIteration;
import org.eclipse.ocl.pivot.library.logical.BooleanAndOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanNotOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanOrOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.pivot.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.validation.ValidationWarning;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OCLValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.TemplateParameterSubstitutions;

public class IteratorExpImpl
extends LoopExpImpl
implements IteratorExp {
    protected IteratorExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.ITERATOR_EXP;
    }

    @Override
    public boolean validateClosureBodyTypeIsConformanttoIteratorType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Type iteratorType;
        Type bodyType2;
        if (this.getReferredIteration().getImplementation() != ClosureIteration.INSTANCE) {
            return true;
        }
        ValidationWarning diagnostic = null;
        Resource asResource = ClassUtil.nonNullState(this.eResource());
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(asResource);
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Type bodyType = this.getOwnedBody().getType();
        if (bodyType instanceof CollectionType) {
            bodyType = ((CollectionType)bodyType).getElementType();
        }
        if (!metamodelManager.conformsTo(bodyType2 = ClassUtil.nonNullState(bodyType), TemplateParameterSubstitutions.EMPTY, iteratorType = ClassUtil.nonNullState(this.getOwnedIterators().get(0).getType()), TemplateParameterSubstitutions.EMPTY)) {
            if (diagnostics == null) {
                return false;
            }
            diagnostic = new ValidationWarning(PivotMessagesInternal.IncompatibleBodyType_WARNING_, bodyType2, iteratorType);
        }
        if (diagnostic == null) {
            return true;
        }
        diagnostics.add(diagnostic);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateSortedByIteratorTypeIsComparable(DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationWarning diagnostic;
        block11: {
            if (this.getReferredIteration().getImplementation() != SortedByIteration.INSTANCE) {
                return true;
            }
            diagnostic = null;
            Resource asResource = ClassUtil.nonNullState(this.eResource());
            EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(asResource);
            StandardLibraryInternal standardLibrary = environmentFactory.getStandardLibrary();
            try {
                Class oclComparableType = standardLibrary.getOclComparableType();
                CompleteInheritance comparableInheritance = oclComparableType.getInheritance(standardLibrary);
                CompleteInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
                Operation staticOperation = comparableInheritance.lookupLocalOperation(standardLibrary, "compareTo", selfType);
                if (staticOperation == null) {
                    if (diagnostics == null) {
                        return false;
                    }
                    diagnostic = new ValidationWarning(PivotMessagesInternal.UnresolvedOperation_ERROR_, String.valueOf(comparableInheritance), "compareTo");
                    break block11;
                }
                OCLExpression source2 = this.getOwnedSource();
                OCLExpression body2 = this.getOwnedBody();
                Type sourceType = source2.getType();
                Type sourceTypeValue = source2.getTypeValue();
                Type bodyType = body2.getType();
                Type specializedBodyType = bodyType != null ? TemplateParameterSubstitutionVisitor.specializeType(bodyType, this, environmentFactory, sourceType, sourceTypeValue) : null;
                boolean isOk = false;
                if (bodyType != null) {
                    PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
                    if (specializedBodyType != null && metamodelManager.conformsTo(specializedBodyType, TemplateParameterSubstitutions.EMPTY, oclComparableType, TemplateParameterSubstitutions.EMPTY)) {
                        isOk = true;
                    }
                }
                if (!isOk) {
                    if (diagnostics == null) {
                        return false;
                    }
                    diagnostic = new ValidationWarning(PivotMessagesInternal.UnresolvedOperation_ERROR_, String.valueOf(specializedBodyType), "compareTo");
                }
            }
            catch (Exception e) {
                if (diagnostics == null) {
                    return false;
                }
                diagnostic = new ValidationWarning(e.getLocalizedMessage(), new Object[0]);
            }
        }
        if (diagnostic == null) {
            return true;
        }
        diagnostics.add((Diagnostic)diagnostic);
        return false;
    }

    @Override
    public boolean validateUnsafeSourceCanNotBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::UnsafeSourceCanNotBeNull");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_isNullFree;
                Serializable CAUGHT_and;
                try {
                    Serializable CAUGHT_exists;
                    Serializable CAUGHT_not;
                    try {
                        Boolean isSafe = this.isIsSafe();
                        Boolean not = BooleanNotOperation.INSTANCE.evaluate(isSafe);
                        CAUGHT_not = not;
                    }
                    catch (Exception e) {
                        CAUGHT_not = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        boolean exists;
                        List<Variable> ownedIterators = this.getOwnedIterators();
                        OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                        OrderedSetValue safe_null_sources = (OrderedSetValue)CollectionExcludingOperation.INSTANCE.evaluate(BOXED_ownedIterators, null);
                        Comparable<Boolean> accumulator = ValueUtil.FALSE_VALUE;
                        Iterator<Object> ITERATOR__1 = safe_null_sources.iterator();
                        while (true) {
                            Serializable CAUGHT_isRequired;
                            if (!ITERATOR__1.hasNext()) {
                                if (accumulator == ValueUtil.FALSE_VALUE) {
                                    exists = ValueUtil.FALSE_VALUE;
                                    break;
                                }
                                throw (InvalidValueException)accumulator;
                            }
                            Variable _1 = (Variable)ITERATOR__1.next();
                            try {
                                boolean isRequired = _1.isIsRequired();
                                CAUGHT_isRequired = Boolean.valueOf(isRequired);
                            }
                            catch (Exception e) {
                                CAUGHT_isRequired = ValueUtil.createInvalidValue(e);
                            }
                            if (CAUGHT_isRequired == ValueUtil.TRUE_VALUE) {
                                exists = ValueUtil.TRUE_VALUE;
                                break;
                            }
                            if (CAUGHT_isRequired == ValueUtil.FALSE_VALUE) continue;
                            if (CAUGHT_isRequired instanceof InvalidValueException) {
                                accumulator = CAUGHT_isRequired;
                                continue;
                            }
                            accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "exists");
                        }
                        CAUGHT_exists = Boolean.valueOf(exists);
                    }
                    catch (Exception e) {
                        CAUGHT_exists = ValueUtil.createInvalidValue(e);
                    }
                    Boolean and = BooleanAndOperation.INSTANCE.evaluate(CAUGHT_not, CAUGHT_exists);
                    CAUGHT_and = and;
                }
                catch (Exception e) {
                    CAUGHT_and = ValueUtil.createInvalidValue(e);
                }
                try {
                    Type safe_type_source;
                    Object CAUGHT_ownedSource;
                    Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    OCLExpression ownedSource = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource = ownedSource;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type;
                        assert (ownedSource != null);
                        safe_type_source = type = ownedSource.getType();
                    }
                    CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_CollectionType_0));
                    boolean isNullFree = oclAsType.isIsNullFree();
                    CAUGHT_isNullFree = Boolean.valueOf(isNullFree);
                }
                catch (Exception e) {
                    CAUGHT_isNullFree = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_and, CAUGHT_isNullFree);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::UnsafeSourceCanNotBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateAnyHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::AnyHasOneIterator");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "any".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    List<Variable> ownedIterators = this.getOwnedIterators();
                    OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate(BOXED_ownedIterators);
                    boolean eq_0 = size.equals(PivotTables.INT_1);
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::AnyHasOneIterator", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateAnyTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_2;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::AnyTypeIsSourceElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_2 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "any".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    CollectionType safe_oclAsType_source;
                    OCLValue CAUGHT_safe_type_source;
                    Type safe_type_source;
                    Object CAUGHT_ownedSource;
                    Type type = this.getType();
                    OCLExpression ownedSource = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource = ownedSource;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_0;
                        assert (ownedSource != null);
                        safe_type_source = type_0 = ownedSource.getType();
                    }
                    try {
                        CAUGHT_safe_type_source = safe_type_source;
                    }
                    catch (Exception e) {
                        CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_1 = CAUGHT_safe_type_source == null;
                    if (symbol_1 == Boolean.TRUE) {
                        safe_oclAsType_source = null;
                    } else {
                        CollectionType oclAsType;
                        Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                        safe_oclAsType_source = oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_CollectionType_0));
                    }
                    if (safe_oclAsType_source == null) {
                        throw new InvalidValueException("Null source for 'CollectionType::elementType'", new Object[0]);
                    }
                    Type elementType = safe_oclAsType_source.getElementType();
                    boolean eq_0 = type != null ? type.getTypeId() == elementType.getTypeId() : false;
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_2 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::AnyTypeIsSourceElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_2;
    }

    @Override
    public boolean validateAnyBodyTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        IntegerValue severity_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::AnyBodyTypeIsBoolean"), PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "any".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    OCLExpression ownedBody = this.getOwnedBody();
                    Type type = ownedBody.getType();
                    boolean eq_0 = "Boolean".equals(type);
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::AnyBodyTypeIsBoolean", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateClosureHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::ClosureHasOneIterator");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "closure".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    List<Variable> ownedIterators = this.getOwnedIterators();
                    OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate(BOXED_ownedIterators);
                    boolean eq_0 = size.equals(PivotTables.INT_1);
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::ClosureHasOneIterator", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateClosureTypeIsUniqueCollection(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_4;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::ClosureTypeIsUniqueCollection");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_4 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_symbol_3;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "closure".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    boolean symbol_3;
                    Serializable CAUGHT_oclIsKindOf_0;
                    InvalidValueException CAUGHT_safe_oclIsKindOf_source;
                    Type type_2 = this.getType();
                    try {
                        Boolean safe_oclIsKindOf_source;
                        OCLValue CAUGHT_safe_type_source;
                        Type safe_type_source;
                        Object CAUGHT_ownedSource;
                        OCLExpression ownedSource = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource = ownedSource;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_0 = CAUGHT_ownedSource == null;
                        if (symbol_0 == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type;
                            assert (ownedSource != null);
                            safe_type_source = type = ownedSource.getType();
                        }
                        try {
                            CAUGHT_safe_type_source = safe_type_source;
                        }
                        catch (Exception e) {
                            CAUGHT_safe_type_source = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_1 = CAUGHT_safe_type_source == null;
                        if (symbol_1 == Boolean.TRUE) {
                            safe_oclIsKindOf_source = null;
                        } else {
                            Class TYP_SequenceType_0 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                            boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_SequenceType_0);
                            safe_oclIsKindOf_source = oclIsKindOf;
                        }
                        CAUGHT_safe_oclIsKindOf_source = safe_oclIsKindOf_source;
                    }
                    catch (Exception e) {
                        CAUGHT_safe_oclIsKindOf_source = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Type safe_type_source_0;
                        Object CAUGHT_ownedSource_0;
                        Class TYP_OrderedSetType_0 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        OCLExpression ownedSource_0 = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource_0 = ownedSource_0;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource_0 = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_2 = CAUGHT_ownedSource_0 == null;
                        if (symbol_2 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_0;
                            assert (ownedSource_0 != null);
                            safe_type_source_0 = type_0 = ownedSource_0.getType();
                        }
                        boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, safe_type_source_0, TYP_OrderedSetType_0);
                        CAUGHT_oclIsKindOf_0 = Boolean.valueOf(oclIsKindOf_0);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf_0 = ValueUtil.createInvalidValue(e);
                    }
                    Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_safe_oclIsKindOf_source, CAUGHT_oclIsKindOf_0);
                    if (or == null) {
                        throw new InvalidValueException("Null if condition", new Object[0]);
                    }
                    if (or.booleanValue()) {
                        boolean oclIsKindOf_1;
                        Class TYP_OrderedSetType_1 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        symbol_3 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_OrderedSetType_1).booleanValue();
                    } else {
                        boolean oclIsKindOf_2;
                        Class TYP_SetType_0 = idResolver.getClass(PivotTables.CLSSid_SetType, null);
                        symbol_3 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_SetType_0).booleanValue();
                    }
                    CAUGHT_symbol_3 = Boolean.valueOf(symbol_3);
                }
                catch (Exception e) {
                    CAUGHT_symbol_3 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_symbol_3);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_4 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::ClosureTypeIsUniqueCollection", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_4;
    }

    @Override
    public boolean validateCollectElementTypeIsFlattenedBodyType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::CollectElementTypeIsFlattenedBodyType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "collect".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    Type type = this.getType();
                    CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, type, TYP_CollectionType_0));
                    Type elementType = oclAsType.getElementType();
                    OCLExpression ownedBody = this.getOwnedBody();
                    Type type_0 = ownedBody.getType();
                    if (type_0 == null) {
                        throw new InvalidValueException("Null source for 'pivot::Type::flattenedType() : Type[?]'", new Object[0]);
                    }
                    Type flattenedType = type_0.flattenedType();
                    boolean eq_0 = elementType.getTypeId() == flattenedType.getTypeId();
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::CollectElementTypeIsFlattenedBodyType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateClosureSourceElementTypeIsBodyElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_2;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::ClosureSourceElementTypeIsBodyElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_2 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "closure".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    Type symbol_1;
                    Type safe_type_source;
                    Object CAUGHT_ownedSource;
                    Class TYP_CollectionType_1 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    OCLExpression ownedBody_1 = this.getOwnedBody();
                    Type type_2 = ownedBody_1.getType();
                    OCLExpression ownedSource = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource = ownedSource;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type;
                        assert (ownedSource != null);
                        safe_type_source = type = ownedSource.getType();
                    }
                    CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_CollectionType_1));
                    Type elementType = oclAsType.getElementType();
                    boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_CollectionType_1);
                    if (oclIsKindOf) {
                        Type elementType_0;
                        CollectionType oclAsType_0 = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, type_2, TYP_CollectionType_1));
                        symbol_1 = elementType_0 = oclAsType_0.getElementType();
                    } else {
                        symbol_1 = type_2;
                    }
                    boolean eq_0 = symbol_1 != null ? elementType.getTypeId() == symbol_1.getTypeId() : false;
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_2 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::ClosureSourceElementTypeIsBodyElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_2;
    }

    @Override
    public boolean validateClosureElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::ClosureElementTypeIsSourceElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "closure".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    Type safe_type_source;
                    Object CAUGHT_ownedSource;
                    Class TYP_CollectionType_1 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    Type type = this.getType();
                    CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, type, TYP_CollectionType_1));
                    Type elementType = oclAsType.getElementType();
                    OCLExpression ownedSource = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource = ownedSource;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type_0;
                        assert (ownedSource != null);
                        safe_type_source = type_0 = ownedSource.getType();
                    }
                    CollectionType oclAsType_0 = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_CollectionType_1));
                    Type elementType_0 = oclAsType_0.getElementType();
                    boolean eq_0 = elementType.getTypeId() == elementType_0.getTypeId();
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::ClosureElementTypeIsSourceElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateCollectTypeIsUnordered(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_3;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::CollectTypeIsUnordered");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_3 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_symbol_2;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "collect".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    boolean symbol_2;
                    Serializable CAUGHT_oclIsKindOf_0;
                    Serializable CAUGHT_oclIsKindOf;
                    Type type_2 = this.getType();
                    try {
                        Type safe_type_source;
                        Object CAUGHT_ownedSource;
                        Class TYP_SequenceType_0 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        OCLExpression ownedSource = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource = ownedSource;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_0 = CAUGHT_ownedSource == null;
                        if (symbol_0 == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type;
                            assert (ownedSource != null);
                            safe_type_source = type = ownedSource.getType();
                        }
                        boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_SequenceType_0);
                        CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Type safe_type_source_0;
                        Object CAUGHT_ownedSource_0;
                        Class TYP_OrderedSetType_0 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        OCLExpression ownedSource_0 = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource_0 = ownedSource_0;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource_0 = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_1 = CAUGHT_ownedSource_0 == null;
                        if (symbol_1 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_0;
                            assert (ownedSource_0 != null);
                            safe_type_source_0 = type_0 = ownedSource_0.getType();
                        }
                        boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, safe_type_source_0, TYP_OrderedSetType_0);
                        CAUGHT_oclIsKindOf_0 = Boolean.valueOf(oclIsKindOf_0);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf_0 = ValueUtil.createInvalidValue(e);
                    }
                    Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                    if (or == null) {
                        throw new InvalidValueException("Null if condition", new Object[0]);
                    }
                    if (or.booleanValue()) {
                        boolean oclIsKindOf_1;
                        Class TYP_SequenceType_1 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        symbol_2 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_SequenceType_1).booleanValue();
                    } else {
                        boolean oclIsKindOf_2;
                        Class TYP_BagType_0 = idResolver.getClass(PivotTables.CLSSid_BagType, null);
                        symbol_2 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_BagType_0).booleanValue();
                    }
                    CAUGHT_symbol_2 = Boolean.valueOf(symbol_2);
                }
                catch (Exception e) {
                    CAUGHT_symbol_2 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_symbol_2);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_3 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::CollectTypeIsUnordered", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_3;
    }

    @Override
    public boolean validateSortedByIsOrderedIfSourceIsOrdered(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_3;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::SortedByIsOrderedIfSourceIsOrdered");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_3 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_symbol_2;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "sortedBy".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    boolean symbol_2;
                    Serializable CAUGHT_oclIsKindOf_0;
                    Serializable CAUGHT_oclIsKindOf;
                    Type type_2 = this.getType();
                    try {
                        Type safe_type_source;
                        Object CAUGHT_ownedSource;
                        Class TYP_SequenceType_0 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        OCLExpression ownedSource = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource = ownedSource;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_0 = CAUGHT_ownedSource == null;
                        if (symbol_0 == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type;
                            assert (ownedSource != null);
                            safe_type_source = type = ownedSource.getType();
                        }
                        boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_SequenceType_0);
                        CAUGHT_oclIsKindOf = Boolean.valueOf(oclIsKindOf);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Type safe_type_source_0;
                        Object CAUGHT_ownedSource_0;
                        Class TYP_BagType_0 = idResolver.getClass(PivotTables.CLSSid_BagType, null);
                        OCLExpression ownedSource_0 = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource_0 = ownedSource_0;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource_0 = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_1 = CAUGHT_ownedSource_0 == null;
                        if (symbol_1 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_0;
                            assert (ownedSource_0 != null);
                            safe_type_source_0 = type_0 = ownedSource_0.getType();
                        }
                        boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, safe_type_source_0, TYP_BagType_0);
                        CAUGHT_oclIsKindOf_0 = Boolean.valueOf(oclIsKindOf_0);
                    }
                    catch (Exception e) {
                        CAUGHT_oclIsKindOf_0 = ValueUtil.createInvalidValue(e);
                    }
                    Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                    if (or == null) {
                        throw new InvalidValueException("Null if condition", new Object[0]);
                    }
                    if (or.booleanValue()) {
                        boolean oclIsKindOf_1;
                        Class TYP_SequenceType_1 = idResolver.getClass(PivotTables.CLSSid_SequenceType, null);
                        symbol_2 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_SequenceType_1).booleanValue();
                    } else {
                        boolean oclIsKindOf_2;
                        Class TYP_OrderedSetType_0 = idResolver.getClass(PivotTables.CLSSid_OrderedSetType, null);
                        symbol_2 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate(evaluator, type_2, TYP_OrderedSetType_0).booleanValue();
                    }
                    CAUGHT_symbol_2 = Boolean.valueOf(symbol_2);
                }
                catch (Exception e) {
                    CAUGHT_symbol_2 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_symbol_2);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_3 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::SortedByIsOrderedIfSourceIsOrdered", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_3;
    }

    @Override
    public boolean validateSortedByElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::SortedByElementTypeIsSourceElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_eq_0;
                Serializable CAUGHT_eq;
                try {
                    String name = this.getName();
                    boolean eq = "sortedBy".equals(name);
                    CAUGHT_eq = Boolean.valueOf(eq);
                }
                catch (Exception e) {
                    CAUGHT_eq = ValueUtil.createInvalidValue(e);
                }
                try {
                    Class TYP_CollectionType_1 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    Type type = this.getType();
                    CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, type, TYP_CollectionType_1));
                    Type elementType = oclAsType.getElementType();
                    OCLExpression ownedBody = this.getOwnedBody();
                    Type type_0 = ownedBody.getType();
                    CollectionType oclAsType_0 = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, type_0, TYP_CollectionType_1));
                    Type elementType_0 = oclAsType_0.getElementType();
                    boolean eq_0 = elementType.getTypeId() == elementType_0.getTypeId();
                    CAUGHT_eq_0 = Boolean.valueOf(eq_0);
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::SortedByElementTypeIsSourceElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateIteratorTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_2;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::IteratorTypeIsSourceElementType");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_2 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                boolean status;
                List<Variable> ownedIterators = this.getOwnedIterators();
                OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                Iterator<Object> ITERATOR_p = BOXED_ownedIterators.iterator();
                while (true) {
                    Serializable CAUGHT_conformsTo;
                    if (!ITERATOR_p.hasNext()) {
                        if (accumulator == ValueUtil.TRUE_VALUE) {
                            status = ValueUtil.TRUE_VALUE;
                            break;
                        }
                        throw (InvalidValueException)accumulator;
                    }
                    Variable p = (Variable)ITERATOR_p.next();
                    try {
                        Type safe_type_source_0;
                        Type safe_type_source;
                        Object CAUGHT_ownedSource;
                        Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                        OCLExpression ownedSource = this.getOwnedSource();
                        try {
                            CAUGHT_ownedSource = ownedSource;
                        }
                        catch (Exception e) {
                            CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                        }
                        Boolean symbol_0 = CAUGHT_ownedSource == null;
                        if (symbol_0 == Boolean.TRUE) {
                            safe_type_source = null;
                        } else {
                            Type type;
                            assert (ownedSource != null);
                            safe_type_source = type = ownedSource.getType();
                        }
                        CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_CollectionType_0));
                        Type elementType = oclAsType.getElementType();
                        Boolean symbol_1 = p == null;
                        if (symbol_1 == Boolean.TRUE) {
                            safe_type_source_0 = null;
                        } else {
                            Type type_0;
                            assert (p != null);
                            safe_type_source_0 = type_0 = p.getType();
                        }
                        boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(evaluator, elementType, safe_type_source_0);
                        CAUGHT_conformsTo = Boolean.valueOf(conformsTo);
                    }
                    catch (Exception e) {
                        CAUGHT_conformsTo = ValueUtil.createInvalidValue(e);
                    }
                    if (CAUGHT_conformsTo == ValueUtil.FALSE_VALUE) {
                        status = ValueUtil.FALSE_VALUE;
                        break;
                    }
                    if (CAUGHT_conformsTo == ValueUtil.TRUE_VALUE) continue;
                    if (CAUGHT_conformsTo instanceof InvalidValueException) {
                        accumulator = CAUGHT_conformsTo;
                        continue;
                    }
                    accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                }
                CAUGHT_status = Boolean.valueOf(status);
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_2 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::IteratorTypeIsSourceElementType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_2;
    }

    @Override
    public boolean validateSafeIteratorIsRequired(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::SafeIteratorIsRequired");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_forAll;
                Serializable CAUGHT_isSafe;
                try {
                    Boolean isSafe = this.isIsSafe();
                    CAUGHT_isSafe = isSafe;
                }
                catch (Exception e) {
                    CAUGHT_isSafe = ValueUtil.createInvalidValue(e);
                }
                try {
                    boolean forAll;
                    List<Variable> ownedIterators = this.getOwnedIterators();
                    OrderedSetValue BOXED_ownedIterators = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, ownedIterators);
                    OrderedSetValue safe_null_sources = (OrderedSetValue)CollectionExcludingOperation.INSTANCE.evaluate(BOXED_ownedIterators, null);
                    Comparable<Boolean> accumulator = ValueUtil.TRUE_VALUE;
                    Iterator<Object> ITERATOR__1 = safe_null_sources.iterator();
                    while (true) {
                        Serializable CAUGHT_isRequired;
                        if (!ITERATOR__1.hasNext()) {
                            if (accumulator == ValueUtil.TRUE_VALUE) {
                                forAll = ValueUtil.TRUE_VALUE;
                                break;
                            }
                            throw (InvalidValueException)accumulator;
                        }
                        Variable _1 = (Variable)ITERATOR__1.next();
                        try {
                            boolean isRequired = _1.isIsRequired();
                            CAUGHT_isRequired = Boolean.valueOf(isRequired);
                        }
                        catch (Exception e) {
                            CAUGHT_isRequired = ValueUtil.createInvalidValue(e);
                        }
                        if (CAUGHT_isRequired == ValueUtil.FALSE_VALUE) {
                            forAll = ValueUtil.FALSE_VALUE;
                            break;
                        }
                        if (CAUGHT_isRequired == ValueUtil.TRUE_VALUE) continue;
                        if (CAUGHT_isRequired instanceof InvalidValueException) {
                            accumulator = CAUGHT_isRequired;
                            continue;
                        }
                        accumulator = new InvalidValueException(PivotMessages.NonBooleanBody, "forAll");
                    }
                    CAUGHT_forAll = Boolean.valueOf(forAll);
                }
                catch (Exception e) {
                    CAUGHT_forAll = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_isSafe, CAUGHT_forAll);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::SafeIteratorIsRequired", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        IdResolver idResolver = evaluator.getIdResolver();
        IntegerValue severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "IteratorExp::SafeSourceCanBeNull");
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0, PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_not;
                Serializable CAUGHT_isSafe;
                try {
                    Boolean isSafe = this.isIsSafe();
                    CAUGHT_isSafe = isSafe;
                }
                catch (Exception e) {
                    CAUGHT_isSafe = ValueUtil.createInvalidValue(e);
                }
                try {
                    Type safe_type_source;
                    Object CAUGHT_ownedSource;
                    Class TYP_CollectionType_0 = idResolver.getClass(PivotTables.CLSSid_CollectionType, null);
                    OCLExpression ownedSource = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource = ownedSource;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type;
                        assert (ownedSource != null);
                        safe_type_source = type = ownedSource.getType();
                    }
                    CollectionType oclAsType = ClassUtil.nonNullState((CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate(evaluator, safe_type_source, TYP_CollectionType_0));
                    boolean isNullFree = oclAsType.isIsNullFree();
                    Boolean not = BooleanNotOperation.INSTANCE.evaluate(isNullFree);
                    CAUGHT_not = not;
                }
                catch (Exception e) {
                    CAUGHT_not = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_isSafe, CAUGHT_not);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "IteratorExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.validateNoInitializers((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 5: {
                return this.validateSourceIsCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.getReferredElement();
            }
            case 7: {
                return this.validateAnyBodyTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateAnyHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.validateAnyTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 10: {
                return this.validateClosureBodyTypeIsConformanttoIteratorType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 11: {
                return this.validateClosureElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 12: {
                return this.validateClosureHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 13: {
                return this.validateClosureSourceElementTypeIsBodyElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 14: {
                return this.validateClosureTypeIsUniqueCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 15: {
                return this.validateCollectElementTypeIsFlattenedBodyType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 16: {
                return this.validateCollectTypeIsUnordered((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 17: {
                return this.validateIteratorTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 18: {
                return this.validateSafeIteratorIsRequired((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 19: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 20: {
                return this.validateSortedByElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 21: {
                return this.validateSortedByIsOrderedIfSourceIsOrdered((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 22: {
                return this.validateSortedByIteratorTypeIsComparable((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 23: {
                return this.validateUnsafeSourceCanNotBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitIteratorExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredIteration();
    }

    public int eDerivedOperationID(int baseOperationID, java.lang.Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 6;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }
}

