/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.BagType;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OrderedSetType;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.SequenceType;
import org.eclipse.ocl.pivot.SetType;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VoidType;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.internal.ElementImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.IllegalLibraryException;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.oclany.OclAnyUnsupportedOperation;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TypeUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.osgi.util.NLS;

public class StandardLibraryImpl
extends ElementImpl
implements StandardLibrary,
StandardLibraryInternal {
    private static final Logger logger = Logger.getLogger(StandardLibraryInternal.class);
    @NonNull
    public static final String DEFAULT_OCL_STDLIB_URI = "http://www.eclipse.org/ocl/2015/Library";
    @NonNull
    protected String defaultStandardLibraryURI = "http://www.eclipse.org/ocl/2015/Library";
    protected boolean explicitDefaultStandardLibraryURI = false;
    @Nullable
    private BagType bagType = null;
    @Nullable
    private PrimitiveType booleanType = null;
    @Nullable
    private Class classType = null;
    @Nullable
    private CollectionType collectionType = null;
    @Nullable
    private Class enumerationType = null;
    @Nullable
    private PrimitiveType integerType = null;
    @Nullable
    private Package libraryPackage = null;
    @Nullable
    private MapType mapType = null;
    @Nullable
    private AnyType oclAnyType = null;
    @Nullable
    private Class oclComparableType = null;
    @Nullable
    private Class oclElementType = null;
    @Nullable
    private Operation oclInvalidOperation = null;
    @Nullable
    private Property oclInvalidProperty = null;
    @Nullable
    private InvalidType oclInvalidType = null;
    @Nullable
    private Class oclLambdaType = null;
    @Nullable
    private SelfType oclSelfType = null;
    @Nullable
    private Class oclSummableType = null;
    @Nullable
    private Class oclTupleType = null;
    @Nullable
    private Class oclTypeType = null;
    @Nullable
    private VoidType oclVoidType = null;
    @Nullable
    private CollectionType orderedCollectionType = null;
    @Nullable
    private OrderedSetType orderedSetType = null;
    @Nullable
    private PrimitiveType realType = null;
    @Nullable
    private SequenceType sequenceType = null;
    @Nullable
    private SetType setType = null;
    @Nullable
    private PrimitiveType stringType = null;
    @Nullable
    private CollectionType uniqueCollectionType = null;
    @Nullable
    private PrimitiveType unlimitedNaturalType = null;
    @Nullable
    private Map<String, Class> nameToLibraryTypeMap = null;
    protected CompleteModelInternal completeModel;
    protected EnvironmentFactoryInternal environmentFactory;

    protected StandardLibraryImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.STANDARD_LIBRARY;
    }

    @Override
    public CompleteEnvironment getOwningCompleteEnvironment() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (CompleteEnvironment)this.eInternalContainer();
    }

    public NotificationChain basicSetOwningCompleteEnvironment(CompleteEnvironment newOwningCompleteEnvironment, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newOwningCompleteEnvironment, 4, msgs);
        return msgs;
    }

    @Override
    public void setOwningCompleteEnvironment(CompleteEnvironment newOwningCompleteEnvironment) {
        if (newOwningCompleteEnvironment != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newOwningCompleteEnvironment != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newOwningCompleteEnvironment)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newOwningCompleteEnvironment != null) {
                msgs = ((InternalEObject)newOwningCompleteEnvironment).eInverseAdd((InternalEObject)this, 5, CompleteEnvironment.class, msgs);
            }
            if ((msgs = this.basicSetOwningCompleteEnvironment(newOwningCompleteEnvironment, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newOwningCompleteEnvironment, (Object)newOwningCompleteEnvironment));
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicAdd((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicAdd((Object)otherEnd, msgs);
            }
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetOwningCompleteEnvironment((CompleteEnvironment)otherEnd, msgs);
            }
        }
        return this.eDynamicInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getAnnotatingComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getOwnedAnnotations()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getOwnedComments()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getOwnedExtensions()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return this.basicSetOwningCompleteEnvironment(null, msgs);
            }
        }
        return this.eDynamicInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 5, CompleteEnvironment.class, msgs);
            }
        }
        return this.eDynamicBasicRemoveFromContainer(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getOwningCompleteEnvironment();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setOwningCompleteEnvironment((CompleteEnvironment)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setOwningCompleteEnvironment(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return this.getOwningCompleteEnvironment() != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitStandardLibrary(this);
    }

    @Override
    @Nullable
    public Operation basicGetOclInvalidOperation() {
        return this.oclInvalidOperation;
    }

    @Override
    @Nullable
    public Property basicGetOclInvalidProperty() {
        return this.oclInvalidProperty;
    }

    @Override
    @Nullable
    public InvalidType basicGetOclInvalidType() {
        return this.oclInvalidType;
    }

    @Override
    public void defineLibraryType(@NonNull Class pivotType) {
        String name;
        Class oldType;
        Map<String, Class> nameToLibraryTypeMap2 = this.nameToLibraryTypeMap;
        if (nameToLibraryTypeMap2 == null) {
            this.nameToLibraryTypeMap = nameToLibraryTypeMap2 = new HashMap<String, Class>();
        }
        if ((oldType = nameToLibraryTypeMap2.put(name = pivotType.getName(), pivotType)) != null && oldType != pivotType) {
            logger.warn((Object)("Conflicting pivot type '" + name + "'"));
        }
    }

    @Override
    public void dispose() {
        this.resetLibrary();
    }

    @Override
    @Nullable
    public Class getASClass(@NonNull String className) {
        return this.environmentFactory.getMetamodelManager().getASClass(className);
    }

    @Override
    @NonNull
    public Iterable<? extends CompletePackage> getAllCompletePackages() {
        return this.environmentFactory.getMetamodelManager().getAllCompletePackages();
    }

    @Override
    @NonNull
    public BagType getBagType() {
        BagType bagType2 = this.bagType;
        if (bagType2 == null) {
            bagType2 = this.bagType = this.resolveRequiredTemplateableType(BagType.class, "Bag", 1);
        }
        return bagType2;
    }

    @Override
    @Nullable
    public PrimitiveType getBehavioralClass(@NonNull java.lang.Class<?> instanceClass) {
        if (instanceClass == Boolean.TYPE) {
            return this.getBooleanType();
        }
        if (instanceClass == Byte.TYPE) {
            return this.getIntegerType();
        }
        if (instanceClass == Character.TYPE) {
            return this.getIntegerType();
        }
        if (instanceClass == Double.TYPE) {
            return this.getRealType();
        }
        if (instanceClass == Float.TYPE) {
            return this.getRealType();
        }
        if (instanceClass == Integer.TYPE) {
            return this.getIntegerType();
        }
        if (instanceClass == Long.TYPE) {
            return this.getIntegerType();
        }
        if (instanceClass == Short.TYPE) {
            return this.getIntegerType();
        }
        if (instanceClass == BigDecimal.class) {
            return this.getRealType();
        }
        if (instanceClass == BigInteger.class) {
            return this.getIntegerType();
        }
        if (instanceClass == Boolean.class) {
            return this.getBooleanType();
        }
        if (instanceClass == Byte.class) {
            return this.getIntegerType();
        }
        if (instanceClass == Character.class) {
            return this.getIntegerType();
        }
        if (instanceClass == Double.class) {
            return this.getRealType();
        }
        if (instanceClass == Float.class) {
            return this.getRealType();
        }
        if (instanceClass == Integer.class) {
            return this.getIntegerType();
        }
        if (instanceClass == Long.class) {
            return this.getIntegerType();
        }
        if (instanceClass == Short.class) {
            return this.getIntegerType();
        }
        if (instanceClass == String.class) {
            return this.getStringType();
        }
        return null;
    }

    @Override
    @NonNull
    public PrimitiveType getBooleanType() {
        PrimitiveType booleanType2 = this.booleanType;
        if (booleanType2 == null) {
            booleanType2 = this.booleanType = this.resolveRequiredSimpleType(PrimitiveType.class, "Boolean");
        }
        return booleanType2;
    }

    @Override
    @NonNull
    public Class getClassType() {
        Class classType2 = this.classType;
        if (classType2 == null) {
            classType2 = this.classType = this.resolveRequiredSimpleType(Class.class, "Class");
        }
        return classType2;
    }

    @Override
    @NonNull
    public CollectionType getCollectionType() {
        CollectionType collectionType2 = this.collectionType;
        if (collectionType2 == null) {
            collectionType2 = this.collectionType = this.resolveRequiredTemplateableType(CollectionType.class, "Collection", 1);
        }
        return collectionType2;
    }

    @Override
    @NonNull
    public CollectionType getCollectionType(@NonNull Class containerType, @NonNull Type elementType, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.environmentFactory.getCompleteEnvironment().getCollectionType(containerType, elementType, isNullFree, lower, upper);
    }

    @Override
    @NonNull
    public CollectionType getCollectionType(@NonNull Class containerType, @NonNull Type elementType, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        return this.environmentFactory.getCompleteEnvironment().getCollectionType(containerType, elementType, false, lower, upper);
    }

    @Override
    @NonNull
    public CompleteModelInternal getCompleteModel() {
        return ClassUtil.nonNullState(this.completeModel);
    }

    @Override
    @NonNull
    public String getDefaultStandardLibraryURI() {
        return this.defaultStandardLibraryURI;
    }

    @Override
    @NonNull
    public Class getEnumerationType() {
        Class enumerationType2 = this.enumerationType;
        if (enumerationType2 == null) {
            enumerationType2 = this.enumerationType = this.resolveRequiredSimpleType(Class.class, "Enumeration");
        }
        return enumerationType2;
    }

    @Override
    @NonNull
    public CompleteInheritance getInheritance(@NonNull Class type) {
        return this.environmentFactory.getMetamodelManager().getInheritance(type);
    }

    @Override
    @NonNull
    public PrimitiveType getIntegerType() {
        PrimitiveType integerType2 = this.integerType;
        if (integerType2 == null) {
            integerType2 = this.integerType = this.resolveRequiredSimpleType(PrimitiveType.class, "Integer");
        }
        return integerType2;
    }

    @Override
    public Class getLibraryType(@NonNull String typeName) {
        Map<String, Class> nameToLibraryTypeMap2 = this.nameToLibraryTypeMap;
        if (nameToLibraryTypeMap2 == null) {
            this.nameToLibraryTypeMap = nameToLibraryTypeMap2 = new HashMap<String, Class>();
            this.loadDefaultLibrary(this.defaultStandardLibraryURI);
        }
        return nameToLibraryTypeMap2.get(typeName);
    }

    @Override
    @NonNull
    public MapType getMapType() {
        MapType mapType2 = this.mapType;
        if (mapType2 == null) {
            mapType2 = this.mapType = this.resolveRequiredTemplateableType(MapType.class, "Map", 2);
        }
        return mapType2;
    }

    @Override
    @NonNull
    public MapType getMapType(@NonNull Class containerType, @NonNull Type keyType, @NonNull Type valueType) {
        return this.environmentFactory.getCompleteEnvironment().getMapType(containerType, keyType, valueType);
    }

    @Override
    @NonNull
    public Class getMetaclass(@NonNull Type classType) {
        return this.environmentFactory.getMetamodelManager().getMetaclass(classType);
    }

    @Override
    public Type getMetaType(@NonNull Type instanceType) {
        if (instanceType instanceof PrimitiveType) {
            return this.getASClass("PrimitiveType");
        }
        return this.getMetaclass(instanceType);
    }

    @Override
    public Package getNsURIPackage(@NonNull String nsURI) {
        CompletePackageInternal completePackage = this.completeModel.getCompletePackageByURI(nsURI);
        return completePackage != null ? completePackage.getPrimaryPackage() : null;
    }

    @Override
    @NonNull
    public AnyType getOclAnyType() {
        AnyType oclAnyType2 = this.oclAnyType;
        if (oclAnyType2 == null) {
            oclAnyType2 = this.oclAnyType = this.resolveRequiredSimpleType(AnyType.class, "OclAny");
        }
        return oclAnyType2;
    }

    @Override
    @NonNull
    public Class getOclComparableType() {
        Class oclComparableType2 = this.oclComparableType;
        if (oclComparableType2 == null) {
            oclComparableType2 = this.oclComparableType = this.resolveRequiredSimpleType(Class.class, "OclComparable");
        }
        return oclComparableType2;
    }

    @Override
    @NonNull
    public Class getOclElementType() {
        Class oclElementType2 = this.oclElementType;
        if (oclElementType2 == null) {
            oclElementType2 = this.oclElementType = this.resolveRequiredSimpleType(Class.class, "OclElement");
        }
        return oclElementType2;
    }

    @Override
    @NonNull
    public Operation getOclInvalidOperation() {
        Operation oclInvalidOperation2 = this.oclInvalidOperation;
        if (oclInvalidOperation2 == null) {
            String invalidName;
            InvalidType invalidType = this.getOclInvalidType();
            List<Operation> invalidOperations = invalidType.getOwnedOperations();
            oclInvalidOperation2 = NameUtil.getNameable(invalidOperations, invalidName = "oclBadOperation");
            if (oclInvalidOperation2 == null) {
                oclInvalidOperation2 = PivotFactory.eINSTANCE.createOperation();
                oclInvalidOperation2.setName(invalidName);
                oclInvalidOperation2.setType(invalidType);
                oclInvalidOperation2.setImplementation(OclAnyUnsupportedOperation.INSTANCE);
                invalidOperations.add(oclInvalidOperation2);
            }
            this.oclInvalidOperation = oclInvalidOperation2;
        }
        return oclInvalidOperation2;
    }

    @Override
    @NonNull
    public Property getOclInvalidProperty() {
        Property oclInvalidProperty2 = this.oclInvalidProperty;
        if (oclInvalidProperty2 == null) {
            String invalidName;
            InvalidType invalidType = this.getOclInvalidType();
            List<Property> invalidProperties = invalidType.getOwnedProperties();
            oclInvalidProperty2 = NameUtil.getNameable(invalidProperties, invalidName = "oclBadProperty");
            if (oclInvalidProperty2 == null) {
                oclInvalidProperty2 = PivotFactory.eINSTANCE.createProperty();
                oclInvalidProperty2.setName(invalidName);
                oclInvalidProperty2.setType(invalidType);
                oclInvalidProperty2.setImplementation(OclAnyUnsupportedOperation.INSTANCE);
                invalidProperties.add(oclInvalidProperty2);
            }
            this.oclInvalidProperty = oclInvalidProperty2;
        }
        return oclInvalidProperty2;
    }

    @Override
    @NonNull
    public InvalidType getOclInvalidType() {
        InvalidType oclInvalidType2 = this.oclInvalidType;
        if (oclInvalidType2 == null) {
            oclInvalidType2 = this.oclInvalidType = this.resolveRequiredSimpleType(InvalidType.class, "OclInvalid");
        }
        return oclInvalidType2;
    }

    @Override
    @NonNull
    public Class getOclLambdaType() {
        Class oclLambdaType2 = this.oclLambdaType;
        if (oclLambdaType2 == null) {
            oclLambdaType2 = this.oclLambdaType = this.resolveRequiredSimpleType(Class.class, "OclLambda");
        }
        return oclLambdaType2;
    }

    @Override
    @NonNull
    public Class getOclMessageType() {
        return this.getRequiredLibraryType("OclMessage");
    }

    @Override
    @NonNull
    public SelfType getOclSelfType() {
        SelfType oclSelfType2 = this.oclSelfType;
        if (oclSelfType2 == null) {
            oclSelfType2 = this.oclSelfType = this.resolveRequiredSimpleType(SelfType.class, "OclSelf");
        }
        return oclSelfType2;
    }

    @Override
    @NonNull
    public Class getOclSummableType() {
        Class oclSummableType2 = this.oclSummableType;
        if (oclSummableType2 == null) {
            oclSummableType2 = this.oclSummableType = this.resolveRequiredSimpleType(Class.class, "OclSummable");
        }
        return oclSummableType2;
    }

    @Override
    @NonNull
    public Class getOclTupleType() {
        Class oclTupleType2 = this.oclTupleType;
        if (oclTupleType2 == null) {
            oclTupleType2 = this.oclTupleType = this.resolveRequiredSimpleType(Class.class, "OclTuple");
        }
        return oclTupleType2;
    }

    @Override
    public Type getOclType(@NonNull String typeName) {
        return this.environmentFactory.getMetamodelManager().getOclType(typeName);
    }

    @Override
    @NonNull
    public Class getOclTypeType() {
        Class oclTypeType2 = this.oclTypeType;
        if (oclTypeType2 == null) {
            oclTypeType2 = this.oclTypeType = this.resolveRequiredSimpleType(Class.class, "OclType");
        }
        return oclTypeType2;
    }

    @Override
    @NonNull
    public VoidType getOclVoidType() {
        VoidType oclVoidType2 = this.oclVoidType;
        if (oclVoidType2 == null) {
            oclVoidType2 = this.oclVoidType = this.resolveRequiredSimpleType(VoidType.class, "OclVoid");
        }
        return oclVoidType2;
    }

    @Override
    @Nullable
    public Element getOperationTemplateParameter(@NonNull Operation anOperation, int index) {
        anOperation = PivotUtil.getUnspecializedTemplateableElement(anOperation);
        return anOperation.getTypeParameters().get(index);
    }

    @Override
    @NonNull
    public CollectionType getOrderedCollectionType() {
        CollectionType orderedCollectionType2 = this.orderedCollectionType;
        if (orderedCollectionType2 == null) {
            orderedCollectionType2 = this.orderedCollectionType = this.resolveRequiredTemplateableType(CollectionType.class, "OrderedCollection", 1);
        }
        return orderedCollectionType2;
    }

    @Override
    @NonNull
    public OrderedSetType getOrderedSetType() {
        OrderedSetType orderedSetType2 = this.orderedSetType;
        if (orderedSetType2 == null) {
            orderedSetType2 = this.orderedSetType = this.resolveRequiredTemplateableType(OrderedSetType.class, "OrderedSet", 1);
        }
        return orderedSetType2;
    }

    @Override
    @NonNull
    public Package getPackage() {
        Package libraryPackage2 = this.libraryPackage;
        if (libraryPackage2 == null) {
            libraryPackage2 = this.libraryPackage = this.getOclAnyType().getOwningPackage();
            assert (libraryPackage2 != null);
        }
        return libraryPackage2;
    }

    @Override
    @Nullable
    public Type getPrimitiveType(@NonNull PrimitiveTypeId typeId) {
        return TypeUtil.getPrimitiveType(this, typeId);
    }

    @Override
    @NonNull
    public PrimitiveType getRealType() {
        PrimitiveType realType2 = this.realType;
        if (realType2 == null) {
            realType2 = this.realType = this.resolveRequiredSimpleType(PrimitiveType.class, "Real");
        }
        return realType2;
    }

    @Override
    @NonNull
    public Class getRequiredLibraryType(@NonNull String typeName) {
        Class type = this.getLibraryType(typeName);
        if (type == null) {
            type = this.getLibraryType(typeName);
            Map<String, Class> nameToLibraryTypeMap2 = this.nameToLibraryTypeMap;
            if (nameToLibraryTypeMap2 == null || nameToLibraryTypeMap2.isEmpty()) {
                throw new IllegalLibraryException(PivotMessagesInternal.EmptyLibrary_ERROR_);
            }
            throw new IllegalLibraryException(NLS.bind((String)PivotMessagesInternal.MissingLibraryType_ERROR_, (Object)typeName));
        }
        return type;
    }

    @Override
    @Nullable
    public Package getRootPackage(@NonNull String completeURIorName) {
        Package rootPackage = this.completeModel.getRootPackage(completeURIorName);
        if (rootPackage == null && "$metamodel$".equals(completeURIorName)) {
            this.environmentFactory.getMetamodelManager().getASmetamodel();
            rootPackage = this.completeModel.getRootPackage(completeURIorName);
        }
        return rootPackage;
    }

    @Override
    @NonNull
    public SequenceType getSequenceType() {
        SequenceType sequenceType2 = this.sequenceType;
        if (sequenceType2 == null) {
            sequenceType2 = this.sequenceType = this.resolveRequiredTemplateableType(SequenceType.class, "Sequence", 1);
        }
        return sequenceType2;
    }

    @Override
    @NonNull
    public SetType getSetType() {
        SetType setType2 = this.setType;
        if (setType2 == null) {
            setType2 = this.setType = this.resolveRequiredTemplateableType(SetType.class, "Set", 1);
        }
        return setType2;
    }

    @Override
    @NonNull
    public PrimitiveType getStringType() {
        PrimitiveType stringType2 = this.stringType;
        if (stringType2 == null) {
            stringType2 = this.stringType = this.resolveRequiredSimpleType(PrimitiveType.class, "String");
        }
        return stringType2;
    }

    @Override
    @NonNull
    public CollectionType getUniqueCollectionType() {
        CollectionType uniqueCollectionType2 = this.uniqueCollectionType;
        if (uniqueCollectionType2 == null) {
            uniqueCollectionType2 = this.uniqueCollectionType = this.resolveRequiredTemplateableType(CollectionType.class, "UniqueCollection", 1);
        }
        return uniqueCollectionType2;
    }

    @Override
    @NonNull
    public PrimitiveType getUnlimitedNaturalType() {
        PrimitiveType unlimitedNaturalType2 = this.unlimitedNaturalType;
        if (unlimitedNaturalType2 == null) {
            unlimitedNaturalType2 = this.unlimitedNaturalType = this.resolveRequiredSimpleType(PrimitiveType.class, "UnlimitedNatural");
        }
        return unlimitedNaturalType2;
    }

    @Override
    @NonNull
    public StandardLibraryInternal init(@NonNull CompleteModelInternal completeModel) {
        this.completeModel = completeModel;
        this.environmentFactory = completeModel.getEnvironmentFactory();
        return this;
    }

    @Override
    public boolean isExplicitDefaultStandardLibraryURI() {
        return this.explicitDefaultStandardLibraryURI;
    }

    public boolean isOrdered(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SequenceType;
    }

    public boolean isUnique(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SetType;
    }

    @Override
    @Nullable
    public Resource loadDefaultLibrary(@Nullable String uri) {
        return this.environmentFactory.getMetamodelManager().loadDefaultLibrary(uri);
    }

    public void resetLibrary() {
        this.bagType = null;
        this.booleanType = null;
        this.classType = null;
        this.collectionType = null;
        this.enumerationType = null;
        this.integerType = null;
        this.libraryPackage = null;
        this.mapType = null;
        this.oclAnyType = null;
        this.oclComparableType = null;
        this.oclElementType = null;
        this.oclInvalidOperation = null;
        this.oclInvalidProperty = null;
        this.oclInvalidType = null;
        this.oclLambdaType = null;
        this.oclSelfType = null;
        this.oclSummableType = null;
        this.oclTupleType = null;
        this.oclTypeType = null;
        this.oclVoidType = null;
        this.orderedCollectionType = null;
        this.orderedSetType = null;
        this.realType = null;
        this.sequenceType = null;
        this.setType = null;
        this.stringType = null;
        this.uniqueCollectionType = null;
        this.unlimitedNaturalType = null;
        this.nameToLibraryTypeMap = null;
    }

    @NonNull
    protected <T extends TemplateableElement> T resolveRequiredSimpleType(@NonNull java.lang.Class<T> requiredClassType, @NonNull String name) {
        Class type = this.getRequiredLibraryType(name);
        if (requiredClassType.isAssignableFrom(type.getClass())) {
            Class type2 = type;
            return (T)type2;
        }
        throw new IllegalLibraryException(String.valueOf(name) + " is not a " + requiredClassType.getSimpleName());
    }

    @NonNull
    protected <T extends TemplateableElement> T resolveRequiredTemplateableType(@NonNull java.lang.Class<T> requiredClassType, @NonNull String name, int parameterCount) {
        Class type = this.getRequiredLibraryType(name);
        if (requiredClassType.isAssignableFrom(type.getClass())) {
            if (type.getOwnedSignature() == null) {
                throw new IllegalLibraryException(String.valueOf(name) + " is not a templated type");
            }
            if (type.getOwnedSignature().getOwnedParameters().size() != parameterCount) {
                throw new IllegalLibraryException(String.valueOf(name) + " is not a templated type with " + parameterCount + " argument" + (parameterCount != 1 ? "s" : ""));
            }
            Class type2 = type;
            return (T)type2;
        }
        throw new IllegalLibraryException(String.valueOf(name) + " is not a " + requiredClassType.getSimpleName());
    }

    @Override
    public void setDefaultStandardLibraryURI(@NonNull String defaultStandardLibraryURI) {
        assert (!PivotUtilInternal.isASURI(defaultStandardLibraryURI));
        this.defaultStandardLibraryURI = defaultStandardLibraryURI;
        this.explicitDefaultStandardLibraryURI = true;
    }
}

