/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.NamedElementImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteURIs;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public abstract class AbstractCompletePackages
extends EObjectContainmentWithInverseEList<CompletePackage> {
    @NonNull
    public static final TracingOption COMPLETE_PACKAGES = new TracingOption("org.eclipse.ocl.pivot", "completePackages");
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Map<String, CompletePackageInternal> name2completePackage = new HashMap<String, CompletePackageInternal>();

    public AbstractCompletePackages(Class<?> dataClass, @NonNull NamedElementImpl owner, int featureID, int inverseFeatureID) {
        super(dataClass, (InternalEObject)owner, featureID, inverseFeatureID);
        if (COMPLETE_PACKAGES.isActive()) {
            COMPLETE_PACKAGES.println("Create " + (Object)((Object)this));
        }
    }

    public void addUnique(CompletePackage completePackage) {
        assert (completePackage != null);
        super.addUnique((Object)completePackage);
        this.didAdd(completePackage);
    }

    public void addUnique(int index, CompletePackage completePackage) {
        assert (completePackage != null);
        super.addUnique(index, (Object)completePackage);
        this.didAdd(completePackage);
    }

    @NonNull
    public abstract CompletePackageInternal createCompletePackage(@NonNull Package var1);

    protected void didAdd(@NonNull CompletePackage completePackage) {
        CompletePackageInternal completePackageInternal = (CompletePackageInternal)completePackage;
        String name = completePackageInternal.getName();
        if (name != null) {
            if (!this.name2completePackage.containsKey(name)) {
                CompletePackage oldCompletePackage = this.name2completePackage.put(name, completePackageInternal);
                assert (oldCompletePackage == null);
            } else {
                this.name2completePackage.put(name, null);
            }
        }
        this.getCompleteModel().didAddCompletePackage(completePackageInternal);
    }

    public void didAddPackage(@NonNull Package pivotPackage) {
        CompletePackageInternal completePackage = null;
        String name = pivotPackage.getName();
        String packageURI = pivotPackage.getURI();
        if (packageURI != null) {
            completePackage = this.getCompleteModel().getCompleteURIs().getCompletePackage(packageURI);
        } else if (name != null) {
            completePackage = this.getOwnedCompletePackage(name);
        }
        if (completePackage == null) {
            completePackage = this.getOwnedCompletePackage(pivotPackage);
            completePackage.assertSamePackage(pivotPackage);
        }
        completePackage.getPartialPackages().add(pivotPackage);
    }

    protected void didRemove(int index, CompletePackage completePackage) {
        assert (completePackage != null);
        CompletePackageInternal completePackageInternal = (CompletePackageInternal)completePackage;
        super.didRemove(index, (Object)completePackageInternal);
        this.name2completePackage.remove(completePackageInternal.getName());
        this.getCompleteModel().didRemoveCompletePackage(completePackageInternal);
    }

    public void didRemovePackage(@NonNull Package partialPackage) {
        CompletePackageInternal completePackage = this.getCompletePackage(partialPackage);
        List<Package> partialPackages = completePackage.getPartialPackages();
        partialPackages.remove(partialPackage);
        if (partialPackages.size() <= 0) {
            this.getCompleteModel().getCompleteURIs().removeCompletePackage(completePackage.getURI());
            this.remove(completePackage);
        }
    }

    public synchronized void dispose() {
        Collection<CompletePackageInternal> savedCompletePackages = this.name2completePackage.values();
        this.name2completePackage.clear();
        for (CompletePackageInternal completePackage : savedCompletePackages) {
            completePackage.dispose();
        }
    }

    protected abstract CompleteModelInternal getCompleteModel();

    @NonNull
    public CompletePackageInternal getCompletePackage(@NonNull Package pivotPackage) {
        CompletePackageInternal completePackage = null;
        if (pivotPackage instanceof CompletePackageInternal) {
            ((CompletePackageInternal)((Object)pivotPackage)).assertSamePackage(pivotPackage);
            completePackage = (CompletePackageInternal)((Object)pivotPackage);
        } else {
            CompleteURIs completeURIs = this.getCompleteModel().getCompleteURIs();
            completePackage = completeURIs.getCompletePackage(pivotPackage);
            if (completePackage == null) {
                Package pivotPackageParent = pivotPackage.getOwningPackage();
                if (pivotPackageParent == null) {
                    completePackage = this.getOwnedCompletePackage(pivotPackage);
                    completePackage.getPartialPackages().add(pivotPackage);
                    completePackage.assertSamePackage(pivotPackage);
                } else {
                    CompletePackageInternal completeParentPackage = this.getCompletePackage(pivotPackageParent);
                    CompletePackageInternal completeChildPackage = completeParentPackage.getOwnedCompletePackage(pivotPackage.getName());
                    assert (completeChildPackage != null);
                    return completeChildPackage;
                }
            }
        }
        completePackage.assertSamePackage(pivotPackage);
        return completePackage;
    }

    @Nullable
    public CompletePackageInternal getOwnedCompletePackage(@Nullable String name) {
        return this.name2completePackage.get(name);
    }

    @NonNull
    protected abstract CompletePackageInternal getOwnedCompletePackage(@NonNull Package var1);

    @NonNull
    protected abstract Iterable<Package> getPartialPackages();

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ": " + this.owner.toString();
    }
}

