/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Behavior;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Region;
import org.eclipse.ocl.pivot.State;
import org.eclipse.ocl.pivot.StateMachine;
import org.eclipse.ocl.pivot.Stereotype;
import org.eclipse.ocl.pivot.StereotypeExtender;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Vertex;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.internal.ClassImpl;
import org.eclipse.ocl.pivot.internal.CompleteClassImpl;
import org.eclipse.ocl.pivot.internal.complete.ClassListeners;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.complete.CompleteInheritanceImpl;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.complete.PartialOperations;
import org.eclipse.ocl.pivot.internal.complete.PartialProperties;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TypeUtil;

public class PartialClasses
extends EObjectResolvingEList<Class>
implements ClassListeners.IClassListener {
    private static final long serialVersionUID = 1L;
    @NonNull
    public static final TracingOption PARTIAL_CLASSES = new TracingOption("org.eclipse.ocl.pivot", "partialClasses");
    @NonNull
    public static final TracingOption ADD_BASE_PROPERTY = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/addBaseProperty");
    @NonNull
    public static final TracingOption ADD_EXTENSION_PROPERTY = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/addExtensionProperty");
    @NonNull
    public static final TracingOption INIT_MEMBER_OPERATIONS = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/initMemberOperations");
    @NonNull
    public static final TracingOption INIT_MEMBER_PROPERTIES = new TracingOption("org.eclipse.ocl.pivot", "partialClasses/initMemberProperties");
    @Nullable
    private Map<String, PartialOperations> name2partialOperations = null;
    @Nullable
    private Map<String, PartialProperties> name2partialProperties = null;
    private Set<CompleteClassInternal> superCompleteClasses = null;
    @Nullable
    private Map<String, State> name2states = null;
    protected CompleteInheritanceImpl completeInheritance;
    @Nullable
    private Map<TemplateParameters, WeakReference<Class>> specializations = null;

    public PartialClasses(@NonNull CompleteClassImpl completeClass) {
        super(Class.class, (InternalEObject)completeClass, 6);
    }

    public void addUnique(Class partialClass) {
        assert (partialClass != null);
        this.didAdd(partialClass);
        super.addUnique((Object)partialClass);
    }

    public void addUnique(int index, Class partialClass) {
        assert (partialClass != null);
        this.didAdd(partialClass);
        super.addUnique(index, (Object)partialClass);
    }

    @NonNull
    public Set<CompleteClassInternal> computeSuperCompleteClasses() {
        Set<CompleteClassInternal> superCompleteClasses2 = this.superCompleteClasses;
        if (superCompleteClasses2 == null) {
            CompleteModelInternal completeModel = this.getCompleteModel();
            superCompleteClasses2 = this.superCompleteClasses = new HashSet<CompleteClassInternal>();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Class partialClass = (Class)iterator.next();
                for (Class partialSuperClass : partialClass.getSuperClasses()) {
                    if (partialSuperClass == null) continue;
                    CompleteClassInternal superCompleteClass = completeModel.getCompleteClass(PivotUtil.getUnspecializedTemplateableElement(partialSuperClass));
                    superCompleteClasses2.add(superCompleteClass);
                    superCompleteClasses2.addAll(superCompleteClass.getPartialClasses().computeSuperCompleteClasses());
                }
            }
            if (superCompleteClasses2.isEmpty()) {
                CompleteClassInternal oclAnyCompleteClass = completeModel.getCompleteClass(completeModel.getStandardLibrary().getOclAnyType());
                if (this.getCompleteClass() != oclAnyCompleteClass) {
                    superCompleteClasses2.add(oclAnyCompleteClass);
                }
            }
        }
        return superCompleteClasses2;
    }

    @NonNull
    protected Property createExtensionProperty(@NonNull ElementExtension stereotypeInstance, @NonNull Class baseType) {
        Iterator<Property> iterator;
        Stereotype stereotype = stereotypeInstance.getStereotype();
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        assert (name2partialProperties2 != null);
        String extensionPropertyName = "extension_" + stereotype.getName();
        Property extensionProperty = null;
        PartialProperties partialProperties = name2partialProperties2.get(extensionPropertyName);
        if (partialProperties == null) {
            partialProperties = new PartialProperties(this.getEnvironmentFactory());
            name2partialProperties2.put(extensionPropertyName, partialProperties);
        }
        if ((iterator = partialProperties.iterator()).hasNext()) {
            Property partialProperty;
            extensionProperty = partialProperty = iterator.next();
        }
        if (extensionProperty == null) {
            extensionProperty = PivotFactory.eINSTANCE.createProperty();
            extensionProperty.setName(extensionPropertyName);
            baseType.getOwnedProperties().add(extensionProperty);
        }
        extensionProperty.setType(stereotype);
        boolean isRequired = false;
        for (StereotypeExtender typeExtension : stereotype.getOwnedExtenders()) {
            Class metatype = typeExtension.getClass_();
            if (metatype == null || !baseType.conformsTo(this.getStandardLibrary(), metatype)) continue;
            isRequired = true;
            break;
        }
        extensionProperty.setIsRequired(isRequired);
        extensionProperty.setIsStatic(true);
        return extensionProperty;
    }

    @NonNull
    protected Class createSpecialization(@NonNull TemplateParameters templateArguments) {
        Class unspecializedType = this.getCompleteClass().getPrimaryClass();
        String typeName = unspecializedType.getName();
        TemplateSignature templateSignature = unspecializedType.getOwnedSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        EClass eClass = unspecializedType.eClass();
        EFactory eFactoryInstance = eClass.getEPackage().getEFactoryInstance();
        Class specializedType = (Class)eFactoryInstance.create(eClass);
        specializedType.setName(typeName);
        TemplateBinding templateBinding = PivotFactory.eINSTANCE.createTemplateBinding();
        int i = 0;
        while (i < templateParameters.size()) {
            Type templateArgument;
            TemplateParameter formalParameter = templateParameters.get(i);
            if (formalParameter != null && (templateArgument = templateArguments.get(i)) instanceof Type) {
                Type actualType = templateArgument;
                TemplateParameterSubstitution templateParameterSubstitution = CompleteInheritanceImpl.createTemplateParameterSubstitution(formalParameter, actualType);
                templateBinding.getOwnedSubstitutions().add(templateParameterSubstitution);
            }
            ++i;
        }
        specializedType.getOwnedBindings().add(templateBinding);
        this.getCompleteModel().resolveSuperClasses(specializedType, unspecializedType);
        specializedType.setUnspecializedElement(unspecializedType);
        PivotMetamodelManager metamodelManager = this.getCompleteModel().getMetamodelManager();
        Orphanage orphanage = Orphanage.getOrphanage(metamodelManager.getASResourceSet());
        specializedType.setOwningPackage(orphanage);
        return specializedType;
    }

    protected void didAdd(Class partialClass) {
        if (PARTIAL_CLASSES.isActive()) {
            PARTIAL_CLASSES.println("Do-didAdd " + this + " " + partialClass);
        }
        ((ClassImpl)partialClass).addClassListener(this);
        if (partialClass.getUnspecializedElement() == null) {
            this.getCompleteModel().didAddClass(partialClass, this.getCompleteClass());
        }
        this.dispose();
    }

    protected void didRemove(int index, Class partialClass) {
        assert (partialClass != null);
        if (PARTIAL_CLASSES.isActive()) {
            PARTIAL_CLASSES.println("Do-didRemove " + this + " " + partialClass);
        }
        super.didRemove(index, (Object)partialClass);
        ((ClassImpl)partialClass).removeClassListener(this);
        this.dispose();
    }

    @Override
    public void didAddOperation(@NonNull Operation pivotOperation) {
        String operationName;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 != null && (operationName = pivotOperation.getName()) != null) {
            PartialOperations partialOperations = name2partialOperations2.get(operationName);
            if (partialOperations == null) {
                partialOperations = new PartialOperations(this.getCompleteClass(), operationName);
                name2partialOperations2.put(operationName, partialOperations);
            }
            partialOperations.didAddOperation(pivotOperation);
        }
    }

    @Override
    public void didAddProperty(@NonNull Property pivotProperty) {
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 != null) {
            String propertyName = pivotProperty.getName();
            PartialProperties partials = name2partialProperties2.get(propertyName);
            if (partials == null) {
                partials = new PartialProperties(this.getEnvironmentFactory());
                name2partialProperties2.put(propertyName, partials);
            }
            partials.didAddProperty(pivotProperty);
        }
    }

    @Override
    public void didAddSuperClass(@NonNull Class partialClass) {
        if (this.completeInheritance != null) {
            this.completeInheritance.uninstall();
        }
    }

    @Override
    public void didRemoveOperation(@NonNull Operation pivotOperation) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 != null && (partialOperations = name2partialOperations2.get(operationName = pivotOperation.getName())) != null && partialOperations.didRemoveOperation(pivotOperation)) {
            name2partialOperations2.remove(operationName);
        }
    }

    @Override
    public void didRemoveProperty(@NonNull Property pivotProperty) {
        String propertyName;
        PartialProperties partials;
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 != null && (partials = name2partialProperties2.get(propertyName = pivotProperty.getName())) != null && partials.didRemoveProperty(pivotProperty)) {
            name2partialProperties2.remove(propertyName);
        }
    }

    @Override
    public void didRemoveSuperClass(@NonNull Class partialClass) {
        if (this.completeInheritance != null) {
            this.completeInheritance.uninstall();
        }
    }

    public void dispose() {
        Map<String, PartialProperties> name2partialProperties2;
        CompleteClassInternal completeClass = this.getCompleteClass();
        CompletePackageInternal owningCompletePackage = completeClass.getOwningCompletePackage();
        if (owningCompletePackage != null) {
            owningCompletePackage.getPartialPackages().uninstalled(completeClass);
        }
        this.completeInheritance = null;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 != null) {
            name2partialOperations2.clear();
            this.name2partialOperations = null;
        }
        if ((name2partialProperties2 = this.name2partialProperties) != null) {
            name2partialProperties2.clear();
            this.name2partialProperties = null;
        }
        this.superCompleteClasses = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized Type findSpecializedType(@NonNull TemplateParameters templateArguments) {
        TemplateSignature templateSignature = this.getCompleteClass().getPrimaryClass().getOwnedSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        int iMax = templateParameters.size();
        if (templateArguments.parametersSize() != iMax) {
            return null;
        }
        Map<TemplateParameters, WeakReference<Class>> specializations2 = this.specializations;
        if (specializations2 == null) {
            return null;
        }
        WeakReference<Class> weakReference = specializations2.get(templateArguments);
        if (weakReference == null) {
            return null;
        }
        Class type = (Class)weakReference.get();
        if (type == null) {
            Map<TemplateParameters, WeakReference<Class>> map = specializations2;
            synchronized (map) {
                type = (Class)weakReference.get();
                if (type == null) {
                    specializations2.remove(templateArguments);
                }
            }
        }
        return type;
    }

    private void gatherAllStereotypes(@NonNull Set<Stereotype> allStereotypes, @NonNull Iterable<Stereotype> moreStereotypes) {
        HashSet<Stereotype> newStereotypes = null;
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        for (Stereotype stereotype : moreStereotypes) {
            if (!allStereotypes.add(stereotype = metamodelManager.getPrimaryElement(stereotype))) continue;
            CompleteClassInternal superCompleteClass = null;
            superCompleteClass = stereotype instanceof CompleteInheritanceImpl ? ((CompleteInheritanceImpl)((Object)stereotype)).getCompleteClass() : this.getCompleteModel().getCompleteClass(stereotype);
            if (newStereotypes == null) {
                newStereotypes = new HashSet<Stereotype>();
            }
            for (Class partialType : superCompleteClass.getPartialClasses()) {
                if (!(partialType instanceof Stereotype)) continue;
                Stereotype partialStereotype = (Stereotype)partialType;
                newStereotypes.add(partialStereotype);
                for (Class superType : partialStereotype.getSuperClasses()) {
                    if (!(superType instanceof Stereotype)) continue;
                    Stereotype superStereotype = (Stereotype)superType;
                    superType = metamodelManager.getPrimaryElement(superStereotype);
                    newStereotypes.add(superStereotype);
                }
            }
        }
        if (newStereotypes != null) {
            this.gatherAllStereotypes(allStereotypes, newStereotypes);
        }
    }

    @NonNull
    public CompleteClassInternal getCompleteClass() {
        return (CompleteClassImpl)this.owner;
    }

    @NonNull
    public final CompleteInheritanceImpl getCompleteInheritance() {
        CompleteInheritanceImpl completeInheritance2 = this.completeInheritance;
        if (completeInheritance2 == null) {
            Class behavioralClass;
            CompleteClassInternal completeClass = this.getCompleteClass();
            Class pivotClass = completeClass.getPrimaryClass();
            if (pivotClass instanceof DataType && (behavioralClass = ((DataType)pivotClass).getBehavioralClass()) != null) {
                completeClass = this.getCompleteModel().getCompleteClass(behavioralClass);
                completeInheritance2 = completeClass.getCompleteInheritance();
            }
            if (completeInheritance2 == null) {
                CompletePackageInternal completePackage = completeClass.getOwningCompletePackage();
                completeInheritance2 = completePackage.getCompleteInheritance(completeClass);
            }
            this.completeInheritance = completeInheritance2;
        }
        return completeInheritance2;
    }

    @NonNull
    public CompleteModelInternal getCompleteModel() {
        return this.getCompleteClass().getCompleteModel();
    }

    @NonNull
    public EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.getCompleteClass().getEnvironmentFactory();
    }

    @NonNull
    public Iterable<? extends CompleteInheritance> getInitialSuperInheritances() {
        final Iterator<CompleteClassInternal> iterator = this.computeSuperCompleteClasses().iterator();
        return new Iterable<CompleteInheritance>(){

            @Override
            public Iterator<CompleteInheritance> iterator() {
                return new Iterator<CompleteInheritance>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public CompleteInheritance next() {
                        CompleteClassInternal next = (CompleteClassInternal)iterator.next();
                        return next.getCompleteInheritance();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NonNull
    public PivotMetamodelManager getMetamodelManager() {
        return this.getCompleteClass().getMetamodelManager();
    }

    @Nullable
    public Operation getOperation(@NonNull OperationId operationId) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(operationName = operationId.getName())) == null) {
            return null;
        }
        return partialOperations.getOperation(operationId.getParametersId(), null);
    }

    @Nullable
    public Operation getOperation(@NonNull Operation pivotOperation) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(operationName = pivotOperation.getName())) == null) {
            return null;
        }
        return partialOperations.getOperation(pivotOperation.getParametersId(), pivotOperation.isIsStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC);
    }

    @NonNull
    public Iterable<String> getOperationNames() {
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        Set<String> keySet = name2partialOperations2.keySet();
        return keySet;
    }

    @Nullable
    public Iterable<Operation> getOperationOverloads(@NonNull Operation pivotOperation) {
        String operationName;
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(operationName = pivotOperation.getName())) == null) {
            return null;
        }
        ParametersId parametersId = pivotOperation.getParametersId();
        return partialOperations.getOperationOverloads(parametersId, pivotOperation.isIsStatic() ? FeatureFilter.SELECT_STATIC : FeatureFilter.SELECT_NON_STATIC);
    }

    @NonNull
    public Iterable<Operation> getOperationOverloads(@Nullable FeatureFilter featureFilter, @Nullable String name) {
        PartialOperations partialOperations;
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        if ((partialOperations = name2partialOperations2.get(name)) == null) {
            return PivotMetamodelManager.EMPTY_OPERATION_LIST;
        }
        return partialOperations.getOperationOverloads(featureFilter);
    }

    @NonNull
    public Iterable<Operation> getOperations() {
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        Iterable transformed = Iterables.transform(name2partialOperations2.values(), PartialOperations.partialOperations2allOperations);
        Iterable concat = Iterables.concat((Iterable)Iterables.concat((Iterable)transformed));
        return concat;
    }

    @NonNull
    public Iterable<Operation> getOperations(final @Nullable FeatureFilter featureFilter) {
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.initMemberOperations();
        }
        Collection<PartialOperations> itMapListOps = name2partialOperations2.values();
        Iterable itItListOps = Iterables.transform(itMapListOps, PartialOperations.partialOperations2allOperations);
        Iterable itListOps = Iterables.concat((Iterable)itItListOps);
        Iterable itOps = Iterables.concat((Iterable)itListOps);
        if (featureFilter == null) {
            return itOps;
        }
        Iterable subItOps = Iterables.filter((Iterable)itOps, (Predicate)new Predicate<Operation>(){

            public boolean apply(Operation domainOperation) {
                return domainOperation != null && featureFilter.accept(domainOperation);
            }
        });
        return subItOps;
    }

    @NonNull
    public Iterable<Property> getProperties(final @Nullable FeatureFilter featureFilter) {
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        Iterable transform = Iterables.transform(name2partialProperties2.values(), (Function)new Function<PartialProperties, Property>(){

            public Property apply(PartialProperties properties) {
                return properties.get();
            }
        });
        if (featureFilter == null) {
            return transform;
        }
        Iterable subItOps = Iterables.filter((Iterable)transform, (Predicate)new Predicate<Property>(){

            public boolean apply(Property domainProperty) {
                return domainProperty != null && featureFilter.accept(domainProperty);
            }
        });
        return subItOps;
    }

    @NonNull
    public Iterable<Property> getProperties(final @Nullable FeatureFilter featureFilter, @Nullable String name) {
        PartialProperties partials;
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        if ((partials = name2partialProperties2.get(name)) == null || partials.isEmpty()) {
            return PivotMetamodelManager.EMPTY_PROPERTY_LIST;
        }
        if (featureFilter == null) {
            return partials;
        }
        Iterable subItOps = Iterables.filter((Iterable)partials, (Predicate)new Predicate<Property>(){

            public boolean apply(Property domainProperty) {
                return domainProperty != null && featureFilter.accept(domainProperty);
            }
        });
        return subItOps;
    }

    @Nullable
    public Iterable<Property> getProperties(@NonNull Property pivotProperty) {
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        String propertyName = pivotProperty.getName();
        return name2partialProperties2.get(propertyName);
    }

    @Nullable
    public Iterable<Property> getProperties(@Nullable String propertyName) {
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        return name2partialProperties2.get(propertyName);
    }

    @Nullable
    public Property getProperty(@Nullable String propertyName) {
        PartialProperties partials;
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.initMemberProperties();
        }
        if ((partials = name2partialProperties2.get(propertyName)) == null) {
            return null;
        }
        return partials.get();
    }

    @NonNull
    public synchronized Class getSpecializedType(@NonNull List<? extends Type> templateArguments) {
        return this.getSpecializedType(TypeUtil.createTemplateParameters(templateArguments));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public synchronized Class getSpecializedType(@NonNull TemplateParameters templateArguments) {
        Object object;
        TemplateSignature templateSignature = this.getCompleteClass().getPrimaryClass().getOwnedSignature();
        List<TemplateParameter> templateParameters = templateSignature.getOwnedParameters();
        int iMax = templateParameters.size();
        if (templateArguments.parametersSize() != iMax) {
            throw new IllegalArgumentException("Incompatible template argument count");
        }
        Map<TemplateParameters, WeakReference<Class>> specializations2 = this.specializations;
        if (specializations2 == null) {
            object = this;
            synchronized (object) {
                specializations2 = this.specializations;
                if (specializations2 == null) {
                    specializations2 = this.specializations = new HashMap<TemplateParameters, WeakReference<Class>>();
                }
            }
        }
        object = specializations2;
        synchronized (object) {
            Class specializedType = null;
            WeakReference<Class> weakReference = specializations2.get(templateArguments);
            if (weakReference != null) {
                specializedType = (Class)weakReference.get();
            }
            if (specializedType == null) {
                specializedType = this.createSpecialization(templateArguments);
                specializations2.put(templateArguments, new WeakReference<Class>(specializedType));
            }
            return specializedType;
        }
    }

    @NonNull
    public StandardLibraryInternal getStandardLibrary() {
        return this.getCompleteModel().getStandardLibrary();
    }

    @NonNull
    public Iterable<State> getStates() {
        Map<String, State> name2states2 = this.name2states;
        if (name2states2 == null) {
            name2states2 = this.initStates();
        }
        Collection<State> values = name2states2.values();
        return values;
    }

    @NonNull
    public Iterable<State> getStates(@Nullable String name) {
        State state;
        Map<String, State> name2states2 = this.name2states;
        if (name2states2 == null) {
            name2states2 = this.initStates();
        }
        if ((state = name2states2.get(name)) == null) {
            return PivotMetamodelManager.EMPTY_STATE_LIST;
        }
        List<State> singletonList = Collections.singletonList(state);
        return singletonList;
    }

    @NonNull
    public Iterable<CompleteClass> getSuperCompleteClasses() {
        CompleteInheritanceImpl inheritance = this.getCompleteClass().getCompleteInheritance();
        return Iterables.transform(inheritance.getAllSuperFragments(), (Function)new Function<InheritanceFragment, CompleteClass>(){

            public CompleteClass apply(InheritanceFragment input) {
                return ((CompleteInheritanceImpl)input.getBaseInheritance()).getCompleteClass();
            }
        });
    }

    protected void initExtensionPropertiesFrom(@NonNull Class baseType, @NonNull Stereotype stereotype) {
        PivotMetamodelManager metamodelManager = this.getMetamodelManager();
        ElementExtension elementExtension = metamodelManager.getElementExtension(baseType, stereotype);
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        assert (name2partialProperties2 != null);
        Property extensionProperty = this.createExtensionProperty(elementExtension, baseType);
        this.didAddProperty(extensionProperty);
        if (ADD_EXTENSION_PROPERTY.isActive()) {
            ADD_EXTENSION_PROPERTY.println(String.valueOf(NameUtil.qualifiedNameFor(extensionProperty)) + " => " + NameUtil.qualifiedNameFor(extensionProperty.getType()));
        }
    }

    public void initMemberFeaturesFrom(@NonNull Class pivotType) {
        if (this.name2partialOperations != null) {
            this.initMemberOperationsFrom(pivotType);
        }
        if (this.name2partialProperties != null) {
            this.initMemberPropertiesFrom(pivotType);
        }
    }

    @NonNull
    private Map<String, PartialOperations> initMemberOperations() {
        Map<String, PartialOperations> name2partialOperations2 = this.name2partialOperations;
        if (name2partialOperations2 == null) {
            name2partialOperations2 = this.name2partialOperations = new HashMap<String, PartialOperations>();
            for (CompleteClass superCompleteClass : this.getSuperCompleteClasses()) {
                if (superCompleteClass == null) continue;
                for (Class superType : superCompleteClass.getPartialClasses()) {
                    Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(superType);
                    CompleteClassInternal unspecializedCompleteClass = this.getCompleteModel().getCompleteClass(unspecializedType);
                    for (Class unspecializedPartialType : unspecializedCompleteClass.getPartialClasses()) {
                        assert (unspecializedPartialType != null);
                        this.initMemberOperationsFrom(unspecializedPartialType);
                    }
                }
            }
            for (PartialOperations partialOperations : name2partialOperations2.values()) {
                partialOperations.initMemberOperationsPostProcess();
            }
        }
        return name2partialOperations2;
    }

    private void initMemberOperationsFrom(@NonNull Class type) {
        if (INIT_MEMBER_OPERATIONS.isActive()) {
            INIT_MEMBER_OPERATIONS.println(this + " from " + type);
        }
        for (Operation pivotOperation : type.getOwnedOperations()) {
            if (pivotOperation.getName() == null) continue;
            this.didAddOperation(pivotOperation);
        }
    }

    @NonNull
    protected Map<String, PartialProperties> initMemberProperties() {
        Map<String, PartialProperties> name2partialProperties2 = this.name2partialProperties;
        if (name2partialProperties2 == null) {
            name2partialProperties2 = this.name2partialProperties = new HashMap<String, PartialProperties>();
            ArrayList<ElementExtension> allExtensions = null;
            HashSet<Object> extendingStereotypes = null;
            HashSet<Class> extendedTypes = null;
            for (CompleteClass superCompleteClass : this.getSuperCompleteClasses()) {
                if (superCompleteClass == null) continue;
                for (Class superType : superCompleteClass.getPartialClasses()) {
                    List<StereotypeExtender> extensionOfs;
                    Class unspecializedType = PivotUtil.getUnspecializedTemplateableElement(superType);
                    List<StereotypeExtender> extendedBys = unspecializedType.getExtenders();
                    if (extendedBys.size() > 0) {
                        if (extendingStereotypes == null) {
                            extendingStereotypes = new HashSet<Object>();
                        }
                        for (StereotypeExtender typeExtension : extendedBys) {
                            Stereotype stereotype = typeExtension.getOwningStereotype();
                            if (stereotype == null) continue;
                            extendingStereotypes.add(stereotype);
                        }
                    }
                    if (unspecializedType instanceof Stereotype && (extensionOfs = ((Stereotype)unspecializedType).getOwnedExtenders()).size() > 0) {
                        if (extendedTypes == null) {
                            extendedTypes = new HashSet<Class>();
                        }
                        for (StereotypeExtender typeExtension : extensionOfs) {
                            Class type = typeExtension.getClass_();
                            if (type == null) continue;
                            extendedTypes.add(type);
                        }
                    }
                    CompleteClassInternal unspecializedCompleteClass = this.getCompleteModel().getCompleteClass(unspecializedType);
                    for (Class unspecializedPartialType : unspecializedCompleteClass.getPartialClasses()) {
                        this.initMemberPropertiesFrom(unspecializedPartialType);
                        List<ElementExtension> extensions = unspecializedPartialType.getOwnedExtensions();
                        if (extensions.size() <= 0) continue;
                        if (allExtensions == null) {
                            allExtensions = new ArrayList<ElementExtension>();
                        }
                        allExtensions.addAll(extensions);
                    }
                }
            }
            Class pivotClass = this.getCompleteClass().getPrimaryClass();
            if (INIT_MEMBER_PROPERTIES.isActive()) {
                INIT_MEMBER_PROPERTIES.println(this + " for " + pivotClass + " " + NameUtil.debugSimpleName(pivotClass));
            }
            if (extendingStereotypes != null) {
                HashSet<Stereotype> allStereotypes = new HashSet<Stereotype>();
                this.gatherAllStereotypes(allStereotypes, extendingStereotypes);
                for (Stereotype stereotype : allStereotypes) {
                    Class baseType = pivotClass;
                    this.initExtensionPropertiesFrom(baseType, stereotype);
                }
            }
            String metatypeName = pivotClass.eClass().getName();
            CompletePackageInternal rootCompletePackage = this.getCompleteClass().getOwningCompletePackage().getRootCompletePackage();
            Package pivotPackage = rootCompletePackage.getPrimaryPackage();
            if (pivotPackage != null) {
                EnvironmentFactoryInternal environmentFactory = this.getEnvironmentFactory();
                PackageId metapackageId = environmentFactory.getTechnology().getMetapackageId(environmentFactory, pivotPackage);
                Package metapackage = environmentFactory.getIdResolver().getPackage(metapackageId);
                CompletePackage metaCompletePackage = this.getMetamodelManager().getCompletePackage(metapackage);
                Type metatype = metaCompletePackage.getType(metatypeName);
                if (metatype != null) {
                    CompleteClassInternal metaCompleteClass = this.getCompleteModel().getCompleteClass(metatype);
                    for (Property property : metaCompleteClass.getProperties(FeatureFilter.SELECT_STATIC)) {
                        this.didAddProperty(property);
                    }
                }
            }
            for (PartialProperties properties : name2partialProperties2.values()) {
                if (properties == null) continue;
                this.initMemberPropertiesPostProcess(this.getCompleteClass().getName(), properties);
            }
        }
        return name2partialProperties2;
    }

    protected void initMemberPropertiesFrom(@NonNull Class asType) {
        Class asPrimaryType = PivotUtil.getUnspecializedTemplateableElement(asType);
        if (INIT_MEMBER_PROPERTIES.isActive()) {
            INIT_MEMBER_PROPERTIES.println(this + " from " + asPrimaryType + " " + NameUtil.debugSimpleName(asPrimaryType));
        }
        for (ElementExtension extension : asPrimaryType.getOwnedExtensions()) {
            assert (extension != null);
        }
        for (Property pivotProperty : asPrimaryType.getOwnedProperties()) {
            this.didAddProperty(pivotProperty);
        }
    }

    protected void initMemberPropertiesPostProcess(String name, @NonNull PartialProperties properties) {
    }

    @NonNull
    protected Map<String, State> initStates() {
        HashMap<String, State> name2states = new HashMap<String, State>();
        for (CompleteClass superCompleteClass : this.getSuperCompleteClasses()) {
            if (superCompleteClass == null) continue;
            for (Class superPartialClass : superCompleteClass.getPartialClasses()) {
                assert (superPartialClass != null);
                for (Behavior behavior : superPartialClass.getOwnedBehaviors()) {
                    if (!(behavior instanceof StateMachine)) continue;
                    List<Region> regions = ((StateMachine)behavior).getOwnedRegions();
                    this.initStatesForRegions(name2states, regions);
                }
            }
        }
        return name2states;
    }

    protected void initStatesForRegions(@NonNull Map<String, State> name2states, @NonNull List<Region> regions) {
        for (Region region : regions) {
            for (Vertex vertex : region.getOwnedSubvertexes()) {
                if (!(vertex instanceof State)) continue;
                State state = (State)vertex;
                name2states.put(vertex.getName(), state);
                List<Region> nestedRegions = state.getOwnedRegions();
                this.initStatesForRegions(name2states, nestedRegions);
            }
        }
    }
}

