/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.context;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.internal.context.Base2ASConversion;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public abstract class AbstractBase2ASConversion
extends AbstractConversion
implements Base2ASConversion {
    private HashSet<TypedElement> underspecifiedTypedElements = null;

    protected AbstractBase2ASConversion(@NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
    }

    protected void addUnderspecifiedTypedElement(@NonNull TypedElement pivotElement) {
        if (this.underspecifiedTypedElements == null) {
            this.underspecifiedTypedElements = new HashSet();
        }
        this.underspecifiedTypedElements.add(pivotElement);
    }

    public void refreshName(@NonNull NamedElement pivotNamedElement, @Nullable String newName) {
        String oldName = pivotNamedElement.getName();
        if (!(newName == oldName || newName != null && newName.equals(oldName))) {
            pivotNamedElement.setName(newName);
        }
    }

    public void refreshNsURI(@NonNull Package pivotPackage, String newNsURI) {
        String oldNsURI = pivotPackage.getURI();
        if (!(newNsURI == oldNsURI || newNsURI != null && newNsURI.equals(oldNsURI))) {
            pivotPackage.setURI(newNsURI);
        }
    }

    public void setBehavioralType(@NonNull TypedElement targetElement, @NonNull TypedElement sourceElement) {
        if (!sourceElement.eIsProxy()) {
            Type type = PivotUtilInternal.getType(sourceElement);
            if (type != null && type.eIsProxy()) {
                type = null;
            }
            boolean isRequired = sourceElement.isIsRequired();
            this.setType(targetElement, type, isRequired);
        }
    }

    @Override
    public void setContextVariable(@NonNull ExpressionInOCL pivotSpecification, @NonNull String selfVariableName, @Nullable Type contextType, @Nullable Type contextInstance) {
        Variable contextVariable = pivotSpecification.getOwnedContext();
        if (contextVariable == null) {
            Variable nonNullContextVariable;
            contextVariable = nonNullContextVariable = PivotFactory.eINSTANCE.createVariable();
            pivotSpecification.setOwnedContext(contextVariable);
        }
        this.refreshName(contextVariable, selfVariableName);
        this.setType(contextVariable, contextType, contextVariable.isIsRequired(), contextInstance);
    }

    @Override
    public void setClassifierContext(@NonNull ExpressionInOCL pivotSpecification, @NonNull Type contextType) {
        Variable contextVariable = pivotSpecification.getOwnedContext();
        if (contextVariable != null) {
            if (contextType.eIsProxy()) {
                this.setType(contextVariable, null, false);
            } else {
                this.setType(contextVariable, contextType, true);
            }
        }
    }

    public void setOperationContext(@NonNull ExpressionInOCL pivotSpecification, @NonNull Operation contextOperation, @Nullable String resultName) {
        Variable contextVariable = pivotSpecification.getOwnedContext();
        if (contextVariable != null && !contextOperation.eIsProxy()) {
            this.setType(contextVariable, contextOperation.getOwningClass(), true);
            this.setParameterVariables(pivotSpecification, ClassUtil.nonNullEMF(contextOperation.getOwnedParameters()));
        }
        if (resultName != null) {
            this.setResultVariable(pivotSpecification, contextOperation, resultName);
        }
    }

    @Override
    public void setParameterVariables(@NonNull ExpressionInOCL pivotSpecification, @NonNull List<Parameter> parameters) {
        ArrayList<Variable> oldVariables = new ArrayList<Variable>(pivotSpecification.getOwnedParameters());
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (Parameter parameter : parameters) {
            String name = parameter.getName();
            Variable param = NameUtil.getNameable(oldVariables, name);
            if (param != null) {
                oldVariables.remove(param);
            } else {
                param = PivotFactory.eINSTANCE.createVariable();
                param.setName(name);
            }
            this.setBehavioralType(param, parameter);
            param.setRepresentedParameter(parameter);
            newVariables.add(param);
        }
        this.refreshList(ClassUtil.nonNullModel(pivotSpecification.getOwnedParameters()), newVariables);
    }

    @Override
    public void setParameterVariables(@NonNull ExpressionInOCL pivotSpecification, @NonNull Map<String, Type> parameters) {
        ArrayList<Variable> oldVariables = new ArrayList<Variable>(pivotSpecification.getOwnedParameters());
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        for (String name : parameters.keySet()) {
            Type type = parameters.get(name);
            Variable param = NameUtil.getNameable(oldVariables, name);
            if (param != null) {
                oldVariables.remove(param);
            } else {
                param = PivotFactory.eINSTANCE.createVariable();
                param.setName(name);
            }
            this.setType(param, type, param.isIsRequired());
            newVariables.add(param);
        }
        this.refreshList(ClassUtil.nonNullModel(pivotSpecification.getOwnedParameters()), newVariables);
    }

    public void setPropertyContext(@NonNull ExpressionInOCL pivotSpecification, @NonNull Property contextProperty) {
        Variable contextVariable = pivotSpecification.getOwnedContext();
        if (contextVariable != null && !contextProperty.eIsProxy()) {
            this.setType(contextVariable, contextProperty.getOwningClass(), true);
        }
    }

    @Override
    public void setResultVariable(@NonNull ExpressionInOCL pivotSpecification, @NonNull Operation contextOperation, @NonNull String resultName) {
        Type returnType = contextOperation.getType();
        if (returnType != null) {
            Variable resultVariable = pivotSpecification.getOwnedResult();
            if (resultVariable == null) {
                resultVariable = PivotFactory.eINSTANCE.createVariable();
            }
            resultVariable.setName(resultName);
            this.setBehavioralType(resultVariable, contextOperation);
            pivotSpecification.setOwnedResult(resultVariable);
        } else {
            pivotSpecification.setOwnedResult(null);
        }
    }

    @Deprecated
    public void setType(@NonNull TypedElement pivotElement, Type type) {
        this.setType(pivotElement, type, pivotElement.isIsRequired());
    }

    public void setType(@NonNull OCLExpression pivotElement, Type type, boolean isRequired, @Nullable Type typeValue) {
        Type primaryTypeValue;
        this.setType(pivotElement, type, isRequired);
        Type type2 = primaryTypeValue = typeValue != null ? this.metamodelManager.getPrimaryType(typeValue) : null;
        if (primaryTypeValue != pivotElement.getTypeValue()) {
            pivotElement.setTypeValue(primaryTypeValue);
        }
    }

    public void setType(@NonNull VariableDeclaration pivotElement, Type type, boolean isRequired, @Nullable Type typeValue) {
        Type primaryTypeValue;
        this.setType(pivotElement, type, isRequired);
        Type type2 = primaryTypeValue = typeValue != null ? this.metamodelManager.getPrimaryType(typeValue) : null;
        if (primaryTypeValue != pivotElement.getTypeValue()) {
            pivotElement.setTypeValue(primaryTypeValue);
        }
    }

    public void setType(@NonNull TypedElement pivotElement, Type type, boolean isRequired) {
        boolean wasRequired;
        Type primaryType;
        Type type2 = primaryType = type != null ? this.metamodelManager.getPrimaryType(type) : null;
        if (primaryType != pivotElement.getType()) {
            pivotElement.setType(primaryType);
        }
        if ((wasRequired = pivotElement.isIsRequired()) != isRequired) {
            pivotElement.setIsRequired(isRequired);
        }
        if (primaryType != null) {
            PivotUtil.debugWellContainedness(primaryType);
        }
    }
}

