/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.context;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.context.AbstractParserContext;
import org.eclipse.ocl.pivot.internal.context.Base2ASConversion;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;

public class EObjectContext
extends AbstractParserContext {
    @Nullable
    protected final EObject eObject;
    private Type classContext = null;

    public EObjectContext(@NonNull EnvironmentFactory environmentFactory, @Nullable URI uri, @Nullable EObject eObject) {
        super(environmentFactory, uri);
        this.eObject = eObject;
    }

    @Override
    @NonNull
    public Type getClassContext() {
        Type classContext2 = this.classContext;
        if (classContext2 == null) {
            PivotMetamodelManager metamodelManager = this.getMetamodelManager();
            try {
                if (this.eObject instanceof Type) {
                    classContext2 = metamodelManager.getMetaclass((Type)this.eObject);
                } else if (this.eObject != null) {
                    classContext2 = metamodelManager.getASOf(Type.class, (EObject)this.eObject.eClass());
                }
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            if (classContext2 == null) {
                classContext2 = metamodelManager.getStandardLibrary().getOclVoidType();
            }
            this.classContext = classContext2;
        }
        return classContext2;
    }

    @Override
    public void initialize(@NonNull Base2ASConversion conversion, @NonNull ExpressionInOCL expression) {
        super.initialize(conversion, expression);
        Type classContext = this.getClassContext();
        conversion.setContextVariable(expression, "self", classContext, null);
    }
}

