/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegateExtension;

public class OCLDelegateValidator
extends EObjectValidator {
    @Nullable
    protected final EObjectValidator eValidator;

    protected static void reportInvariantDelegateViolation(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, EOperation invariant, int severity, String source, int code) {
        String contextName = String.valueOf(invariant.getEContainingClass().getName()) + "::" + invariant.getName();
        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{contextName, OCLDelegateValidator.getObjectLabel((EObject)eObject, context)}), new Object[]{eObject}));
    }

    public OCLDelegateValidator(@Nullable EObjectValidator eValidator) {
        this.eValidator = eValidator;
    }

    protected void reportWrappedException(@Nullable Object object, @NonNull DiagnosticChain diagnostics, Map<Object, Object> context, int severity, String source, int code, @NonNull WrappedException wrappedException) {
        String message = wrappedException.getLocalizedMessage();
        Exception exception = wrappedException.exception();
        if (exception == null) {
            exception = wrappedException;
        } else assert (message != null);
        diagnostics.add((Diagnostic)new BasicDiagnostic(severity, source, code, message, new Object[]{object, exception}));
    }

    protected boolean validate(int classifierID, Object object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (classifierID != 10) {
            return true;
        }
        if (this.eValidator != null) {
            return this.eValidator.validate_EveryDefaultConstraint((EObject)object, diagnostics, context);
        }
        return this.validate_EveryDefaultConstraint((EObject)object, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        assert (eClass != null);
        assert (eObject != null);
        boolean result = this.validateDelegatedInvariants(eClass, eObject, diagnostics, context);
        if ((result || diagnostics != null) && ((result &= this.validateDelegatedConstraints(eClass, eObject, diagnostics, context)) || diagnostics != null)) {
            EList eSuperTypes = eClass.getESuperTypes();
            result &= eSuperTypes.isEmpty() ? this.validate_EveryDefaultConstraint(eObject, diagnostics, context) : (eClass.eContainer() == this.getEPackage() ? this.validate(eClass.getClassifierID(), (Object)eObject, diagnostics, context) : this.validate((EClass)eSuperTypes.get(0), eObject, diagnostics, context));
        }
        return result;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context, String validationDelegate, String constraint, String expression, int severity, String source, int code) {
        assert (eClass != null);
        assert (eObject != null);
        assert (constraint != null);
        assert (validationDelegate != null);
        return this.validateDelegatedConstraint(eClass, eObject, diagnostics, context, validationDelegate, constraint, expression, severity, source, code);
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context, String validationDelegate, String constraint, String expression, int severity, String source, int code) {
        assert (eDataType != null);
        assert (value != null);
        assert (constraint != null);
        assert (validationDelegate != null);
        return this.validateDelegatedConstraint(eDataType, value, diagnostics, context, validationDelegate, constraint, expression, severity, source, code);
    }

    protected boolean validateDelegatedConstraints(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        List validationDelegates = EcoreUtil.getValidationDelegates((EPackage)eClass.getEPackage());
        if (!validationDelegates.isEmpty()) {
            block0: for (String constraint : EcoreUtil.getConstraints((EModelElement)eClass)) {
                if (constraint == null) continue;
                for (String validationDelegate : validationDelegates) {
                    String expression;
                    if (validationDelegate != null && (expression = EcoreUtil.getAnnotation((EModelElement)eClass, (String)validationDelegate, (String)constraint)) != null && !(result &= this.validateDelegatedConstraint(eClass, eObject, diagnostics, context, validationDelegate, constraint, expression, 4, "org.eclipse.emf.ecore", 0)) && diagnostics == null) break block0;
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateDelegatedConstraint(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String validationDelegate, @NonNull String constraint, String expression, int severity, String source, int code) {
        EValidator.ValidationDelegate delegate = OCLDelegateValidator.getValidationDelegateRegistry(context).getValidationDelegate(validationDelegate);
        if (delegate != null) {
            try {
                if (delegate instanceof ValidationDelegateExtension) {
                    return ((ValidationDelegateExtension)delegate).validate(eClass, eObject, diagnostics, context, constraint, expression, severity, source, code);
                }
                if (delegate.validate(eClass, eObject, context, constraint, expression)) return true;
                if (diagnostics == null) return false;
                this.reportConstraintDelegateViolation(eClass, eObject, diagnostics, context, constraint, severity, source, code);
                return false;
            }
            catch (WrappedException e) {
                if (diagnostics == null) return true;
                this.reportWrappedException(eObject, diagnostics, context, severity, source, code, e);
                return true;
            }
            catch (Throwable throwable) {
                if (diagnostics == null) return true;
                this.reportConstraintDelegateException(eClass, eObject, diagnostics, context, constraint, severity, source, code, throwable);
                return true;
            }
        } else {
            if (diagnostics == null) return true;
            this.reportConstraintDelegateNotFound(eClass, eObject, diagnostics, context, constraint, severity, source, code, validationDelegate);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateDelegatedConstraint(@NonNull EDataType eDataType, @NonNull Object value, DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String validationDelegate, @NonNull String constraint, String expression, int severity, String source, int code) {
        EValidator.ValidationDelegate delegate = OCLDelegateValidator.getValidationDelegateRegistry(context).getValidationDelegate(validationDelegate);
        if (delegate != null) {
            try {
                if (delegate instanceof ValidationDelegateExtension) {
                    return ((ValidationDelegateExtension)delegate).validate(eDataType, value, diagnostics, context, constraint, expression, severity, source, code);
                }
                if (delegate.validate(eDataType, value, context, constraint, expression)) return true;
                if (diagnostics == null) return false;
                this.reportConstraintDelegateViolation(eDataType, value, diagnostics, context, constraint, severity, source, code);
                return false;
            }
            catch (WrappedException e) {
                if (diagnostics == null) return true;
                this.reportWrappedException(value, diagnostics, context, severity, source, code, e);
                return true;
            }
            catch (Throwable throwable) {
                if (diagnostics == null) return true;
                this.reportConstraintDelegateException(eDataType, value, diagnostics, context, constraint, severity, source, code, throwable);
                return true;
            }
        } else {
            if (diagnostics == null) return true;
            this.reportConstraintDelegateNotFound(eDataType, value, diagnostics, context, constraint, severity, source, code, validationDelegate);
        }
        return true;
    }

    protected boolean validateDelegatedInvariants(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        List validationDelegates = EcoreUtil.getValidationDelegates((EPackage)eClass.getEPackage());
        if (!validationDelegates.isEmpty()) {
            block0: for (EOperation eOperation : eClass.getEOperations()) {
                if (eOperation == null || !EcoreUtil.isInvariant((EOperation)eOperation)) continue;
                for (String validationDelegate : validationDelegates) {
                    String expression;
                    if (validationDelegate != null && (expression = EcoreUtil.getAnnotation((EModelElement)eOperation, (String)validationDelegate, (String)"body")) != null && !(result &= this.validateDelegatedInvariant(eClass, eObject, diagnostics, context, validationDelegate, eOperation, expression, 4, "org.eclipse.emf.ecore", 0)) && diagnostics == null) break block0;
                }
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateDelegatedInvariant(@NonNull EClass eClass, @NonNull EObject eObject, @Nullable DiagnosticChain diagnostics, Map<Object, Object> context, @NonNull String validationDelegate, @NonNull EOperation invariant, @NonNull String expression, int severity, String source, int code) {
        EValidator.ValidationDelegate delegate = OCLDelegateValidator.getValidationDelegateRegistry(context).getValidationDelegate(validationDelegate);
        if (delegate != null) {
            try {
                if (delegate instanceof ValidationDelegateExtension) {
                    return ((ValidationDelegateExtension)delegate).validate(eClass, eObject, diagnostics, context, invariant, expression, severity, source, code);
                }
                if (delegate.validate(eClass, eObject, context, invariant, expression)) return true;
                if (diagnostics == null) return false;
                OCLDelegateValidator.reportInvariantDelegateViolation(eClass, eObject, diagnostics, context, invariant, severity, source, code);
                return false;
            }
            catch (WrappedException e) {
                if (diagnostics == null) return true;
                this.reportWrappedException(eObject, diagnostics, context, severity, source, code, e);
                return true;
            }
            catch (Throwable throwable) {
                if (diagnostics == null) return true;
                OCLDelegateValidator.reportInvariantDelegateException((EClass)eClass, (EObject)eObject, (DiagnosticChain)diagnostics, context, (EOperation)invariant, (int)severity, (String)source, (int)code, (Throwable)throwable);
                return true;
            }
        } else {
            if (diagnostics == null) return true;
            OCLDelegateValidator.reportInvariantDelegateNotFound((EClass)eClass, (EObject)eObject, (DiagnosticChain)diagnostics, context, (EOperation)invariant, (int)severity, (String)source, (int)code, (String)validationDelegate);
        }
        return true;
    }
}

