/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.SettingBehavior;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.SemanticException;

public class OCLSettingDelegate
extends BasicSettingDelegate.Stateless {
    @NonNull
    protected final OCLDelegateDomain delegateDomain;
    private Property property;
    private ExpressionInOCL query;

    public OCLSettingDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EStructuralFeature structuralFeature) {
        super(structuralFeature);
        this.delegateDomain = delegateDomain;
    }

    @Nullable
    protected Object evaluateEcore(@NonNull OCL ocl, @NonNull ExpressionInOCL query, @Nullable Object target) {
        Query query2 = ocl.createQuery(query);
        return query2.evaluateEcore(this.eStructuralFeature.getEType().getInstanceClass(), target);
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        try {
            OCL ocl = this.delegateDomain.getOCL();
            MetamodelManager metamodelManager = ocl.getMetamodelManager();
            ExpressionInOCL query2 = this.query;
            if (query2 == null) {
                Property property2 = this.getProperty();
                query2 = this.query = SettingBehavior.INSTANCE.getQueryOrThrow(metamodelManager, property2);
                SettingBehavior.INSTANCE.validate(property2);
            }
            Object ecoreResult = this.evaluateEcore(ocl, query2, owner);
            return ecoreResult;
        }
        catch (EvaluationException e) {
            throw new OCLDelegateException(new EvaluationException(e, PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, this.property));
        }
    }

    @NonNull
    public Property getProperty() {
        Property property2 = this.property;
        if (property2 == null && (property2 = (this.property = this.delegateDomain.getPivot(Property.class, (EObject)ClassUtil.nonNullEMF(this.eStructuralFeature)))) == null) {
            throw new OCLDelegateException(new SemanticException("No pivot property for " + this.eStructuralFeature));
        }
        return property2;
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    public String toString() {
        if (this.property != null) {
            return "<" + this.delegateDomain.getURI() + ":setting> " + this.property;
        }
        String name = String.valueOf(this.eStructuralFeature.getEContainingClass().getEPackage().getName()) + "::" + this.eStructuralFeature.getEContainingClass().getName() + "." + this.eStructuralFeature.getName();
        return "<" + this.delegateDomain.getURI() + ":setting> " + name;
    }

    public static class Changeable
    extends OCLSettingDelegate {
        private Map<InternalEObject, Object> valueMap = null;

        public Changeable(@NonNull OCLDelegateDomain delegateDomain, @NonNull EStructuralFeature structuralFeature) {
            super(delegateDomain, structuralFeature);
        }

        @Override
        protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
            if (this.valueMap != null && this.valueMap.containsKey(owner)) {
                return this.valueMap.get(owner);
            }
            return super.get(owner, resolve, coreType);
        }

        @Override
        protected boolean isSet(InternalEObject owner) {
            return this.valueMap != null && this.valueMap.containsKey(owner);
        }

        protected void set(InternalEObject owner, Object newValue) {
            if (owner != null) {
                if (this.valueMap == null) {
                    this.valueMap = new HashMap<InternalEObject, Object>();
                }
                this.valueMap.put(owner, newValue);
            }
        }

        protected void unset(InternalEObject owner) {
            if (this.valueMap != null) {
                this.valueMap.remove(owner);
            }
        }
    }
}

