/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionItem;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionRange;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.IterateExp;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.MessageExp;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.SelfType;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.StateExp;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleLiteralPart;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.library.AbstractEvaluatorIterationManager;
import org.eclipse.ocl.pivot.library.EvaluatorMultipleIterationManager;
import org.eclipse.ocl.pivot.library.EvaluatorSingleIterationManager;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.LibraryIteration;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.library.LibraryProperty;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerRange;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.NullValue;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;

public class OCLEvaluationVisitor
extends AbstractEvaluationVisitor {
    public static boolean isSimpleRange(@NonNull CollectionLiteralExp cl) {
        List<CollectionLiteralPart> partsList = cl.getOwnedParts();
        int size = partsList.size();
        if (size == 1) {
            CollectionLiteralPart part = partsList.get(0);
            return part instanceof CollectionRange;
        }
        return false;
    }

    public OCLEvaluationVisitor(@NonNull EvaluationEnvironment evalEnv) {
        super(evalEnv);
    }

    @Override
    @NonNull
    public EvaluationVisitor createNestedEvaluator() {
        EvaluationEnvironment evaluationEnvironment = this.getEvaluationEnvironment();
        EvaluationEnvironment nestedEvalEnv = this.environmentFactory.createEvaluationEnvironment(evaluationEnvironment, evaluationEnvironment.getExecutableObject());
        OCLEvaluationVisitor nestedEvaluationVisitor = new OCLEvaluationVisitor(nestedEvalEnv);
        nestedEvaluationVisitor.setMonitor(this.getMonitor());
        return nestedEvaluationVisitor;
    }

    @NonNull
    public EvaluationVisitor createNestedUndecoratedEvaluator(@NonNull NamedElement operation) {
        return this.undecoratedVisitor.createNestedEvaluator();
    }

    @Override
    public void dispose() {
        if (this.undecoratedVisitor != this) {
            this.undecoratedVisitor.dispose();
        }
    }

    @Override
    @Nullable
    public Object evaluate(@NonNull OCLExpression body) {
        Object value = body.accept(this.undecoratedVisitor);
        assert (ValueUtil.isBoxed(value));
        return value;
    }

    protected Object evaluatePropertyCallExp(@NonNull NavigationCallExp navigationCallExp, @NonNull Property referredProperty) {
        Object sourceValue;
        OCLExpression source = navigationCallExp.getOwnedSource();
        Type propertyType = navigationCallExp.getType();
        assert (propertyType != null);
        EvaluationVisitor evaluationVisitor = this.undecoratedVisitor;
        Object object = sourceValue = source != null ? evaluationVisitor.evaluate(source) : null;
        if (navigationCallExp.isIsSafe() && sourceValue == null) {
            return null;
        }
        LibraryProperty implementation = this.metamodelManager.getImplementation(navigationCallExp, sourceValue, referredProperty);
        try {
            return implementation.evaluate(this, propertyType.getTypeId(), sourceValue);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, referredProperty, sourceValue, navigationCallExp);
        }
    }

    @Override
    @NonNull
    public EvaluationVisitor getEvaluator() {
        return this;
    }

    @NonNull
    public LibraryFeature lookupImplementation(@NonNull Class dynamicType, @NonNull Operation staticOperation) {
        CompleteInheritance inheritance = this.metamodelManager.getInheritance(dynamicType);
        return inheritance.getPivotClass().lookupImplementation(this.standardLibrary, staticOperation);
    }

    @Override
    public Object safeVisit(@Nullable Visitable v) {
        if (v == null) {
            throw new InvalidValueException("null expression", new Object[0]);
        }
        try {
            Object result = v.accept(this.undecoratedVisitor);
            assert (ValueUtil.isBoxed(result));
            return result;
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "Evaluation Failure");
        }
    }

    @Override
    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp booleanLiteralExp) {
        boolean value = booleanLiteralExp.isBooleanSymbol();
        return value;
    }

    @Override
    public Object visitCollectionItem(@NonNull CollectionItem item) {
        throw new UnsupportedOperationException("evaluation of CollectionItem");
    }

    @Override
    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp cl) {
        List<CollectionLiteralPart> parts = cl.getOwnedParts();
        CollectionType type = (CollectionType)cl.getType();
        boolean isOrdered = type.isOrdered();
        if (isOrdered && OCLEvaluationVisitor.isSimpleRange(cl)) {
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OCLExpression first = collRange.getOwnedFirst();
            OCLExpression last = collRange.getOwnedLast();
            Object firstVal = first.accept(this.undecoratedVisitor);
            Object lastVal = last.accept(this.undecoratedVisitor);
            IntegerValue firstInteger = ValueUtil.asIntegerValue(firstVal);
            IntegerValue lastInteger = ValueUtil.asIntegerValue(lastVal);
            CollectionTypeId typeId = type.getTypeId();
            IntegerRange range = ValueUtil.createRange(firstInteger, lastInteger);
            if (type.isUnique()) {
                return ValueUtil.createOrderedSetRange(typeId, range);
            }
            return ValueUtil.createSequenceRange(typeId, range);
        }
        ArrayList<Object> orderedResults = new ArrayList<Object>();
        HashSet<Object> uniqueResults = type.isUnique() ? new HashSet<Object>() : null;
        block0: for (CollectionLiteralPart part : parts) {
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OCLExpression itemExp = item.getOwnedItem();
                Object itemVal = itemExp.accept(this.undecoratedVisitor);
                if (uniqueResults != null && !uniqueResults.add(itemVal)) continue;
                orderedResults.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OCLExpression first = range.getOwnedFirst();
            OCLExpression last = range.getOwnedLast();
            Object firstVal = first.accept(this.undecoratedVisitor);
            Object lastVal = last.accept(this.undecoratedVisitor);
            IntegerValue firstInteger = ValueUtil.asIntegerValue(firstVal);
            IntegerValue lastInteger = ValueUtil.asIntegerValue(lastVal);
            Integer firstInt = firstInteger.asInteger();
            Integer lastInt = lastInteger.asInteger();
            if (firstInt > lastInt) continue;
            int i = firstInt;
            while (true) {
                IntegerValue integerValue = ValueUtil.integerValueOf(i);
                if (uniqueResults == null || uniqueResults.add(integerValue)) {
                    orderedResults.add(integerValue);
                }
                if (i >= lastInt) continue block0;
                ++i;
            }
        }
        return this.getIdResolver().createCollectionOfAll(type.isOrdered(), type.isUnique(), ClassUtil.nonNullModel(type.getElementType()).getTypeId(), orderedResults);
    }

    @Override
    public Object visitCollectionRange(@NonNull CollectionRange range) {
        throw new UnsupportedOperationException("evaluation of CollectionRange");
    }

    @Override
    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp el) {
        EnumerationLiteral enumLiteral = el.getReferredLiteral();
        assert (enumLiteral != null);
        return enumLiteral.getEnumerationLiteralId();
    }

    @Override
    public Object visitExpressionInOCL(@NonNull ExpressionInOCL expression) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Object result = this.safeVisit(expression.getOwnedBody());
        return result;
    }

    @Override
    public Object visitIfExp(@NonNull IfExp ifExp) {
        OCLExpression condition = ifExp.getOwnedCondition();
        Object acceptedValue = condition.accept(this.undecoratedVisitor);
        Boolean evaluatedCondition = ValueUtil.asBoolean(acceptedValue);
        OCLExpression expression = null;
        expression = evaluatedCondition == ValueUtil.TRUE_VALUE ? ifExp.getOwnedThen() : ifExp.getOwnedElse();
        return expression.accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp integerLiteralExp) {
        Number integerSymbol = integerLiteralExp.getIntegerSymbol();
        return integerSymbol != null ? ValueUtil.integerValueOf(integerSymbol) : null;
    }

    @Override
    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp invalidLiteralExp) {
        throw ValueUtil.INVALID_VALUE;
    }

    @Override
    public Object visitIterateExp(@NonNull IterateExp iterateExp) {
        if (this.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Iteration staticIteration = ClassUtil.nonNullModel(iterateExp.getReferredIteration());
        OCLExpression source = iterateExp.getOwnedSource();
        Object acceptedValue = source.accept(this.undecoratedVisitor);
        CollectionValue sourceValue = ValueUtil.asCollectionValue(acceptedValue);
        if (iterateExp.isIsSafe()) {
            sourceValue = sourceValue.excluding(null);
        }
        Class dynamicSourceType = this.environmentFactory.getIdResolver().getClass(sourceValue.getTypeId(), null);
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation(this.standardLibrary, staticIteration);
        Object result = null;
        try {
            AbstractEvaluatorIterationManager iterationManager;
            Variable accumulator = iterateExp.getOwnedResult();
            Object initValue = accumulator.getOwnedInit().accept(this.undecoratedVisitor);
            Variable accumulatorVariable = accumulator;
            OCLExpression body = ClassUtil.nonNullModel(iterateExp.getOwnedBody());
            List<Variable> iterators = iterateExp.getOwnedIterators();
            int iSize = iterators.size();
            if (iSize == 1) {
                VariableDeclaration firstIterator = ClassUtil.nonNullModel(iterators.get(0));
                iterationManager = new EvaluatorSingleIterationManager(this.undecoratedVisitor, body, sourceValue, accumulatorVariable, initValue, firstIterator);
            } else {
                TypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = iterators.get(i);
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager(this.undecoratedVisitor, body, sourceValue, accumulatorVariable, initValue, variables);
            }
            result = implementation.evaluateIteration(iterationManager);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, StringUtil.bind(PivotMessagesInternal.FailedToEvaluate_ERROR_, staticIteration, sourceValue, iterateExp));
        }
        return result;
    }

    @Override
    public Object visitIteratorExp(@NonNull IteratorExp iteratorExp) {
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        Iteration staticIteration = ClassUtil.nonNullModel(iteratorExp.getReferredIteration());
        OCLExpression source = iteratorExp.getOwnedSource();
        Object sourceVal = source.accept(this.undecoratedVisitor);
        CollectionValue sourceValue = ValueUtil.asCollectionValue(sourceVal);
        if (iteratorExp.isIsSafe()) {
            sourceValue = sourceValue.excluding(null);
        }
        Class dynamicSourceType = this.environmentFactory.getIdResolver().getClass(sourceValue.getTypeId(), null);
        LibraryIteration implementation = (LibraryIteration)dynamicSourceType.lookupImplementation(this.standardLibrary, staticIteration);
        Object result = null;
        try {
            AbstractEvaluatorIterationManager iterationManager;
            OCLExpression body = iteratorExp.getOwnedBody();
            Type iterationType = PivotUtilInternal.getType(ClassUtil.nonNullModel(iteratorExp.getType()));
            Type bodyType = PivotUtilInternal.getType(ClassUtil.nonNullModel(body.getType()));
            Object accumulatorValue = implementation.createAccumulatorValue(this.undecoratedVisitor, iterationType.getTypeId(), bodyType.getTypeId());
            List<Variable> iterators = iteratorExp.getOwnedIterators();
            int iSize = iterators.size();
            if (iSize == 1) {
                VariableDeclaration firstIterator = ClassUtil.nonNullModel(iterators.get(0));
                iterationManager = new EvaluatorSingleIterationManager(this.undecoratedVisitor, body, sourceValue, null, accumulatorValue, firstIterator);
            } else {
                TypedElement[] variables = new VariableDeclaration[iSize];
                int i = 0;
                while (i < iSize) {
                    variables[i] = iterators.get(i);
                    ++i;
                }
                iterationManager = new EvaluatorMultipleIterationManager(this.undecoratedVisitor, body, sourceValue, null, accumulatorValue, variables);
            }
            result = implementation.evaluateIteration(iterationManager);
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, staticIteration, sourceValue, iteratorExp);
        }
        return result;
    }

    @Override
    public Object visitLetExp(@NonNull LetExp letExp) {
        Object value;
        OCLExpression expression = letExp.getOwnedIn();
        Variable variable = letExp.getOwnedVariable();
        assert (variable != null);
        try {
            value = variable.accept(this.undecoratedVisitor);
        }
        catch (EvaluationHaltedException e) {
            throw e;
        }
        catch (InvalidValueException e) {
            value = e;
        }
        EvaluationVisitor nestedVisitor = this.undecoratedVisitor.createNestedEvaluator();
        nestedVisitor.getEvaluationEnvironment().add(variable, value);
        try {
            Object object = expression.accept(nestedVisitor);
            return object;
        }
        finally {
            nestedVisitor.dispose();
        }
    }

    @Override
    public Object visitMapLiteralExp(@NonNull MapLiteralExp mapLiteralExp) {
        List<MapLiteralPart> parts = mapLiteralExp.getOwnedParts();
        MapType type = (MapType)mapLiteralExp.getType();
        HashMap<Object, Object> mapEntries = new HashMap<Object, Object>();
        for (MapLiteralPart part : parts) {
            OCLExpression key = part.getOwnedKey();
            OCLExpression value = part.getOwnedValue();
            Object keyVal = key.accept(this.undecoratedVisitor);
            Object valueVal = value.accept(this.undecoratedVisitor);
            mapEntries.put(keyVal, valueVal);
        }
        return this.getIdResolver().createMapOfAll(ClassUtil.nonNullModel(type.getKeyType()).getTypeId(), ClassUtil.nonNullModel(type.getValueType()).getTypeId(), mapEntries);
    }

    @Override
    public Object visitMessageExp(@NonNull MessageExp m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    @Override
    public Object visitNullLiteralExp(@NonNull NullLiteralExp nullLiteralExp) {
        return null;
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp operationCallExp) {
        Operation actualOperation;
        Object sourceValue;
        if (this.monitor != null && this.monitor.isCanceled()) {
            throw new EvaluationHaltedException("Canceled");
        }
        EvaluationVisitor evaluator = this.undecoratedVisitor.getEvaluator();
        Operation apparentOperation = operationCallExp.getReferredOperation();
        assert (apparentOperation != null);
        OCLExpression source = operationCallExp.getOwnedSource();
        boolean isValidating = apparentOperation.isIsValidating();
        if (isValidating) {
            try {
                sourceValue = source.accept(this.undecoratedVisitor);
            }
            catch (EvaluationHaltedException e) {
                throw e;
            }
            catch (InvalidValueException e) {
                sourceValue = e;
            }
        } else {
            sourceValue = source.accept(this.undecoratedVisitor);
        }
        if (operationCallExp.isIsSafe() && sourceValue == null) {
            return null;
        }
        List<Parameter> ownedParameters = apparentOperation.getOwnedParameters();
        if (ownedParameters.size() == 1 && ownedParameters.get(0).getType() instanceof SelfType) {
            Operation actualOperation2;
            List<OCLExpression> arguments = operationCallExp.getOwnedArguments();
            Object onlyArgument = arguments.get(0).accept(this.undecoratedVisitor);
            if (apparentOperation.isIsStatic()) {
                actualOperation2 = apparentOperation;
            } else {
                IdResolver idResolver = this.environmentFactory.getIdResolver();
                Class actualSourceType = idResolver.getStaticTypeOf(sourceValue);
                if (onlyArgument != null) {
                    Class actualArgType = idResolver.getStaticTypeOf(onlyArgument);
                    actualSourceType = (Class)actualSourceType.getCommonType(idResolver, actualArgType);
                }
                actualOperation2 = actualSourceType.lookupActualOperation(this.standardLibrary, apparentOperation);
            }
            LibraryBinaryOperation implementation = (LibraryBinaryOperation)this.metamodelManager.getImplementation(actualOperation2);
            try {
                Object result = implementation.evaluate(evaluator, operationCallExp.getTypeId(), sourceValue, onlyArgument);
                assert (!(result instanceof NullValue));
                return result;
            }
            catch (InvalidValueException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, apparentOperation, sourceValue, operationCallExp);
            }
        }
        if (apparentOperation.isIsStatic()) {
            actualOperation = apparentOperation;
        } else {
            IdResolver idResolver = this.environmentFactory.getIdResolver();
            Class actualSourceType = idResolver.getStaticTypeOf(sourceValue);
            actualOperation = actualSourceType.lookupActualOperation(this.standardLibrary, apparentOperation);
        }
        LibraryOperation implementation = (LibraryOperation)this.metamodelManager.getImplementation(actualOperation);
        try {
            Object result = implementation.dispatch(evaluator, operationCallExp, sourceValue);
            assert (!(result instanceof NullValue));
            return result;
        }
        catch (InvalidValueException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidValueException(e, PivotMessagesInternal.FailedToEvaluate_ERROR_, apparentOperation, ILabelGenerator.Registry.INSTANCE.labelFor(sourceValue), operationCallExp);
        }
    }

    @Override
    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp oppositePropertyCallExp) {
        Property oppositeReferredProperty = oppositePropertyCallExp.getReferredProperty();
        Property referredProperty = oppositeReferredProperty.getOpposite();
        assert (referredProperty != null);
        return this.evaluatePropertyCallExp(oppositePropertyCallExp, referredProperty);
    }

    @Override
    public Object visitPropertyCallExp(@NonNull PropertyCallExp propertyCallExp) {
        Property referredProperty = propertyCallExp.getReferredProperty();
        assert (referredProperty != null);
        return this.evaluatePropertyCallExp(propertyCallExp, referredProperty);
    }

    @Override
    public Object visitRealLiteralExp(@NonNull RealLiteralExp realLiteralExp) {
        Number realSymbol = realLiteralExp.getRealSymbol();
        return realSymbol != null ? ValueUtil.realValueOf(realSymbol) : null;
    }

    @Override
    public Object visitShadowExp(@NonNull ShadowExp ce) {
        Object object;
        Class type = ce.getType();
        String value = ce.getValue();
        if (value == null) {
            EObject eObject = type.createInstance();
            for (ShadowPart part : ce.getOwnedParts()) {
                OCLExpression initExpression = part.getOwnedInit();
                if (initExpression == null) continue;
                Object boxedValue = this.undecoratedVisitor.evaluate(initExpression);
                Property referredProperty = part.getReferredProperty();
                java.lang.Class<?> instanceClass = PivotUtil.getEcoreInstanceClass(referredProperty);
                Object ecoreValue = this.getIdResolver().ecoreValueOf(instanceClass, boxedValue);
                referredProperty.initValue(eObject, ecoreValue);
            }
            object = eObject;
        } else {
            object = type.createInstance(value);
        }
        return object != null ? ValueUtil.createObjectValue(type.getTypeId(), object) : null;
    }

    @Override
    public Object visitStateExp(@NonNull StateExp s) {
        return s.getReferredState();
    }

    @Override
    public Object visitStringLiteralExp(@NonNull StringLiteralExp stringLiteralExp) {
        String value = stringLiteralExp.getStringSymbol();
        if (value == null) {
            throw new InvalidValueException("Invalid String Value", stringLiteralExp);
        }
        return value;
    }

    @Override
    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp tl) {
        Type type = ClassUtil.nonNullModel(tl.getType());
        HashMap<TuplePartId, Object> propertyValues = new HashMap<TuplePartId, Object>();
        for (TupleLiteralPart part : tl.getOwnedParts()) {
            propertyValues.put(part.getPartId(), part.accept(this.undecoratedVisitor));
        }
        return ValueUtil.createTupleValue(((TupleType)type).getTupleTypeId(), propertyValues);
    }

    @Override
    public Object visitTupleLiteralPart(@NonNull TupleLiteralPart tp) {
        return tp.getOwnedInit().accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitTypeExp(@NonNull TypeExp t) {
        return t.getReferredType();
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp unlimitedNaturalLiteralExp) {
        Number unlimitedNaturalSymbol = unlimitedNaturalLiteralExp.getUnlimitedNaturalSymbol();
        if (unlimitedNaturalSymbol == null) {
            return null;
        }
        if (unlimitedNaturalSymbol instanceof Unlimited) {
            return ValueUtil.UNLIMITED_VALUE;
        }
        if (unlimitedNaturalSymbol instanceof UnlimitedNaturalValue) {
            return unlimitedNaturalSymbol;
        }
        IntegerValue integerValue = ValueUtil.integerValueOf(unlimitedNaturalSymbol);
        if (integerValue.signum() < 0 && integerValue == ValueUtil.integerValueOf(-1)) {
            return ValueUtil.UNLIMITED_VALUE;
        }
        return integerValue.asUnlimitedNaturalValue();
    }

    @Override
    public Object visitUnspecifiedValueExp(@NonNull UnspecifiedValueExp uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    @Override
    public Object visitVariable(@NonNull Variable variable) {
        OCLExpression initExp = variable.getOwnedInit();
        if (initExp == null) {
            throw new InvalidValueException("Uninitialized variable", variable);
        }
        return initExp.accept(this.undecoratedVisitor);
    }

    @Override
    public Object visitVariableExp(@NonNull VariableExp variableExp) {
        VariableDeclaration variableDeclaration = variableExp.getReferredVariable();
        if (variableDeclaration == null) {
            throw new InvalidValueException("Undefined variable", null, null, variableExp);
        }
        Object value = this.evaluationEnvironment.getValueOf(variableDeclaration);
        if (value instanceof InvalidValueException) {
            throw (InvalidValueException)value;
        }
        return value;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }
}

