/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.SpecializedId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTemplateableIdImpl;

public abstract class AbstractSpecializedIdImpl<T extends TemplateableId>
extends AbstractTemplateableIdImpl<T>
implements SpecializedId {
    @NonNull
    protected final T generalizedId;
    @NonNull
    protected final BindingsId templateBindings;

    public AbstractSpecializedIdImpl(@NonNull T generalizedId, @NonNull BindingsId templateBindings) {
        super(generalizedId.hashCode() + templateBindings.hashCode(), generalizedId.getTemplateParameters());
        int generalizedTemplateParameters;
        this.generalizedId = generalizedId;
        this.templateBindings = templateBindings;
        int templateParameterCount = generalizedTemplateParameters = generalizedId.getTemplateParameters();
        assert (templateParameterCount > 0);
        assert (templateBindings.size() == templateParameterCount);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.generalizedId.getDisplayName());
        s.append("<");
        int i = 0;
        while (i < this.templateParameters) {
            if (i > 0) {
                s.append(",");
            }
            s.append("$" + i + ":");
            s.append(this.templateBindings.get(i));
            ++i;
        }
        s.append(">");
        String string2 = s.toString();
        assert (string2 != null);
        return string2;
    }

    @NonNull
    public T getGeneralizedId() {
        return this.generalizedId;
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return this.generalizedId.getMetaTypeName();
    }

    @Override
    @NonNull
    public String getName() {
        return this.generalizedId.getName();
    }

    @Override
    @NonNull
    public BindingsId getTemplateBindings() {
        return this.templateBindings;
    }
}

