/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractTypeId;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference3;

public class GeneralizedTupleTypeIdImpl
extends AbstractTypeId
implements TupleTypeId,
WeakHashMapOfListOfWeakReference3.MatchableId<String, TuplePartId[]> {
    @NonNull
    protected final Integer hashCode;
    @NonNull
    protected final String name;
    @NonNull
    protected final TuplePartId[] partIds;

    public GeneralizedTupleTypeIdImpl(@NonNull IdManager idManager, @NonNull Integer hashCode, @NonNull String name, @NonNull TuplePartId[] orderedPartIds) {
        this.hashCode = hashCode;
        this.name = name;
        this.partIds = orderedPartIds;
        assert (this.partsAreOrdered());
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTupleTypeId(this);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append("{");
        boolean isFirst = true;
        TuplePartId[] tuplePartIdArray = this.partIds;
        int n = this.partIds.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            if (!isFirst) {
                s.append(", ");
            }
            s.append(partId.getDisplayName());
            isFirst = false;
            ++n2;
        }
        s.append("}");
        String string2 = s.toString();
        assert (string2 != null);
        return string2;
    }

    @NonNull
    public TupleTypeId getGeneralizedId() {
        return this;
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return "TupleType";
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public TuplePartId getPartId(@NonNull String name) {
        TuplePartId[] tuplePartIdArray = this.partIds;
        int n = this.partIds.length;
        int n2 = 0;
        while (n2 < n) {
            TuplePartId partId = tuplePartIdArray[n2];
            if (name.equals(partId.getName())) {
                return partId;
            }
            ++n2;
        }
        return null;
    }

    @Override
    @NonNull
    public TuplePartId[] getPartIds() {
        return this.partIds;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean matches(@NonNull String thatName, @NonNull TuplePartId[] thoseOrderedParts) {
        int i = 0;
        while (i < this.partIds.length) {
            if (this.partIds[i] != thoseOrderedParts[i]) {
                return false;
            }
            ++i;
        }
        return this.name.equals(thatName);
    }

    private boolean partsAreOrdered() {
        int i = 0;
        while (i < this.partIds.length - 1) {
            TuplePartId earlierPartId = this.partIds[i];
            TuplePartId laterPartId = this.partIds[i + 1];
            if (earlierPartId.compareTo(laterPartId) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

