/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference4;

public class TuplePartIdImpl
implements TuplePartId,
WeakHashMapOfListOfWeakReference4.MatchableId<Integer, String, TypeId> {
    @NonNull
    protected final Integer hashCode;
    protected final int index;
    @NonNull
    protected final String name;
    @NonNull
    protected final TypeId typeId;

    public TuplePartIdImpl(@NonNull IdManager idManager, @NonNull Integer hashCode, int index, @NonNull String name, @NonNull TypeId typeId) {
        this.hashCode = hashCode;
        this.index = index;
        this.name = name;
        this.typeId = typeId;
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTuplePartId(this);
    }

    @Override
    public int compareTo(TuplePartId o) {
        String n1 = this.name;
        String n2 = o.getName();
        if (n1 == n2) {
            return 0;
        }
        return n1.compareTo(n2);
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return String.valueOf(String.valueOf(this.name)) + " : " + String.valueOf(this.typeId);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public TypeId getTypeId() {
        return this.typeId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean matches(@NonNull Integer thatIndex, @NonNull String thatName, @NonNull TypeId thatTypeid) {
        if (this.typeId != thatTypeid) {
            return false;
        }
        if (this.index != thatIndex) {
            return false;
        }
        return this.name.equals(thatName);
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.name)) + " : " + String.valueOf(this.typeId);
    }
}

