/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class EInvokeOperation
extends AbstractOperation {
    @NonNull
    protected final EOperation eOperation;

    public EInvokeOperation(@NonNull EOperation eOperation) {
        this.eOperation = eOperation;
        EClassifier eType = eOperation.getEType();
        if (eType == null) {
            throw new IllegalArgumentException("Non-query EOperation");
        }
    }

    @Override
    @Nullable
    public Object dispatch(@NonNull Evaluator evaluator, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        TypeId typeId = callExp.getTypeId();
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        if (arguments.size() == 0) {
            return this.evaluate(evaluator, typeId, sourceValue, new Object[0]);
        }
        OCLExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        Object firstArgument = evaluator.evaluate(argument0);
        if (arguments.size() == 1) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument);
        }
        OCLExpression argument1 = arguments.get(1);
        assert (argument1 != null);
        Object secondArgument = evaluator.evaluate(argument1);
        if (arguments.size() == 2) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument, secondArgument);
        }
        Object[] argumentValues = new Object[arguments.size()];
        argumentValues[0] = firstArgument;
        argumentValues[1] = secondArgument;
        int i = 2;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        return this.evaluate(evaluator, typeId, sourceValue, argumentValues);
    }

    @Nullable
    public Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, Object ... boxedArgumentValues) {
        EObject eObject = EInvokeOperation.asNavigableObject(sourceValue, this.eOperation, evaluator);
        EList<Object> ecoreArguments = evaluator.getIdResolver().ecoreValuesOfEach(null, boxedArgumentValues);
        try {
            Object eResult = eObject.eInvoke(this.eOperation, ecoreArguments);
            return this.getResultValue(evaluator, returnTypeId, eResult);
        }
        catch (InvocationTargetException e) {
            return EInvokeOperation.createInvalidValue(e);
        }
    }

    @Nullable
    protected Object getResultValue(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object eResult) {
        if (returnTypeId instanceof CollectionTypeId) {
            if (eResult instanceof Iterable) {
                return evaluator.getIdResolver().createCollectionOfAll((CollectionTypeId)returnTypeId, (Iterable)eResult);
            }
            throw new InvalidValueException("Non-iterable result", new Object[0]);
        }
        if (eResult != null) {
            EClassifier eType = this.eOperation.getEType();
            return evaluator.getIdResolver().boxedValueOf(eResult, eType);
        }
        return null;
    }
}

