/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class UnboxedOppositeNavigationProperty
extends AbstractProperty {
    @NonNull
    protected PropertyId oppositePropertyId;

    public UnboxedOppositeNavigationProperty(@NonNull PropertyId oppositePropertyId) {
        this.oppositePropertyId = oppositePropertyId;
    }

    @Override
    @Nullable
    public Object evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        IdResolver idResolver = evaluator.getIdResolver();
        Property oppositeProperty = idResolver.getProperty(this.oppositePropertyId);
        ModelManager modelManager = evaluator.getModelManager();
        Type thatType = ClassUtil.nonNullModel(oppositeProperty.getType());
        if (thatType instanceof CollectionType) {
            thatType = ((CollectionType)thatType).getElementType();
        }
        ArrayList<EObject> results = new ArrayList<EObject>();
        if (thatType instanceof Class) {
            for (EObject eObject : modelManager.get((Class)thatType)) {
                EClass eClass;
                EStructuralFeature eFeature;
                Object eGet = eObject.eGet(eFeature = (eClass = eObject.eClass()).getEStructuralFeature(oppositeProperty.getName()));
                if (eGet != sourceValue) continue;
                results.add(eObject);
            }
        }
        return results;
    }
}

