/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.ids.BuiltInTypeId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorFragment;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorType;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class EcoreExecutorType
extends ExecutorType {
    @Nullable
    protected EClassifier eClassifier;
    @Nullable
    private TypeId typeId = null;

    public EcoreExecutorType(@NonNull String name, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, evaluationPackage, flags, typeParameters);
        this.eClassifier = null;
    }

    public EcoreExecutorType(@NonNull BuiltInTypeId typeId, @NonNull ExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(typeId.getName(), evaluationPackage, flags, typeParameters);
        this.eClassifier = null;
        this.typeId = typeId;
    }

    public EcoreExecutorType(EClassifier eClassifier, @NonNull EcoreExecutorPackage evaluationPackage, int flags, ExecutorTypeParameter ... typeParameters) {
        super(ClassUtil.nonNullModel(eClassifier.getName()), evaluationPackage, flags, typeParameters);
        this.eClassifier = eClassifier;
    }

    @Override
    @NonNull
    public EObject createInstance() {
        EClassifier eClassifier2 = this.eClassifier;
        if (eClassifier2 instanceof EClass) {
            EClass eClass = (EClass)eClassifier2;
            EObject element = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return ClassUtil.nonNullEMF(element);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Object createInstance(@NonNull String value) {
        EClassifier eClassifier2 = this.eClassifier;
        if (eClassifier2 instanceof EDataType) {
            EDataType eDataType = (EDataType)eClassifier2;
            Object element = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
            return ClassUtil.nonNullEMF(element);
        }
        throw new UnsupportedOperationException();
    }

    public final EClassifier getEClassifier() {
        return this.eClassifier;
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        if (this.eClassifier != null) {
            return ClassUtil.nonNullModel(ClassUtil.nonNullState(this.eClassifier).getName());
        }
        return this.getTypeId().getMetaTypeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public TypeId getTypeId() {
        TypeId typeId2 = this.typeId;
        if (typeId2 == null) {
            EcoreExecutorType ecoreExecutorType = this;
            synchronized (ecoreExecutorType) {
                typeId2 = this.typeId;
                if (typeId2 == null) {
                    EClassifier eClassifier2 = this.eClassifier;
                    if (eClassifier2 != null) {
                        typeId2 = IdManager.getTypeId(eClassifier2);
                    } else {
                        PackageId packageTypeId = this.evaluationPackage.getPackageId();
                        TemplateParameters typeParameters = this.getTypeParameters();
                        typeId2 = this.eClassifier instanceof EDataType ? packageTypeId.getDataTypeId(this.name, typeParameters.parametersSize()) : packageTypeId.getClassId(this.name, typeParameters.parametersSize());
                    }
                    this.typeId = typeId2;
                }
            }
        }
        return typeId2;
    }

    @NonNull
    public EcoreExecutorType initFragments(@NonNull ExecutorFragment[] fragments, int[] depthCounts, EClassifier eClassifier) {
        assert (eClassifier != null);
        assert (this.eClassifier == null);
        assert (this.name.equals(eClassifier.getName()));
        this.eClassifier = ClassUtil.nonNullState(eClassifier);
        this.initFragments(fragments, depthCounts);
        return this;
    }
}

