/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreReflectiveEnumeration;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreReflectiveType;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorPackage;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class EcoreReflectivePackage
extends ExecutorPackage {
    @NonNull
    protected final IdResolver idResolver;
    protected final EPackage ePackage;
    @Nullable
    protected Map<EClassifier, Class> types = null;
    @Nullable
    protected Map<String, EcoreReflectivePackage> nestedPackages = null;

    public EcoreReflectivePackage(@NonNull EPackage ePackage, @NonNull IdResolver idResolver, @NonNull PackageId packageId) {
        super(ClassUtil.nonNullEMF(ePackage.getName()), ePackage.getNsPrefix(), ePackage.getNsURI(), packageId);
        this.idResolver = idResolver;
        this.ePackage = ePackage;
    }

    @NonNull
    protected synchronized Map<EClassifier, Class> computeClasses() {
        this.types = new HashMap<EClassifier, Class>();
        HashMap<EClassifier, Class> types2 = this.types;
        for (EClassifier eClassifier : this.ePackage.getEClassifiers()) {
            if (eClassifier == null) continue;
            EcoreReflectiveType executorType = eClassifier instanceof EEnum ? new EcoreReflectiveEnumeration(this, 0, (EEnum)eClassifier, new TemplateParameter[0]) : new EcoreReflectiveType(this, 0, eClassifier, new TemplateParameter[0]);
            types2.put(eClassifier, executorType);
        }
        return types2;
    }

    @NonNull
    public IdResolver getIdResolver() {
        return this.idResolver;
    }

    @Override
    @NonNull
    public List<Package> getOwnedPackages() {
        Map<String, EcoreReflectivePackage> nestedPackages2 = this.nestedPackages;
        if (nestedPackages2 == null) {
            this.nestedPackages = nestedPackages2 = new HashMap<String, EcoreReflectivePackage>();
            for (EPackage eSubPackage : this.ePackage.getESubpackages()) {
                if (eSubPackage == null) continue;
                PackageId subPackageId = IdManager.getPackageId(eSubPackage);
                EcoreReflectivePackage executorPackage = new EcoreReflectivePackage(eSubPackage, this.idResolver, subPackageId);
                nestedPackages2.put(eSubPackage.getName(), executorPackage);
            }
        }
        return new ArrayList<Package>(nestedPackages2.values());
    }

    @Override
    public Package getOwningPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<Class> getOwnedClasses() {
        Map<EClassifier, Class> types2 = this.types;
        if (types2 == null) {
            types2 = this.computeClasses();
        }
        ArrayList<Class> values2 = new ArrayList<Class>(types2.values());
        return values2;
    }

    @NonNull
    public StandardLibrary getStandardLibrary() {
        return this.idResolver.getStandardLibrary();
    }
}

