/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.LibraryFeature;
import org.eclipse.ocl.pivot.library.oclany.OclAnyUnsupportedOperation;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.utilities.IndexableIterable;

public abstract class ReflectiveFragment
extends AbstractFragment {
    protected Map<Operation, LibraryFeature> operationMap = null;
    protected Map<Operation, Operation> apparentOperation2actualOperation = null;
    protected Map<Property, LibraryFeature> propertyMap = null;

    public ReflectiveFragment(@NonNull CompleteInheritance derivedInheritance, @NonNull CompleteInheritance baseInheritance) {
        super(derivedInheritance, baseInheritance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public LibraryFeature getImplementation(@NonNull Operation apparentOperation) {
        LibraryFeature libraryFeature;
        if (this.operationMap == null) {
            ReflectiveFragment reflectiveFragment = this;
            synchronized (reflectiveFragment) {
                if (this.operationMap == null) {
                    this.operationMap = new HashMap<Operation, LibraryFeature>();
                }
            }
        }
        if ((libraryFeature = this.operationMap.get(apparentOperation)) != null) {
            return libraryFeature;
        }
        Map<Operation, LibraryFeature> map = this.operationMap;
        synchronized (map) {
            libraryFeature = this.operationMap.get(apparentOperation);
            if (libraryFeature != null) {
                return libraryFeature;
            }
            Operation localOperation = this.getLocalOperation(apparentOperation);
            if (localOperation == null && this.derivedInheritance == this.baseInheritance) {
                localOperation = apparentOperation;
            }
            if (localOperation != null) {
                libraryFeature = PivotUtilInternal.getImplementation(localOperation);
            } else {
                Operation bestOverload = null;
                CompleteInheritance bestInheritance = null;
                int bestDepth = -1;
                int minDepth = this.baseInheritance.getDepth();
                int depth = this.derivedInheritance.getDepth() - 1;
                while (depth >= minDepth) {
                    IndexableIterable<InheritanceFragment> derivedSuperFragments = this.derivedInheritance.getSuperFragments(depth);
                    for (InheritanceFragment derivedSuperFragment : derivedSuperFragments) {
                        Operation overload;
                        CompleteInheritance superInheritance = derivedSuperFragment.getBaseInheritance();
                        InheritanceFragment superFragment = superInheritance.getFragment(this.baseInheritance);
                        if (superFragment == null || (overload = superFragment.getLocalOperation(apparentOperation)) == null) continue;
                        if (bestInheritance == null) {
                            bestDepth = depth;
                            bestInheritance = superInheritance;
                            bestOverload = overload;
                            continue;
                        }
                        if (depth == bestDepth) {
                            bestOverload = null;
                            depth = -1;
                            break;
                        }
                        if (bestInheritance.isSubInheritanceOf(superInheritance)) continue;
                        bestOverload = null;
                        depth = -1;
                        break;
                    }
                    --depth;
                }
                libraryFeature = bestOverload != null ? PivotUtilInternal.getImplementation(bestOverload) : OclAnyUnsupportedOperation.AMBIGUOUS;
            }
            if (libraryFeature == null) {
                libraryFeature = OclAnyUnsupportedOperation.INSTANCE;
            }
            this.operationMap.put(apparentOperation, libraryFeature);
            return libraryFeature;
        }
    }

    @Override
    @NonNull
    public Iterable<? extends Operation> getLocalOperations() {
        return this.operationMap != null ? this.operationMap.keySet() : Collections.emptyList();
    }

    @Override
    @NonNull
    public Iterable<? extends Property> getLocalProperties() {
        return this.propertyMap != null ? this.propertyMap.keySet() : Collections.emptyList();
    }
}

