/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.elements.AbstractExecutorClass;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.types.AbstractInheritance;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class ReflectiveInheritance
extends AbstractExecutorClass {
    private InheritanceFragment[] fragments = null;
    private int[] indexes = null;
    private Set<ReflectiveInheritance> knownSubInheritances = null;

    protected static int computeFlags(@NonNull Class domainClass) {
        TypeId typeId;
        int flags = 0;
        if (domainClass instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)domainClass;
            if (collectionType.isOrdered()) {
                flags |= 1;
            }
            if (collectionType.isUnique()) {
                flags |= 2;
            }
        }
        if ((typeId = domainClass.getTypeId()) == TypeId.OCL_ANY) {
            flags |= 4;
        } else if (typeId == TypeId.OCL_VOID) {
            flags |= 8;
        } else if (typeId == TypeId.OCL_INVALID) {
            flags |= 0x10;
        }
        return flags;
    }

    public ReflectiveInheritance(@NonNull String name, int flags, ExecutorTypeParameter ... typeParameters) {
        super(name, flags);
    }

    public void addSubInheritance(@NonNull ReflectiveInheritance subInheritance) {
        if (this.knownSubInheritances == null) {
            this.knownSubInheritances = new HashSet<ReflectiveInheritance>();
        }
        this.knownSubInheritances.add(subInheritance);
    }

    protected abstract AbstractFragment createFragment(@NonNull CompleteInheritance var1);

    @Override
    @NonNull
    public EObject createInstance() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Object createInstance(@NonNull String value) {
        throw new UnsupportedOperationException();
    }

    public boolean gatherUninstalledInheritances(@NonNull List<ReflectiveInheritance> inheritances) {
        boolean gotOne = false;
        if (!inheritances.contains(this)) {
            inheritances.add(this);
            if (this.fragments == null) {
                for (CompleteInheritance completeInheritance : this.getInitialSuperInheritances()) {
                    if (completeInheritance instanceof ReflectiveInheritance) {
                        if (!((ReflectiveInheritance)completeInheritance).gatherUninstalledInheritances(inheritances)) continue;
                        gotOne = true;
                        continue;
                    }
                    gotOne = true;
                }
            } else {
                gotOne = true;
            }
        }
        return gotOne;
    }

    @NonNull
    public final AbstractInheritance.FragmentIterable getAllProperSuperFragments() {
        if (this.fragments == null) {
            this.initialize();
        }
        InheritanceFragment[] fragments2 = ClassUtil.nonNullState(this.fragments);
        return new AbstractInheritance.FragmentIterable(fragments2, 0, fragments2.length - 1);
    }

    @NonNull
    public final AbstractInheritance.FragmentIterable getAllSuperFragments() {
        if (this.fragments == null) {
            this.initialize();
        }
        return new AbstractInheritance.FragmentIterable(ClassUtil.nonNullState(this.fragments));
    }

    @Override
    public final int getDepth() {
        if (this.indexes == null) {
            this.initialize();
        }
        return this.indexes.length - 2;
    }

    @Override
    public InheritanceFragment getFragment(int fragmentNumber) {
        if (this.fragments == null && this.isOclAny()) {
            this.installOclAny();
        }
        return this.fragments[fragmentNumber];
    }

    @Override
    @NonNull
    public Iterable<InheritanceFragment> getFragments() {
        InheritanceFragment[] fragments2 = this.fragments;
        if (fragments2 == null) {
            this.initialize();
            fragments2 = this.fragments;
            assert (fragments2 != null);
        }
        return new AbstractInheritance.FragmentIterable(fragments2);
    }

    @Override
    public int getIndex(int fragmentNumber) {
        return this.indexes[fragmentNumber];
    }

    @Override
    public int getIndexes() {
        return this.indexes.length;
    }

    @NonNull
    protected abstract Iterable<? extends CompleteInheritance> getInitialSuperInheritances();

    @Override
    @NonNull
    public InheritanceFragment getSelfFragment() {
        InheritanceFragment fragment;
        if (this.indexes == null) {
            this.initialize();
        }
        if ((fragment = this.getFragment(this.fragments.length - 1)) == null) {
            throw new IllegalStateException("No self fragment");
        }
        return fragment;
    }

    @NonNull
    public final AbstractInheritance.FragmentIterable getSuperFragments(int depth) {
        return new AbstractInheritance.FragmentIterable(ClassUtil.nonNullState(this.fragments), this.indexes[depth], this.indexes[depth + 1]);
    }

    protected synchronized void initialize() {
        block3: {
            Boolean gotOne;
            ArrayList<ReflectiveInheritance> uninstalledInheritances = new ArrayList<ReflectiveInheritance>();
            this.gatherUninstalledInheritances(uninstalledInheritances);
            ArrayList<ReflectiveInheritance> debugOldUninstalledInheritances = new ArrayList<ReflectiveInheritance>(uninstalledInheritances);
            do {
                gotOne = false;
                ListIterator it = uninstalledInheritances.listIterator();
                while (it.hasNext()) {
                    ReflectiveInheritance uninstalledInheritance = (ReflectiveInheritance)it.next();
                    if (!uninstalledInheritance.isInstallable()) continue;
                    uninstalledInheritance.install();
                    it.remove();
                    gotOne = true;
                }
                if (uninstalledInheritances.isEmpty()) break block3;
            } while (gotOne.booleanValue());
            ArrayList<ReflectiveInheritance> debugNewUninstalledInheritances = new ArrayList<ReflectiveInheritance>();
            this.gatherUninstalledInheritances(debugNewUninstalledInheritances);
            StringBuilder s = new StringBuilder();
            s.append("Inheritance loop for ");
            ListIterator it = uninstalledInheritances.listIterator();
            while (it.hasNext()) {
                ReflectiveInheritance uninstalledInheritance = (ReflectiveInheritance)it.next();
                if (uninstalledInheritance.isInstallable()) continue;
                s.append("\n  ");
                s.append(uninstalledInheritance);
            }
            throw new IllegalStateException(s.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean install() {
        if (this.fragments != null) {
            return true;
        }
        if (this.isOclAny()) {
            this.installOclAny();
        } else {
            void var4_13;
            void var2_7;
            void var4_12;
            ArrayList all = new ArrayList();
            for (CompleteInheritance completeInheritance : this.getInitialSuperInheritances()) {
                int n = 0;
                int i = 0;
                while (i < completeInheritance.getIndexes() - 1) {
                    Object some;
                    Object object = some = i < all.size() ? (ArrayList<CompleteInheritance>)all.get(i) : null;
                    if (some == null) {
                        some = new ArrayList<CompleteInheritance>();
                        all.add(some);
                    }
                    int jMax = completeInheritance.getIndex(i + 1);
                    while (n < jMax) {
                        InheritanceFragment fragment = completeInheritance.getFragment(n);
                        CompleteInheritance baseInheritance = fragment.getBaseInheritance();
                        if (!some.contains(baseInheritance)) {
                            some.add(baseInheritance);
                            if (baseInheritance instanceof ReflectiveInheritance) {
                                ((ReflectiveInheritance)baseInheritance).addSubInheritance(this);
                            }
                        }
                        ++n;
                    }
                    ++i;
                }
            }
            int n = all.size();
            int superInheritances = 0;
            for (List list : all) {
                superInheritances += list.size();
            }
            assert (n > 0);
            this.fragments = new InheritanceFragment[superInheritances + 1];
            this.indexes = new int[n + 2];
            boolean bl = false;
            this.indexes[0] = 0;
            int i = 0;
            while (i < n) {
                for (Object some : (List)all.get(i)) {
                    if (some == null) continue;
                    this.fragments[++var4_12] = this.createFragment((CompleteInheritance)some);
                }
                this.indexes[i + 1] = var4_12;
                ++i;
            }
            this.indexes[n] = var4_12;
            this.fragments[var4_12] = this.createFragment(this);
            ++var2_7;
            this.indexes[++var2_6] = ++var4_13;
        }
        return true;
    }

    protected final void installOclAny() {
        assert (this.fragments == null);
        this.fragments = new InheritanceFragment[]{this.createFragment(this)};
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.indexes = nArray;
    }

    public boolean isInstallable() {
        if (this.isOclAny()) {
            return true;
        }
        if (this.fragments != null) {
            return true;
        }
        for (CompleteInheritance completeInheritance : this.getInitialSuperInheritances()) {
            if (!(completeInheritance instanceof ReflectiveInheritance) || ((ReflectiveInheritance)completeInheritance).isInstalled()) continue;
            return false;
        }
        return true;
    }

    public boolean isInstalled() {
        return this.fragments != null;
    }

    public void removeSubInheritance(@NonNull ReflectiveInheritance subInheritance) {
        if (this.knownSubInheritances != null) {
            this.knownSubInheritances.remove(subInheritance);
        }
    }

    public void uninstall() {
        if (this.fragments != null) {
            InheritanceFragment[] inheritanceFragmentArray = this.fragments;
            int n = this.fragments.length;
            int n2 = 0;
            while (n2 < n) {
                InheritanceFragment fragment = inheritanceFragmentArray[n2];
                CompleteInheritance baseInheritance = fragment.getBaseInheritance();
                if (baseInheritance instanceof ReflectiveInheritance) {
                    ((ReflectiveInheritance)baseInheritance).removeSubInheritance(this);
                }
                ++n2;
            }
            this.fragments = null;
            this.indexes = null;
            if (this.knownSubInheritances != null) {
                Set<ReflectiveInheritance> previouslyKnownSubInheritances = this.knownSubInheritances;
                this.knownSubInheritances = null;
                for (ReflectiveInheritance subInheritance : previouslyKnownSubInheritances) {
                    subInheritance.uninstall();
                }
            }
        }
    }
}

