/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.library.LibraryFeature;

public class FinalAnalysis {
    @NonNull
    protected final CompleteModelInternal completeModel;
    @NonNull
    protected final PivotMetamodelManager metamodelManager;
    @NonNull
    private final Map<CompleteClass, Set<CompleteClass>> superCompleteClass2subCompleteClasses = new HashMap<CompleteClass, Set<CompleteClass>>();
    @NonNull
    private final Map<Operation, Set<Operation>> operation2overrides = new HashMap<Operation, Set<Operation>>();

    public FinalAnalysis(@NonNull CompleteModelInternal completeModel) {
        this.completeModel = completeModel;
        this.metamodelManager = completeModel.getMetamodelManager();
        for (CompletePackage completePackage : completeModel.getAllCompletePackages()) {
            for (CompleteClass subCompleteClass : completePackage.getOwnedCompleteClasses()) {
                for (CompleteClass superCompleteClass : subCompleteClass.getSuperCompleteClasses()) {
                    Set<CompleteClass> subCompleteClasses = this.superCompleteClass2subCompleteClasses.get(superCompleteClass);
                    if (subCompleteClasses == null) {
                        subCompleteClasses = new HashSet<CompleteClass>();
                        this.superCompleteClass2subCompleteClasses.put(superCompleteClass, subCompleteClasses);
                    }
                    subCompleteClasses.add(subCompleteClass);
                }
            }
        }
        for (CompleteClass completeClass : this.superCompleteClass2subCompleteClasses.keySet()) {
            Set<CompleteClass> subCompleteClasses = this.superCompleteClass2subCompleteClasses.get(completeClass);
            for (Operation domainOperation : completeClass.getOperations(null)) {
                String opName = domainOperation.getName();
                ParametersId parametersId = domainOperation.getParametersId();
                LibraryFeature domainImplementation = this.metamodelManager.getImplementation(domainOperation);
                HashSet<Operation> overrides = null;
                for (CompleteClass subCompleteClass : subCompleteClasses) {
                    if (subCompleteClass == completeClass) continue;
                    for (Operation subOperation : subCompleteClass.getOperations(null)) {
                        LibraryFeature subImplementation;
                        if (!opName.equals(subOperation.getName()) || !parametersId.equals(subOperation.getParametersId()) || domainImplementation == (subImplementation = this.metamodelManager.getImplementation(subOperation))) continue;
                        if (overrides == null) {
                            overrides = new HashSet<Operation>();
                            overrides.add(domainOperation);
                        }
                        overrides.add(subOperation);
                    }
                }
                this.operation2overrides.put(domainOperation, overrides);
            }
        }
    }

    public boolean isFinal(@NonNull CompleteClass completeClass) {
        Set<CompleteClass> subCompleteClasses = this.superCompleteClass2subCompleteClasses.get(completeClass);
        return subCompleteClasses.size() <= 1;
    }

    public boolean isFinal(@NonNull Operation operation) {
        Set<Operation> overrides = this.operation2overrides.get(operation);
        return overrides == null;
    }

    @Nullable
    public Operation isFinal(@NonNull Operation operation, @NonNull CompleteClass completeClass) {
        Set<Operation> overrides = this.operation2overrides.get(operation);
        if (overrides == null) {
            return operation;
        }
        Operation candidate = null;
        StandardLibraryInternal standardLibrary = this.completeModel.getStandardLibrary();
        for (Operation override : overrides) {
            CompleteInheritance overrideInheritance = override.getInheritance(standardLibrary);
            if (overrideInheritance == null || !overrideInheritance.getPivotClass().conformsTo(standardLibrary, completeClass.getPrimaryClass())) continue;
            if (candidate != null) {
                return null;
            }
            candidate = override;
        }
        return candidate;
    }

    public void print(@NonNull StringBuilder s) {
        ArrayList<CompleteClass> completeClasses = new ArrayList<CompleteClass>(this.superCompleteClass2subCompleteClasses.keySet());
        Collections.sort(completeClasses, new Comparator<CompleteClass>(){

            @Override
            public int compare(CompleteClass o1, CompleteClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        s.append("Final types");
        for (CompleteClass completeClass : completeClasses) {
            assert (completeClass != null);
            if (!this.isFinal(completeClass)) continue;
            s.append("\n\t");
            s.append(completeClass.getName());
        }
        s.append("\nNon-final types");
        for (CompleteClass completeClass : completeClasses) {
            assert (completeClass != null);
            if (this.isFinal(completeClass)) continue;
            s.append("\n\t");
            s.append(completeClass.getName());
        }
    }
}

