/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.plugin;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryContribution;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.util.PivotPlugin;

public class ASResourceFactoryRegistryReader
extends RegistryReader {
    @NonNull
    static final String TAG_FACTORY = "factory";
    @NonNull
    static final String ATT_CONTENT_TYPE = "contentType";
    @NonNull
    static final String ATT_EXTENSION = "extension";
    @NonNull
    static final String ATT_PRIORITY = "priority";
    @NonNull
    static final String ATT_RESOURCE_CLASS = "resourceClass";
    @NonNull
    static final String ATT_CLASS = "class";

    public ASResourceFactoryRegistryReader() {
        super(Platform.getExtensionRegistry(), PivotPlugin.getPlugin().getBundle().getSymbolicName(), "as_resource_factory");
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            Integer priority;
            String contentType = element.getAttribute(ATT_CONTENT_TYPE);
            String extension = element.getAttribute(ATT_EXTENSION);
            String resourceClass = element.getAttribute(ATT_RESOURCE_CLASS);
            String priorityString = element.getAttribute(ATT_PRIORITY);
            Integer n = priority = priorityString != null ? Integer.valueOf(Integer.parseInt(priorityString)) : null;
            if (contentType == null) {
                this.logMissingAttribute(element, ATT_CONTENT_TYPE);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    ASResourceFactoryContribution.Descriptor newDescriptor = new ASResourceFactoryContribution.Descriptor(element, priority, ATT_CLASS);
                    Object previous = ASResourceFactoryRegistry.INSTANCE.addASResourceFactory(contentType, extension, resourceClass, newDescriptor);
                    if (previous instanceof ASResourceFactoryContribution.Descriptor) {
                        ASResourceFactoryContribution.Descriptor descriptor = (ASResourceFactoryContribution.Descriptor)previous;
                        EcorePlugin.INSTANCE.log((Object)("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an ASResourceFactory for '" + contentType + "'"));
                    }
                    return true;
                }
                ASResourceFactoryRegistry.INSTANCE.remove(contentType, extension, resourceClass);
                return true;
            }
        }
        return false;
    }
}

