/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.plugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.plugin.RegistryReader;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.util.PivotPlugin;

public class LabelGeneratorRegistryReader
extends RegistryReader {
    @NonNull
    static final String TAG_GENERATOR = "generator";
    @NonNull
    static final String ATT_FOR = "for";
    @NonNull
    static final String ATT_CLASS = "class";
    @NonNull
    protected final ILabelGenerator.Registry registry;

    public LabelGeneratorRegistryReader(@NonNull ILabelGenerator.Registry registry) {
        super(Platform.getExtensionRegistry(), PivotPlugin.getPlugin().getBundle().getSymbolicName(), "label_generator");
        this.registry = registry;
    }

    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_GENERATOR)) {
            String helpedClass = element.getAttribute(ATT_FOR);
            if (helpedClass == null) {
                this.logMissingAttribute(element, ATT_FOR);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                Class<?> loadedClass = null;
                try {
                    try {
                        Object createExecutableExtension = element.createExecutableExtension(ATT_CLASS);
                        loadedClass = createExecutableExtension.getClass().getClassLoader().loadClass(helpedClass);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                catch (ClassNotFoundException e) {
                    PivotPlugin.logError("Failed to load '" + helpedClass + "'", e);
                    return false;
                }
                if (loadedClass != null) {
                    if (add) {
                        Object previous = this.registry.install(loadedClass, new LabelGeneratorDescriptor(element, ATT_CLASS));
                        if (previous instanceof LabelGeneratorDescriptor) {
                            LabelGeneratorDescriptor descriptor = (LabelGeneratorDescriptor)previous;
                            PivotPlugin.INSTANCE.log("Both '" + descriptor.getElement().getContributor().getName() + "' and '" + element.getContributor().getName() + "' register an invocation delegate factory for '" + helpedClass + "'");
                        }
                        return true;
                    }
                    ILabelGenerator.Registry.INSTANCE.uninstall(loadedClass);
                    return true;
                }
            }
        }
        return false;
    }

    static class LabelGeneratorDescriptor
    extends RegistryReader.PluginClassDescriptor
    implements ILabelGenerator.Descriptor {
        @Nullable
        protected ILabelGenerator<?> labelGenerator;

        public LabelGeneratorDescriptor(@NonNull IConfigurationElement e, @NonNull String attrName) {
            super(e, attrName);
        }

        @Override
        @NonNull
        public ILabelGenerator<?> getLabelGenerator() {
            ILabelGenerator labelGenerator2 = this.labelGenerator;
            if (labelGenerator2 == null) {
                labelGenerator2 = this.labelGenerator = (ILabelGenerator)this.createInstance();
                assert (labelGenerator2 != null);
            }
            return labelGenerator2;
        }

        @NonNull
        public IConfigurationElement getElement() {
            assert (this.element != null);
            return this.element;
        }
    }
}

