/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.prettyprint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public abstract class PrettyPrintOptions {
    @Nullable
    protected final Namespace scope;

    public PrettyPrintOptions(@Nullable Namespace scope) {
        this.scope = scope;
    }

    public abstract void addReservedNames(@NonNull Iterable<String> var1);

    public abstract void addRestrictedNames(@NonNull Iterable<String> var1);

    @Nullable
    public String getAlias(@NonNull Namespace namespace) {
        return this.getGlobalOptions().getAlias(namespace);
    }

    @Nullable
    public URI getBaseURI() {
        return this.getGlobalOptions().getBaseURI();
    }

    @Nullable
    public EnvironmentFactory getEnvironmentFactory() {
        return this.getGlobalOptions().getEnvironmentFactory();
    }

    @NonNull
    public abstract Global getGlobalOptions();

    @NonNull
    public String getIndentStep() {
        return this.getGlobalOptions().getIndentStep();
    }

    public int getLinelength() {
        return this.getGlobalOptions().getLinelength();
    }

    @Nullable
    public abstract Set<String> getReservedNames();

    @Nullable
    public abstract Set<String> getRestrictedNames();

    @Nullable
    public Namespace getScope() {
        return this.scope;
    }

    public void setIndentStep(@NonNull String indentStep) {
        this.getGlobalOptions().setIndentStep(indentStep);
    }

    public void setLinelength(int linelength) {
        this.getGlobalOptions().setLinelength(linelength);
    }

    public static class Global
    extends PrettyPrintOptions {
        @NonNull
        private String indentStep = "  ";
        private int linelength = Integer.MAX_VALUE;
        @NonNull
        private final Set<String> reservedNames = new HashSet<String>();
        @NonNull
        private final Set<String> restrictedNames = new HashSet<String>();
        @NonNull
        private Map<Namespace, String> namespace2alias = new HashMap<Namespace, String>();
        @Nullable
        private URI baseURI = null;
        @Nullable
        private EnvironmentFactory environmentFactory = null;

        public Global(@Nullable Namespace scope) {
            super(scope);
        }

        public void addAliases(@NonNull Namespace namespace, @NonNull String alias) {
            this.namespace2alias.put(namespace, alias);
        }

        @Override
        public void addReservedNames(@NonNull Iterable<String> names) {
            for (String name : names) {
                this.reservedNames.add(name);
                this.restrictedNames.add(name);
            }
        }

        @Override
        public void addRestrictedNames(@NonNull Iterable<String> names) {
            for (String name : names) {
                this.restrictedNames.add(name);
            }
        }

        @Override
        @Nullable
        public String getAlias(@NonNull Namespace namespace) {
            return this.namespace2alias.get(namespace);
        }

        @Override
        @Nullable
        public URI getBaseURI() {
            return this.baseURI;
        }

        @Override
        @Nullable
        public EnvironmentFactory getEnvironmentFactory() {
            return this.environmentFactory;
        }

        @Override
        @NonNull
        public Global getGlobalOptions() {
            return this;
        }

        @Override
        @NonNull
        public String getIndentStep() {
            return this.indentStep;
        }

        @Override
        public int getLinelength() {
            return this.linelength;
        }

        @NonNull
        public Set<Namespace> getAliasedNamespaces() {
            Set<Namespace> result = this.namespace2alias.keySet();
            return result;
        }

        @Override
        @Nullable
        public Set<String> getReservedNames() {
            return this.reservedNames;
        }

        @Override
        @Nullable
        public Set<String> getRestrictedNames() {
            return this.restrictedNames;
        }

        public void setAliases(@NonNull Map<Namespace, String> namespace2alias) {
            this.namespace2alias = namespace2alias;
        }

        public void setBaseURI(@Nullable URI baseURI) {
            this.baseURI = baseURI;
        }

        public void setEnvironmentFactory(EnvironmentFactory environmentFactory) {
            this.environmentFactory = environmentFactory;
        }

        @Override
        public void setIndentStep(@NonNull String indentStep) {
            this.indentStep = indentStep;
        }

        @Override
        public void setLinelength(int linelength) {
            this.linelength = linelength;
        }
    }

    public static class Local
    extends PrettyPrintOptions {
        @NonNull
        private PrettyPrintOptions options;
        @Nullable
        private Set<String> reservedNames = null;
        @Nullable
        private Set<String> restrictedNames = null;

        public Local(@NonNull PrettyPrintOptions options, @Nullable Namespace scope) {
            super(scope);
            this.options = options;
        }

        @Override
        public void addReservedNames(@NonNull Iterable<String> names) {
            Set<String> reservedNames2 = this.reservedNames;
            Set<String> restrictedNames2 = this.restrictedNames;
            if (reservedNames2 == null) {
                reservedNames2 = this.reservedNames = new HashSet<String>();
            }
            if (restrictedNames2 == null) {
                restrictedNames2 = this.restrictedNames = new HashSet<String>();
            }
            for (String name : names) {
                reservedNames2.add(name);
                restrictedNames2.add(name);
            }
        }

        @Override
        public void addRestrictedNames(@NonNull Iterable<String> names) {
            Set<String> reservedNames2 = this.reservedNames;
            Set<String> restrictedNames2 = this.restrictedNames;
            if (reservedNames2 == null) {
                reservedNames2 = this.reservedNames = new HashSet<String>();
            }
            if (restrictedNames2 == null) {
                restrictedNames2 = this.restrictedNames = new HashSet<String>();
            }
            for (String name : names) {
                restrictedNames2.add(name);
            }
        }

        @Override
        @NonNull
        public Global getGlobalOptions() {
            return this.options.getGlobalOptions();
        }

        @Override
        public Set<String> getReservedNames() {
            return this.reservedNames != null ? this.reservedNames : this.options.getReservedNames();
        }

        @Override
        public Set<String> getRestrictedNames() {
            return this.restrictedNames != null ? this.restrictedNames : this.options.getRestrictedNames();
        }
    }
}

