/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.prettyprint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintOptions;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintVisitor;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.utilities.PathElement;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.util.AbstractVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public class PrettyPrinter {
    @NonNull
    public static final String NULL_PLACEHOLDER = "<null>";
    @NonNull
    public static List<String> reservedNameList = Arrays.asList("and", "else", "endif", "false", "if", "implies", "in", "invalid", "let", "not", "null", "or", "self", "then", "true", "xor");
    @NonNull
    public static List<String> restrictedNameList = Arrays.asList("Bag", "Boolean", "Collection", "Integer", "OclAny", "OclInvalid", "OclVoid", "OrderedSet", "Real", "Sequence", "Set", "String", "Tuple", "UnlimitedNatural");
    @NonNull
    private final PrettyPrintOptions options;
    private String pendingPrefix = "";
    @NonNull
    private final StringBuilder pendingText;
    protected Fragment fragment;
    @NonNull
    private Mode mode;
    private final AbstractVisitor<Object, PrettyPrinter> visitor;
    @Nullable
    private Namespace scope;
    @Nullable
    private Precedence currentPrecedence = null;

    @NonNull
    public static PrettyPrinter createNamePrinter(@NonNull Element element, @NonNull PrettyPrintOptions options) {
        return new PrettyPrinter(options, Mode.NAME, element);
    }

    @NonNull
    public static PrettyPrinter createPrinter(@NonNull Element element, @NonNull PrettyPrintOptions options) {
        return new PrettyPrinter(options, Mode.FULL, element);
    }

    @NonNull
    public static PrettyPrintOptions.Global createOptions(@Nullable Namespace scope) {
        PrettyPrintOptions.Global options = new PrettyPrintOptions.Global(scope);
        options.addReservedNames(reservedNameList);
        options.addRestrictedNames(reservedNameList);
        return options;
    }

    @NonNull
    public static String print(@NonNull Element element) {
        return PrettyPrinter.print(element, PrettyPrinter.createOptions(null));
    }

    @NonNull
    public static String print(@NonNull Element element, @NonNull Namespace namespace) {
        return PrettyPrinter.print(element, PrettyPrinter.createOptions(namespace));
    }

    @NonNull
    public static String print(@NonNull Element element, @NonNull PrettyPrintOptions options) {
        PrettyPrinter printer = new PrettyPrinter(options, Mode.FULL, element);
        try {
            printer.appendElement(element);
            String string = printer.toString();
            assert (string != null);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(printer.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    @NonNull
    public static String printName(@NonNull Element element) {
        return PrettyPrinter.printName(element, PrettyPrinter.createOptions(null));
    }

    @NonNull
    public static String printName(@NonNull Element element, @NonNull Namespace namespace) {
        return PrettyPrinter.printName(element, PrettyPrinter.createOptions(namespace));
    }

    @NonNull
    public static String printName(@NonNull Element element, @NonNull PrettyPrintOptions options) {
        PrettyPrinter printer = PrettyPrinter.createNamePrinter(element, options);
        try {
            printer.appendElement(element);
            String string = printer.toString();
            assert (string != null);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(printer.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    @NonNull
    public static String printType(@NonNull Element element) {
        return PrettyPrinter.printType(element, PrettyPrinter.createOptions(null));
    }

    @NonNull
    public static String printType(@NonNull Element element, @NonNull Namespace namespace) {
        return PrettyPrinter.printType(element, PrettyPrinter.createOptions(namespace));
    }

    @NonNull
    public static String printType(@NonNull Element element, @NonNull PrettyPrintOptions options) {
        PrettyPrinter printer = new PrettyPrinter(options, Mode.TYPE, element);
        try {
            printer.appendElement(element);
            String string = printer.toString();
            assert (string != null);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(printer.toString()) + " ... " + e.getClass().getName() + " - " + e.getLocalizedMessage();
        }
    }

    private PrettyPrinter(@NonNull PrettyPrintOptions options, @NonNull Mode mode, @NonNull Element element) {
        this.options = options;
        this.mode = mode;
        this.scope = options.getScope();
        this.pendingText = new StringBuilder();
        this.fragment = new Fragment(null, 0, "", "", "");
        Resource eResource = element.eResource();
        ASResourceFactory asResourceFactory = eResource instanceof ASResource ? ((ASResource)eResource).getASResourceFactory() : null;
        this.visitor = asResourceFactory != null ? asResourceFactory.createPrettyPrintVisitor(this) : new PrettyPrintVisitor(this);
    }

    public void append(Number number) {
        if (number != null) {
            this.append(number.toString());
        } else {
            this.append(NULL_PLACEHOLDER);
        }
    }

    public void append(String string) {
        if (string != null) {
            this.pendingText.append(string);
        } else {
            this.pendingText.append(NULL_PLACEHOLDER);
        }
    }

    public void appendElement(@Nullable Element element) {
        this.visitor.safeVisit(element);
    }

    public void appendMultiplicity(@Nullable Number lower, @Nullable Number upper, boolean isNullFree) {
        StringUtil.appendMultiplicity(this.pendingText, lower != null ? lower.longValue() : 0L, upper == null || upper instanceof Unlimited ? -1L : upper.longValue(), isNullFree);
    }

    public void appendName(NamedElement object) {
        this.appendName(object, this.options.getRestrictedNames());
    }

    public void appendName(NamedElement object, Set<String> keywords) {
        this.append(this.getName(object, keywords));
    }

    public void appendParameters(Operation operation, boolean withNames) {
        this.append("(");
        String prefix = "";
        if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            for (Parameter parameter : iteration.getOwnedIterators()) {
                this.append(prefix);
                if (withNames) {
                    this.appendName(parameter);
                    this.append(" : ");
                }
                this.appendTypedMultiplicity(parameter);
                prefix = ", ";
            }
            if (iteration.getOwnedAccumulators().size() > 0) {
                prefix = "; ";
                for (Parameter parameter : iteration.getOwnedAccumulators()) {
                    if (withNames) {
                        this.appendName(parameter);
                        this.append(" : ");
                    }
                    this.append(prefix);
                    this.appendTypedMultiplicity(parameter);
                    prefix = ", ";
                }
            }
            prefix = " | ";
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.append(prefix);
            if (withNames) {
                this.appendName(parameter);
                this.append(" : ");
            }
            this.appendTypedMultiplicity(parameter);
            prefix = ", ";
        }
        this.append(")");
    }

    public void appendParent(EObject scope, Element element, String parentSeparator) {
        String alias;
        if (element instanceof Package && (alias = this.options.getAlias((Package)element)) != null) {
            this.append(alias);
            this.append(parentSeparator);
            return;
        }
        Mode savedMode = this.pushMode(Mode.TYPE);
        try {
            EObject eObject = scope;
            while (eObject != null) {
                if (element == eObject) {
                    return;
                }
                eObject = eObject.eContainer();
            }
            if (element == null) {
                this.append(NULL_PLACEHOLDER);
            } else {
                MetamodelManager metamodelManager;
                Element unspecializedElement = element instanceof TemplateableElement ? ((TemplateableElement)element).getUnspecializedElement() : element;
                NamedElement parent = PivotUtil.getNamespace((unspecializedElement != null ? unspecializedElement : element).eContainer());
                if (parent instanceof Package) {
                    String alias2 = this.options.getAlias((Package)parent);
                    if (alias2 != null) {
                        this.append(alias2);
                        this.append(parentSeparator);
                        return;
                    }
                    String name = ((Package)parent).getName();
                    if ("$$".equals(name)) {
                        return;
                    }
                    if ("pivot".equals(name)) {
                        return;
                    }
                    if ("ocl".equals(name)) {
                        return;
                    }
                }
                if (element instanceof Operation && parent instanceof Type && "$$".equals(((Type)parent).getName())) {
                    Operation operation = (Operation)element;
                    this.append(operation.getOwningClass().getName());
                    this.appendTemplateBindings(operation);
                    this.append(parentSeparator);
                    return;
                }
                EnvironmentFactory environmentFactory = this.options.getGlobalOptions().getEnvironmentFactory();
                MetamodelManager metamodelManager2 = metamodelManager = environmentFactory != null ? environmentFactory.getMetamodelManager() : null;
                if (metamodelManager != null && parent instanceof Type) {
                    parent = ((PivotMetamodelManager)metamodelManager).getPrimaryType((Type)parent);
                }
                if (parent == scope) {
                    return;
                }
                if (parent instanceof Visitable) {
                    List<PathElement> parentPath = PathElement.getPath(parent, metamodelManager);
                    int iMax = parentPath.size();
                    int i = 0;
                    if (scope != null) {
                        List<PathElement> scopePath = PathElement.getPath(scope, metamodelManager);
                        i = PathElement.getCommonLength(parentPath, scopePath);
                    }
                    if (i < iMax) {
                        this.appendElement(parentPath.get(i++).getElement());
                        while (i < iMax) {
                            this.append("::");
                            this.appendElement(parentPath.get(i++).getElement());
                        }
                    }
                } else assert (element instanceof Package || element instanceof ExpressionInOCL) : element.eClass().getName();
            }
            this.append(parentSeparator);
        }
        finally {
            this.popMode(savedMode);
        }
    }

    public void appendQualifiedType(@NonNull Element element) {
        Mode savedMode = this.pushMode(Mode.TYPE);
        try {
            EnvironmentFactory environmentFactory = this.options.getGlobalOptions().getEnvironmentFactory();
            MetamodelManager metamodelManager = environmentFactory != null ? environmentFactory.getMetamodelManager() : null;
            Namespace parent = PivotUtil.getNamespace(element.eContainer());
            List<PathElement> parentPath = PathElement.getPath(parent, metamodelManager);
            int iMax = parentPath.size();
            int i = 0;
            Namespace scope = this.options.getScope();
            if (scope != null) {
                List<PathElement> scopePath = PathElement.getPath(scope, metamodelManager);
                i = PathElement.getCommonLength(parentPath, scopePath);
            }
            if (i == 0 && i < iMax) {
                Element rootElement;
                int j = iMax - 1;
                while (j >= 0) {
                    String alias;
                    PathElement rootPathElement = parentPath.get(j);
                    rootElement = rootPathElement.getElement();
                    if (rootElement instanceof Namespace && (alias = this.options.getAlias((Namespace)rootElement)) != null) {
                        this.append(this.getName(alias, this.options.getReservedNames()));
                        this.append("::");
                        i = j + 1;
                        break;
                    }
                    --j;
                }
                if (i == 0) {
                    PathElement rootPathElement = parentPath.get(0);
                    String name = rootPathElement.getName();
                    rootElement = rootPathElement.getElement();
                    if (rootElement != null) {
                        if ("$$".equals(name)) {
                            ++i;
                        } else if ("pivot".equals(name)) {
                            ++i;
                        } else if ("ocl".equals(name)) {
                            ++i;
                        } else if (!(rootElement.eContainer() instanceof Model)) {
                            URI uri;
                            if (rootElement.getESObject() != null) {
                                EObject eTarget = rootElement.getESObject();
                                uri = EcoreUtil.getURI((EObject)eTarget);
                            } else {
                                uri = rootElement.eResource().getURI();
                                if (uri != null && PivotUtilInternal.isASURI(uri)) {
                                    uri = PivotUtilInternal.getNonASURI(uri);
                                }
                            }
                            if (uri != null) {
                                URI baseURI = this.options.getBaseURI();
                                if (baseURI != null) {
                                    uri = uri.deresolve(baseURI);
                                }
                                this.append("_'" + uri.toString() + "'");
                            }
                            this.append("::");
                            ++i;
                        }
                    }
                }
            }
            while (i < iMax) {
                this.appendElement(parentPath.get(i++).getElement());
                this.append("::");
            }
            this.appendElement(element);
        }
        finally {
            this.popMode(savedMode);
        }
    }

    public void appendTemplateBindings(@NonNull TemplateableElement typeRef) {
        block10: {
            Mode savedMode = this.pushMode(Mode.NAME);
            try {
                List<TemplateBinding> templateBindings = typeRef.getOwnedBindings();
                if (templateBindings.isEmpty()) break block10;
                this.append("(");
                String prefix = "";
                for (TemplateBinding templateBinding : templateBindings) {
                    for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                        this.append(prefix);
                        Namespace savedScope = this.pushScope((Namespace)((Object)typeRef));
                        try {
                            this.appendElement(templateParameterSubstitution.getActual());
                        }
                        finally {
                            this.popScope(savedScope);
                        }
                        prefix = ", ";
                    }
                }
                if (typeRef instanceof CollectionType) {
                    CollectionType collectionType = (CollectionType)typeRef;
                    Number lower = collectionType.getLower();
                    Number upper = collectionType.getUpper();
                    boolean isNullFree = collectionType.isIsNullFree();
                    if (isNullFree || lower != null && upper != null && (lower.longValue() != 0L || !(upper instanceof Unlimited))) {
                        this.appendMultiplicity(lower, upper, isNullFree);
                    }
                }
                this.append(")");
            }
            finally {
                this.popMode(savedMode);
            }
        }
    }

    public void appendTemplateParameters(TemplateableElement templateableElement) {
        List<TemplateParameter> templateParameters;
        TemplateSignature templateSignature = templateableElement.getOwnedSignature();
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameters()).isEmpty()) {
            this.append("(");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.append(prefix);
                Namespace savedScope = this.pushScope((Namespace)((Object)templateableElement));
                try {
                    this.appendElement(templateParameter);
                }
                finally {
                    this.popScope(savedScope);
                }
                prefix = ", ";
            }
            this.append(")");
        }
    }

    public void appendTypedMultiplicity(TypedElement object) {
        Type type = object.getType();
        this.appendElement(type);
        if (!object.isIsRequired()) {
            this.append("[?]");
        } else if (!(type instanceof CollectionType)) {
            this.append("[1]");
        }
    }

    @Nullable
    public Precedence getCurrentPrecedence() {
        return this.currentPrecedence;
    }

    public Set<String> getReservedNames() {
        return this.options.getReservedNames();
    }

    public Set<String> getRestrictedNames() {
        return this.options.getRestrictedNames();
    }

    public Namespace getScope() {
        return this.scope;
    }

    public void push(@NonNull String text, String suffix) {
        this.append(text);
        String string = this.pendingText.toString();
        assert (string != null);
        this.fragment = this.fragment.addChild(this.pendingPrefix, string, suffix);
        this.fragment.exdented = true;
        this.pendingPrefix = "";
        this.pendingText.setLength(0);
    }

    public void exdent(@NonNull String prefix, @NonNull String text, @NonNull String suffix) {
        String string;
        Fragment fragmentParent = this.fragment.getParent();
        assert (this.fragment != null && fragmentParent != null);
        if (this.pendingPrefix != null && this.pendingPrefix.length() > 0 || this.pendingText.length() > 0) {
            string = this.pendingText.toString();
            assert (string != null);
            this.fragment.addChild(this.pendingPrefix, string, "");
            this.pendingPrefix = "";
            this.pendingText.setLength(0);
        }
        if (prefix.length() > 0 || text.length() > 0) {
            string = text.toString();
            assert (string != null);
            this.fragment = fragmentParent.addChild(prefix, string, suffix);
            this.fragment.exdented = true;
        }
    }

    public String getName(@Nullable NamedElement object, @Nullable Set<String> keywords) {
        if (object == null) {
            return NULL_PLACEHOLDER;
        }
        return this.getName(object.getName(), keywords);
    }

    public String getName(@Nullable String name, @Nullable Set<String> keywords) {
        if (keywords == null || !keywords.contains(name) && PivotUtilInternal.isValidIdentifier(name)) {
            return name;
        }
        StringBuilder s = new StringBuilder();
        s.append("_'");
        s.append(StringUtil.convertToOCLString(name));
        s.append("'");
        return s.toString();
    }

    public void next(@Nullable String prefix, @NonNull String text, @NonNull String suffix) {
        assert (this.fragment != null);
        if (this.pendingPrefix != null && this.pendingPrefix.length() > 0 || this.pendingText.length() > 0) {
            String string = this.pendingText.toString();
            assert (string != null);
            this.fragment.addChild(this.pendingPrefix, string, "");
            this.pendingPrefix = "";
            this.pendingText.setLength(0);
        }
        this.fragment.addChild(prefix, text, suffix);
    }

    public void pop() {
        assert (this.fragment != null);
        if (this.pendingPrefix != null && this.pendingPrefix.length() > 0 || this.pendingText.length() > 0) {
            String string = this.pendingText.toString();
            assert (string != null);
            this.fragment.addChild(this.pendingPrefix, string, "");
        }
        this.pendingPrefix = "";
        this.pendingText.setLength(0);
        assert (this.fragment.getParent() != null);
        this.fragment = this.fragment.getParent();
    }

    public void popMode(@NonNull Mode oldMode) {
        this.mode = oldMode;
    }

    public void popScope(@Nullable Namespace oldScope) {
        this.scope = oldScope;
    }

    public void precedenceVisit(@Nullable OCLExpression expression, @Nullable Precedence newPrecedence) {
        Precedence savedPrecedcence = this.currentPrecedence;
        try {
            this.currentPrecedence = newPrecedence;
            this.appendElement(expression);
        }
        finally {
            this.currentPrecedence = savedPrecedcence;
        }
    }

    @NonNull
    public Mode pushMode(@NonNull Mode newMode) {
        Mode oldMode = this.mode;
        this.mode = newMode;
        return oldMode;
    }

    @Nullable
    public Namespace pushScope(@Nullable Namespace newScope) {
        Namespace oldscope = this.scope;
        this.scope = newScope;
        return oldscope;
    }

    public boolean showNames() {
        return this.mode == Mode.NAME || this.mode == Mode.FULL;
    }

    @NonNull
    public String toString() {
        if (this.fragment == null) {
            return String.valueOf(this.pendingPrefix) + this.pendingText.toString();
        }
        this.fragment.configureLineWrapping(this.options.getIndentStep().length(), this.options.getLinelength());
        StringBuilder s = new StringBuilder();
        String newLine = this.fragment.toString(s, null, "  ");
        return String.valueOf(s.toString()) + newLine + this.pendingPrefix + this.pendingText.toString();
    }

    @NonNull
    public String toString(@NonNull String indent, int lineLength) {
        if (this.fragment == null) {
            return String.valueOf(this.pendingPrefix) + this.pendingText.toString();
        }
        this.fragment.configureLineWrapping(indent.length(), lineLength);
        StringBuilder s = new StringBuilder();
        this.fragment.toString(s, null, indent);
        return String.valueOf(s.toString()) + this.pendingPrefix + this.pendingText.toString();
    }

    private static class Fragment {
        private final int depth;
        @Nullable
        private final String prefix;
        @NonNull
        private final String text;
        @Nullable
        private final String suffix;
        @Nullable
        private Fragment parent = null;
        private List<Fragment> children = null;
        private boolean lineWrap = true;
        private boolean exdented = false;

        public Fragment(@Nullable Fragment parent, int depth, @Nullable String prefix, @NonNull String text, @Nullable String suffix) {
            this.parent = parent;
            this.depth = depth;
            this.prefix = prefix;
            this.text = text;
            this.suffix = suffix;
        }

        @NonNull
        public Fragment addChild(@Nullable String prefix, @NonNull String text, @Nullable String suffix) {
            if (this.children == null) {
                this.children = new ArrayList<Fragment>();
            }
            Fragment child = new Fragment(this, this.depth + 1, prefix, text, suffix);
            this.children.add(child);
            return child;
        }

        public void configureLineWrapping(int spacesPerIndent, int lineLength) {
            int firstColumn = this.depth * spacesPerIndent;
            int lastColumn = firstColumn + this.text.length();
            if (this.prefix != null) {
                lastColumn += this.prefix.length();
            }
            if (this.suffix != null) {
                lastColumn += this.suffix.length();
            }
            if (this.children != null) {
                for (Fragment child : this.children) {
                    child.lineWrap = true;
                    child.configureLineWrapping(spacesPerIndent, lineLength);
                }
                int allChildrenLength = this.getChildrenLength(true);
                if (lastColumn + allChildrenLength <= lineLength) {
                    for (Fragment child : this.children) {
                        child.lineWrap = false;
                    }
                } else {
                    for (Fragment child : this.children) {
                        child.lineWrap = child.exdented;
                    }
                }
            }
            if (this.parent == null) {
                this.lineWrap = false;
            }
        }

        public int getChildrenLength(Boolean concatenate) {
            int childrenLength = 0;
            int iChild = 0;
            while (iChild < this.children.size()) {
                int childLength = this.getChildLength(iChild);
                if (concatenate == Boolean.TRUE) {
                    childrenLength += childLength;
                } else if (childLength > childrenLength) {
                    childrenLength = childLength;
                }
                ++iChild;
            }
            return childrenLength;
        }

        public int getChildLength(int iChild) {
            Fragment child = this.children.get(iChild);
            int childLength = child.length();
            int jChild = iChild + 1;
            while (jChild < this.children.size()) {
                Fragment nextChild = this.children.get(jChild);
                if (nextChild.prefix != null && nextChild.lineWrap) break;
                childLength += child.length();
                ++jChild;
            }
            return childLength;
        }

        public int length() {
            int length = this.text.length();
            if (this.prefix != null) {
                length += this.prefix.length();
            }
            if (this.suffix != null) {
                length += this.suffix.length();
            }
            if (this.children != null) {
                length += this.getChildrenLength(null);
            }
            return length;
        }

        @Nullable
        public Fragment getParent() {
            return this.parent;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            this.toString(s, null, "  ");
            return s.toString();
        }

        public String toString(@NonNull StringBuilder s, String newLine, String indent) {
            if ((this.lineWrap || newLine != null) && this.prefix != null) {
                if (this.lineWrap) {
                    newLine = "\n";
                }
                s.append(newLine);
                if (this.text.length() > 0) {
                    if (newLine != null && newLine.equals("\n")) {
                        int i = 1;
                        while (i < this.depth) {
                            s.append(indent);
                            ++i;
                        }
                    } else {
                        s.append(this.prefix);
                    }
                } else if (this.prefix != null && this.prefix.length() > 0) {
                    s.append(this.prefix);
                }
            }
            s.append(this.text);
            newLine = this.suffix;
            if (this.children != null) {
                for (Fragment child : this.children) {
                    newLine = child.toString(s, newLine, indent);
                }
            }
            return newLine;
        }
    }

    private static enum Mode {
        TYPE,
        NAME,
        FULL;

    }
}

