/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.manager.TemplateParameterSubstitutionVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.EssentialOCLPrettyPrintVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrintVisitor;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.ASResourceImpl;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.AS2XMIid;
import org.eclipse.ocl.pivot.internal.utilities.EcoreTechnology;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.Technology;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.AS2MonikerVisitor;
import org.eclipse.ocl.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverLocateVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverNormalizeVisitor;
import org.eclipse.ocl.pivot.utilities.ASSaverResolveVisitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;

public abstract class AbstractASResourceFactory
extends ResourceFactoryImpl
implements ASResourceFactory {
    @NonNull
    protected final String contentType;

    public static void installContentHandler(int priority, @NonNull ContentHandler contentHandler) {
        ArrayList<ContentHandler> contentHandlers = (ArrayList<ContentHandler>)ContentHandler.Registry.INSTANCE.get((Object)priority);
        if (contentHandlers == null) {
            contentHandlers = new ArrayList<ContentHandler>();
            ContentHandler.Registry.INSTANCE.put((Object)priority, contentHandlers);
        }
        if (!contentHandlers.contains(contentHandler)) {
            contentHandlers.add(contentHandler);
        }
    }

    protected AbstractASResourceFactory(@NonNull String contentType) {
        this.contentType = contentType;
    }

    @Override
    @NonNull
    public ASResourceFactory basicGetASResourceFactory() {
        return this;
    }

    @Override
    public void configure(@NonNull ResourceSet resourceSet) {
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        resourceFactoryRegistry.getContentTypeToFactoryMap().put(this.contentType, this);
    }

    protected void configureResource(@NonNull ASResource asResource) {
        asResource.setEncoding("UTF-8");
        Map defaultSaveOptions = asResource.getDefaultSaveOptions();
        defaultSaveOptions.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        defaultSaveOptions.put("URI_HANDLER", new URIHandlerImpl.PlatformSchemeAware());
        defaultSaveOptions.put("SCHEMA_LOCATION", Boolean.TRUE);
        defaultSaveOptions.put("SCHEMA_LOCATION_IMPLEMENTATION", Boolean.TRUE);
    }

    @Override
    @NonNull
    public AS2MonikerVisitor createAS2MonikerVisitor(@NonNull AS2Moniker as2moniker) {
        return new AS2MonikerVisitor(as2moniker);
    }

    @Override
    @NonNull
    public AS2XMIidVisitor createAS2XMIidVisitor(@NonNull AS2XMIid as2id) {
        return new AS2XMIidVisitor(as2id);
    }

    @Override
    @NonNull
    public ASSaverLocateVisitor createASSaverLocateVisitor(@NonNull ASSaver saver) {
        return new ASSaverLocateVisitor(saver);
    }

    @Override
    @NonNull
    public ASSaverNormalizeVisitor createASSaverNormalizeVisitor(@NonNull ASSaver saver) {
        return new ASSaverNormalizeVisitor(saver);
    }

    @Override
    @NonNull
    public ASSaverResolveVisitor createASSaverResolveVisitor(@NonNull ASSaver saver) {
        return new ASSaverResolveVisitor(saver);
    }

    @Override
    @NonNull
    public PrettyPrintVisitor createPrettyPrintVisitor(@NonNull PrettyPrinter prettyPrinter) {
        return new EssentialOCLPrettyPrintVisitor(prettyPrinter);
    }

    @Override
    @NonNull
    public TemplateParameterSubstitutionVisitor createTemplateParameterSubstitutionVisitor(@NonNull EnvironmentFactory environmentFactory, @Nullable Type selfType, @Nullable Type selfTypeValue) {
        return new TemplateParameterSubstitutionVisitor((EnvironmentFactoryInternal)environmentFactory, selfType, selfTypeValue);
    }

    @Override
    @NonNull
    public ToStringVisitor createToStringVisitor(@NonNull StringBuilder s) {
        return new ToStringVisitor(s);
    }

    public Resource createResource(URI uri) {
        assert (uri != null);
        ASResourceImpl result = new ASResourceImpl(uri, this);
        this.configureResource(result);
        return result;
    }

    @Override
    @Nullable
    public <T extends Element> T getASElement(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Class<T> pivotClass, @NonNull EObject eObject) throws ParserException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".getASElement");
    }

    @Override
    @NonNull
    public ASResourceFactory getContribution() {
        return this;
    }

    @Override
    @NonNull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    @Nullable
    public EOperation getEOperation(@NonNull ASResource asResource, @NonNull EObject eObject) {
        return null;
    }

    @Override
    @Nullable
    public EReference getEReference(@NonNull ASResource asResource, @NonNull EObject eObject) {
        return null;
    }

    @Override
    @Nullable
    public String getMetamodelNsURI(@NonNull EPackage ePackage) {
        return null;
    }

    @Override
    @Nullable
    public URI getPackageURI(@NonNull EObject eObject) {
        return null;
    }

    @Override
    @Nullable
    public Integer getPriority() {
        return null;
    }

    @Override
    @Nullable
    public String getResourceClassName() {
        return null;
    }

    @Override
    @NonNull
    public Technology getTechnology() {
        return EcoreTechnology.INSTANCE;
    }

    @Override
    @Nullable
    public Element importFromResource(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource resource, @Nullable URI uri) throws ParserException {
        Object asResource = resource instanceof ASResource ? resource : ((CSResource)resource).getASResource();
        EList contents = asResource.getContents();
        if (contents.size() <= 0) {
            return null;
        }
        if (uri == null) {
            return (Element)contents.get(0);
        }
        String fragment = uri.fragment();
        if (fragment == null) {
            return (Element)contents.get(0);
        }
        EObject eObject = asResource.getEObject(fragment);
        if (eObject instanceof Element) {
            return (Element)eObject;
        }
        return null;
    }

    @Override
    public void initializeEValidatorRegistry(@NonNull EValidator.Registry eValidatorRegistry) {
    }

    protected void install(@Nullable String oclasExtension, @Nullable String resourceClassName) {
        ASResourceFactoryRegistry.INSTANCE.addASResourceFactory(this.contentType, oclasExtension, resourceClassName, this);
    }

    @Override
    public boolean isCompatibleResource(@NonNull Resource newResource, @NonNull Resource oldResource) {
        return false;
    }

    @NonNull
    public String toString() {
        return this.contentType;
    }
}

