/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.scoping;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.scoping.Attribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.NullAttribution;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;

public class PivotScopeView
implements ScopeView {
    @NonNull
    public static final ScopeView NULLSCOPEVIEW = new ScopeView(){

        @Override
        @NonNull
        public Attribution getAttribution() {
            return NullAttribution.INSTANCE;
        }

        @Override
        @Nullable
        public Element getChild() {
            return null;
        }

        @Override
        @Nullable
        public EStructuralFeature getContainmentFeature() {
            return null;
        }

        @Override
        @NonNull
        public ScopeView getParent() {
            return NULLSCOPEVIEW;
        }

        @Override
        @NonNull
        public ScopeView getRoot() {
            return NULLSCOPEVIEW;
        }

        @Override
        public Element getTarget() {
            return null;
        }

        @Override
        public boolean isQualified() {
            return false;
        }
    };
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final Element target;
    @Nullable
    protected final Element child;
    protected final boolean isQualified;
    private ScopeView parent = null;
    private Attribution attribution = null;

    protected PivotScopeView(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Element target, @Nullable Element child, boolean isQualified) {
        this.environmentFactory = environmentFactory;
        this.target = target;
        this.child = child;
        this.isQualified = isQualified;
    }

    @Nullable
    public ScopeView computeLookup(@NonNull EnvironmentView environmentView, @NonNull EObject aTarget) {
        assert (aTarget instanceof Element);
        if (this.attribution == null) {
            this.attribution = PivotUtilInternal.getAttribution(this.target);
        }
        return this.attribution.computeLookup(aTarget, environmentView, this);
    }

    @Override
    @NonNull
    public Attribution getAttribution() {
        Attribution attribution2 = this.attribution;
        if (attribution2 == null) {
            this.attribution = attribution2 = PivotUtilInternal.getAttribution(this.target);
        }
        return attribution2;
    }

    @Override
    @Nullable
    public Element getChild() {
        return this.child;
    }

    @Override
    @Nullable
    public EStructuralFeature getContainmentFeature() {
        return this.child != null ? this.child.eContainmentFeature() : null;
    }

    @Override
    @NonNull
    public ScopeView getParent() {
        ScopeView parent2 = this.parent;
        if (parent2 == null) {
            EObject pParent = this.target.eContainer();
            parent2 = pParent instanceof Element ? new PivotScopeView(this.environmentFactory, (Element)pParent, this.target, this.isQualified) : NULLSCOPEVIEW;
            this.parent = parent2;
        }
        return parent2;
    }

    @Override
    @NonNull
    public ScopeView getRoot() {
        ScopeView parent = this.getParent();
        if (parent == NULLSCOPEVIEW) {
            return this;
        }
        return parent.getRoot();
    }

    @Override
    @NonNull
    public final Element getTarget() {
        return this.target;
    }

    @Override
    public boolean isQualified() {
        return this.isQualified;
    }

    public String toString() {
        Element target = this.getTarget();
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(target.eClass().getName());
        EStructuralFeature containmentFeature = this.getContainmentFeature();
        if (containmentFeature != null) {
            s.append("::");
            s.append(containmentFeature.getName());
        }
        s.append("] ");
        s.append(String.valueOf(target));
        return s.toString();
    }
}

