/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Parameter;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.AS2MonikerVisitor;
import org.eclipse.ocl.pivot.utilities.PivotUtil;

public class AS2Moniker
implements PivotConstantsInternal {
    private static final Logger logger = Logger.getLogger(AS2Moniker.class);
    protected final EObject target;
    private final StringBuilder s = new StringBuilder();
    private List<TemplateParameter> emittedParameters = null;

    @NonNull
    public static String toString(@NonNull Element pivotElement) {
        AS2Moniker moniker = new AS2Moniker(pivotElement);
        moniker.appendElement(pivotElement);
        String string = moniker.toString();
        assert (!"".equals(string)) : "Zero length moniker for '" + pivotElement.eClass().getName() + "'";
        assert (string != null);
        return string;
    }

    public AS2Moniker(@NonNull Element target) {
        this.target = target;
    }

    public void append(char c) {
        this.s.append(c);
    }

    public void append(int i) {
        this.s.append(i);
    }

    public void append(String string) {
        this.s.append(string != null ? string : "null");
    }

    public void appendElement(Element element) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (element == null) {
            this.append("<<null-element>>");
        } else if (element.eIsProxy()) {
            this.append("<<unresolved-proxy>>");
        } else {
            AS2MonikerVisitor as2MonikerVisitor = this.createAS2MonikerVisitor(element);
            element.accept(as2MonikerVisitor);
        }
    }

    public void appendElement(Element element, Map<TemplateParameter, Type> templateBindings) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (element == null) {
            this.append("<<null-element>>");
        } else if (templateBindings != null) {
            AS2MonikerVisitor nestedAS2MonikerVisitor = new AS2MonikerVisitor(this, templateBindings);
            element.accept(nestedAS2MonikerVisitor);
        } else {
            AS2MonikerVisitor as2MonikerVisitor = this.createAS2MonikerVisitor(element);
            element.accept(as2MonikerVisitor);
        }
    }

    public void appendIndex(EObject eObject) {
        Object objects;
        EObject parent;
        if (eObject != null && (parent = eObject.eContainer()) != null && (objects = parent.eGet(eObject.eContainingFeature())) instanceof List) {
            this.append(((List)objects).indexOf(eObject));
            return;
        }
        this.append(0);
    }

    public void appendLambdaType(Type contextType, List<? extends Type> parameterTypes, Type resultType, Map<TemplateParameter, Type> bindings) {
        if (contextType != null) {
            this.append("~");
            this.appendElement(contextType, bindings);
            this.append("(");
            String prefix = "";
            for (Type type : parameterTypes) {
                this.append(prefix);
                this.appendElement(type, bindings);
                prefix = ",";
            }
            this.append(")");
            if (resultType != null) {
                this.appendElement(resultType, bindings);
            }
        }
    }

    public void appendName(Element monikeredElement) {
        TemplateableElement unspecializedElement;
        if (monikeredElement instanceof TemplateableElement && (unspecializedElement = ((TemplateableElement)monikeredElement).getUnspecializedElement()) != null) {
            this.appendName(unspecializedElement);
            return;
        }
        if (monikeredElement instanceof NamedElement) {
            this.append(((NamedElement)monikeredElement).getName());
        } else if (monikeredElement == null) {
            this.append("/null/");
        } else {
            logger.warn((Object)("Unsupported PivotMoniker.appendName() for " + monikeredElement.eClass().getName()));
            this.append("/anon/");
        }
    }

    public void appendParameters(Operation operation, Map<TemplateParameter, Type> templateBindings) {
        this.s.append("(");
        String prefix = "";
        if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            for (Parameter parameter : iteration.getOwnedIterators()) {
                this.s.append(prefix);
                this.appendElement(parameter.getType(), templateBindings);
                prefix = ",";
            }
            if (iteration.getOwnedAccumulators().size() > 0) {
                prefix = ";";
                for (Parameter parameter : iteration.getOwnedAccumulators()) {
                    this.s.append(prefix);
                    this.appendElement(parameter.getType(), templateBindings);
                    prefix = ",";
                }
            }
            prefix = "|";
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.s.append(prefix);
            this.appendElement(parameter.getType(), templateBindings);
            prefix = ",";
        }
        this.s.append(")");
    }

    public void appendParent(Element element, String parentSeparator) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (element == null) {
            this.append("<<null-element>>");
        } else {
            EObject parent = element.eContainer();
            if (parent instanceof Element) {
                TemplateSignature ownedTemplateSignature;
                this.appendElement((Element)parent);
                if (parent instanceof TemplateableElement && (ownedTemplateSignature = ((TemplateableElement)parent).getOwnedSignature()) != null) {
                    for (TemplateParameter templateParameter : ownedTemplateSignature.getOwnedParameters()) {
                        this.emittedTemplateParameter(templateParameter);
                    }
                }
            } else if (element.eIsProxy()) {
                this.append("<<unresolved-proxy>>");
            } else assert (element instanceof Model || element instanceof ExpressionInOCL) : String.valueOf(element.eClass().getName()) + " has no parent";
        }
        this.append(parentSeparator);
    }

    public void appendRole(Element object) {
        EReference eFeature = object.eContainmentFeature();
        if (eFeature != null) {
            int index;
            String roleName = (String)roleNames.get(eFeature);
            if (roleName == null) {
                roleName = eFeature.getName();
            }
            this.append(roleName);
            if (eFeature.isMany() && (index = ((List)object.eContainer().eGet(object.eContainingFeature())).indexOf(object)) != 0) {
                this.append(index);
            }
        }
    }

    public void appendTemplateArguments(List<? extends Type> templateArguments, Map<TemplateParameter, Type> templateBindings) {
        if (!templateArguments.isEmpty()) {
            this.append("[");
            String prefix = "";
            for (Type type : templateArguments) {
                this.append(prefix);
                this.appendElement(type, templateBindings);
                prefix = ",";
            }
            this.append("]");
        }
    }

    public void appendTemplateBindings(TemplateableElement templateableElement, Map<TemplateParameter, Type> bindings) {
        List<TemplateBinding> templateBindings = templateableElement.getOwnedBindings();
        if (!templateBindings.isEmpty()) {
            boolean isSpecialized = this.isSpecialized(templateBindings, bindings);
            if (!isSpecialized) {
                this.s.append("{");
                String prefix = "";
                for (TemplateBinding templateBinding : templateBindings) {
                    List<TemplateParameterSubstitution> parameterSubstitutions = templateBinding.getOwnedSubstitutions();
                    if (parameterSubstitutions.size() > 1) {
                        parameterSubstitutions = new ArrayList<TemplateParameterSubstitution>(parameterSubstitutions);
                        Collections.sort(parameterSubstitutions, PivotUtil.TemplateParameterSubstitutionComparator.INSTANCE);
                    }
                    for (TemplateParameterSubstitution templateParameterSubstitution : parameterSubstitutions) {
                        this.s.append(prefix);
                        this.appendName(templateParameterSubstitution.getFormal());
                        prefix = ",";
                    }
                }
                this.s.append("}");
            } else {
                this.s.append("[");
                String prefix = "";
                for (TemplateBinding templateBinding : templateBindings) {
                    List<TemplateParameterSubstitution> parameterSubstitutions = templateBinding.getOwnedSubstitutions();
                    if (parameterSubstitutions.size() > 1) {
                        parameterSubstitutions = new ArrayList<TemplateParameterSubstitution>(parameterSubstitutions);
                        Collections.sort(parameterSubstitutions, PivotUtil.TemplateParameterSubstitutionComparator.INSTANCE);
                    }
                    for (TemplateParameterSubstitution templateParameterSubstitution : parameterSubstitutions) {
                        this.s.append(prefix);
                        this.appendElement(templateParameterSubstitution.getActual(), bindings);
                        prefix = ",";
                    }
                }
                this.s.append("]");
            }
        }
    }

    public void appendTemplateParameters(TemplateableElement templateableElement) {
        List<TemplateParameter> templateParameters;
        TemplateSignature templateSignature = templateableElement.getOwnedSignature();
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameters()).isEmpty()) {
            this.s.append("{");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.s.append(prefix);
                this.emittedTemplateParameter(templateParameter);
                this.appendName(templateParameter);
                prefix = ",";
            }
            this.s.append("}");
        }
    }

    public void appendTupleType(Collection<? extends TypedElement> tupleParts) {
        ArrayList<? extends TypedElement> parts = new ArrayList<TypedElement>(tupleParts);
        Collections.sort(parts, new Comparator<TypedElement>(){

            @Override
            public int compare(TypedElement o1, TypedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.append("{");
        String prefix = "";
        for (TypedElement typedElement : parts) {
            this.append(prefix);
            this.appendName(typedElement);
            this.append(":");
            Type type = typedElement.getType();
            if (type != null) {
                this.appendElement(type);
            }
            prefix = ",";
        }
        this.append("}");
    }

    @NonNull
    protected AS2MonikerVisitor createAS2MonikerVisitor(@NonNull Element element) {
        Resource resource = element.eResource();
        AS2MonikerVisitor as2MonikerVisitor = resource instanceof ASResource ? ((ASResource)resource).getASResourceFactory().createAS2MonikerVisitor(this) : new AS2MonikerVisitor(this);
        return as2MonikerVisitor;
    }

    protected void emittedTemplateParameter(TemplateParameter templateParameter) {
        if (this.emittedParameters == null) {
            this.emittedParameters = new ArrayList<TemplateParameter>();
        }
        this.emittedParameters.add(templateParameter);
    }

    public boolean hasEmitted(TemplateParameter templateParameter) {
        return this.emittedParameters != null && this.emittedParameters.contains(templateParameter);
    }

    protected boolean isSpecialized(List<TemplateBinding> templateBindings, Map<TemplateParameter, Type> bindings) {
        if (bindings == null) {
            return true;
        }
        for (TemplateBinding templateBinding : templateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                Type actual = templateParameterSubstitution.getActual();
                if (actual == null) {
                    return true;
                }
                Type parameterableElement = bindings.get(actual);
                if (parameterableElement != null && parameterableElement == templateParameterSubstitution.getFormal()) continue;
                return true;
            }
        }
        return false;
    }

    protected int length() {
        return this.s.length();
    }

    public String toString() {
        return this.s.toString();
    }
}

