/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;

public abstract class AbstractConversion {
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final PivotMetamodelManager metamodelManager;
    @NonNull
    protected final CompleteEnvironmentInternal completeEnvironment;
    @NonNull
    protected final StandardLibraryInternal standardLibrary;

    protected static <T> T basicGet(@NonNull EObject eObject, @NonNull EAttribute eFeature, @NonNull Class<T> resultClass) {
        if (!eObject.eIsSet((EStructuralFeature)eFeature)) {
            return null;
        }
        Object result = eObject.eGet((EStructuralFeature)eFeature);
        return (T)result;
    }

    @Nullable
    public static EPackage getEPackage(@Nullable EObject eObject) {
        while (eObject != null) {
            if (eObject instanceof EPackage) {
                return (EPackage)eObject;
            }
            eObject = eObject.eContainer();
        }
        return null;
    }

    public static boolean isId(@NonNull String name) {
        int n = name.length();
        if (n == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < n) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected AbstractConversion(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
        this.metamodelManager = environmentFactory.getMetamodelManager();
        this.completeEnvironment = environmentFactory.getCompleteEnvironment();
        this.standardLibrary = this.completeEnvironment.getOwnedStandardLibrary();
    }

    @NonNull
    public EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @NonNull
    public PivotMetamodelManager getMetamodelManager() {
        return this.metamodelManager;
    }

    @NonNull
    public StandardLibraryInternal getStandardLibrary() {
        return this.standardLibrary;
    }

    public <T extends EObject> void refreshList(@Nullable List<? super T> oldElements, @Nullable List<? extends T> newElements) {
        PivotUtilInternal.refreshList(oldElements, newElements);
    }

    protected <T extends EObject> void refreshSet(@Nullable List<? super T> oldElements, @Nullable Collection<? extends T> newElements) {
        PivotUtilInternal.refreshSet(oldElements, newElements);
    }

    public static interface Predicate<T extends EObject> {
        public boolean filter(@NonNull T var1);
    }
}

