/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.preferences.PreferenceableOption;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.AbstractEnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Option;

public class PivotEnvironmentFactory
extends AbstractEnvironmentFactory {
    @Nullable
    private IProject project = null;
    @Nullable
    private IScopeContext[] scopeContexts = null;

    public PivotEnvironmentFactory(@NonNull ProjectManager projectManager, @Nullable ResourceSet externalResourceSet) {
        super(projectManager, externalResourceSet);
    }

    @Override
    @Nullable
    public <T> T getValue(@NonNull Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result != null) {
            return (T)result;
        }
        EnvironmentFactoryInternal parent2 = this.getParent();
        if (parent2 != null) {
            return parent2.getValue(option);
        }
        if (option instanceof PreferenceableOption) {
            this.scopeContexts = this.project != null ? new IScopeContext[]{new ProjectScope(this.project), ConfigurationScope.INSTANCE} : null;
            PreferenceableOption preferenceableOption = (PreferenceableOption)option;
            result = OCLCommon.getPreference((PreferenceableOption)preferenceableOption, (IScopeContext[])this.scopeContexts);
            if (result != null) {
                return (T)result;
            }
        }
        return option.getDefaultValue();
    }

    @Override
    public void setProject(@Nullable IProject project) {
        this.project = project;
    }
}

