/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.CollectionValueImpl;
import org.eclipse.ocl.pivot.internal.values.OrderedSetImpl;
import org.eclipse.ocl.pivot.internal.values.SparseOrderedSetValueImpl;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.NullValue;
import org.eclipse.ocl.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public abstract class OrderedSetValueImpl
extends CollectionValueImpl
implements OrderedSetValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.ORDERED_SET_VALUE;
    }

    public OrderedSetValueImpl(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> elements) {
        super(typeId, elements);
        assert (this.checkElementsAreUnique(this.elements));
    }

    @Override
    @NonNull
    public OrderedSetValue appendAll(@NonNull OrderedCollectionValue objects) {
        OrderedSetImpl<? extends Object> result = new OrderedSetImpl<Object>(this.elements);
        Collection<? extends Object> thoseElements = objects.getElements();
        result.removeAll(thoseElements);
        result.addAll(thoseElements);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public OrderedCollectionValue asOrderedCollectionValue() {
        return this;
    }

    @Override
    @NonNull
    public OrderedSetValueImpl asOrderedSetValue() {
        return this;
    }

    @Override
    @NonNull
    public LinkedHashSet<Object> asUnboxedObject(@NonNull IdResolver idResolver) {
        LinkedHashSet<Object> unboxedValues = new LinkedHashSet<Object>();
        for (Object boxedValue : this.elements) {
            unboxedValues.add(idResolver.unboxedValueOf(boxedValue));
        }
        return unboxedValues;
    }

    @Override
    @NonNull
    public UniqueCollectionValue asUniqueCollectionValue() {
        return this;
    }

    @Override
    @Nullable
    public Object at(int index) {
        if (--index < 0 || index >= this.elements.size()) {
            throw new InvalidValueException(PivotMessages.IndexOutOfRange, index + 1, this.size());
        }
        int curr = 0;
        for (Object object : this) {
            if (curr++ != index) continue;
            return object;
        }
        throw new InvalidValueException("Null collection content", new Object[0]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedSetValue) || obj instanceof NullValue) {
            return false;
        }
        Iterator<Object> theseElements = this.iterator();
        Iterator<Object> thoseElements = ((OrderedSetValue)obj).iterator();
        while (theseElements.hasNext() && thoseElements.hasNext()) {
            Object thisElement = theseElements.next();
            Object thatElement = thoseElements.next();
            if (!(thisElement == null ? thatElement != null : !thisElement.equals(thatElement))) continue;
            return false;
        }
        return !theseElements.hasNext() && !thoseElements.hasNext();
    }

    @Override
    @NonNull
    public OrderedSetValue excluding(@Nullable Object value) {
        OrderedSetImpl result = new OrderedSetImpl();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new SparseOrderedSetValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public OrderedSetValue excludingAll(@NonNull CollectionValue values) {
        OrderedSetImpl result = new OrderedSetImpl();
        for (Object element : this.elements) {
            boolean reject = false;
            if (element == null) {
                for (Object value : values) {
                    if (value != null) continue;
                    reject = true;
                    break;
                }
            } else {
                for (Object value : values) {
                    if (value == null || !value.equals(element)) continue;
                    reject = true;
                    break;
                }
            }
            if (reject) continue;
            result.add(element);
        }
        if (result.size() < this.elements.size()) {
            return new SparseOrderedSetValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public String getKind() {
        return "OrderedSet";
    }

    @Override
    @NonNull
    public OrderedSetValue includingAll(@NonNull CollectionValue values) {
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        for (Object value : values) {
            result.add(value);
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public IntegerValue indexOf(@Nullable Object object) {
        int index = 1;
        if (object == null) {
            for (Object next : this.elements) {
                if (next == null) {
                    return ValueUtil.integerValueOf(index);
                }
                ++index;
            }
        } else {
            for (Object next : this.elements) {
                if (object.equals(next)) {
                    return ValueUtil.integerValueOf(index);
                }
                ++index;
            }
        }
        throw new InvalidValueException(PivotMessages.MissingValue, "indexOf");
    }

    @Override
    @NonNull
    public OrderedSetValue insertAt(int index, @Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(PivotMessages.InvalidSource, "insertAt");
        }
        boolean isContained = this.elements.contains(object);
        int effectiveSize = this.elements.size() - (isContained ? 1 : 0);
        if (--index < 0 || effectiveSize < index) {
            throw new InvalidValueException(PivotMessages.IndexOutOfRange, index + 1, this.size());
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>();
        int curr = 0;
        if (object == null) {
            Iterator<Object> it = this.iterator();
            while (it.hasNext()) {
                Object next;
                if (curr == index) {
                    result.add(object);
                }
                if ((next = it.next()) == null) continue;
                result.add(next);
                ++curr;
            }
        } else {
            Iterator<Object> it = this.iterator();
            while (it.hasNext()) {
                Object next;
                if (curr == index) {
                    result.add(object);
                }
                if (object.equals(next = it.next())) continue;
                result.add(next);
                ++curr;
            }
        }
        if (index == effectiveSize) {
            result.add(object);
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    @NonNull
    public OrderedSetValue minus(@NonNull UniqueCollectionValue set) {
        OrderedSetImpl result = new OrderedSetImpl(this.elements);
        result.removeAll(set.asCollection());
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public OrderedSetValue prependAll(@NonNull OrderedCollectionValue objects) {
        OrderedSetImpl<? extends Object> result = new OrderedSetImpl<Object>(objects.getElements());
        result.addAll(this.elements);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public OrderedSetValue reverse() {
        List<? extends Object> elements = this.asList();
        Collections.reverse(elements);
        return new SparseOrderedSetValueImpl(this.getTypeId(), elements);
    }

    @Override
    @NonNull
    public OrderedSetValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseOrderedSetValueImpl(this.getTypeId(), values);
    }

    @Override
    @NonNull
    public OrderedSetValue subOrderedSet(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new InvalidValueException(new IndexOutOfBoundsException("lower: " + (lower + 1)));
        }
        if (upper >= this.elements.size()) {
            throw new InvalidValueException(new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size()));
        }
        if (upper < lower) {
            throw new InvalidValueException(new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1)));
        }
        OrderedSetImpl result = new OrderedSetImpl();
        int curr = 0;
        for (Object object : this.elements) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public OrderedSetValue symmetricDifference(@NonNull UniqueCollectionValue set) {
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        for (Object object : set.iterable()) {
            if (result.contains(object)) {
                result.remove(object);
                continue;
            }
            result.add(object);
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }
}

