/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.values;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.values.CollectionValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseOrderedSetValueImpl;
import org.eclipse.ocl.pivot.internal.values.SparseSequenceValueImpl;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.pivot.values.ValuesPackage;

public class SetValueImpl
extends CollectionValueImpl
implements SetValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.SET_VALUE;
    }

    @NonNull
    public static Set<Object> createSetOfEach(@NonNull Object[] boxedValues) {
        HashSet<Object> result = new HashSet<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public SetValueImpl(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        super(typeId, boxedValues);
        assert (this.checkElementsAreUnique(this.elements));
    }

    @Override
    @NonNull
    public UniqueCollectionValue asUniqueCollectionValue() {
        return this;
    }

    @Override
    @NonNull
    public SetValue asSetValue() {
        return this;
    }

    @Override
    @NonNull
    public Set<Object> asUnboxedObject(@NonNull IdResolver idResolver) {
        HashSet<Object> unboxedValues = new HashSet<Object>();
        for (Object boxedValue : this.elements) {
            unboxedValues.add(idResolver.unboxedValueOf(boxedValue));
        }
        return unboxedValues;
    }

    public boolean equals(Object obj) {
        Collection<? extends Object> thoseElements;
        int thatSize;
        if (!(obj instanceof SetValue)) {
            return false;
        }
        int thisSize = this.elements.size();
        if (thisSize != (thatSize = (thoseElements = ((SetValue)obj).getElements()).size())) {
            return false;
        }
        if (thoseElements instanceof Set) {
            return thoseElements.containsAll(this.elements);
        }
        return this.elements.containsAll(thoseElements);
    }

    @Override
    @NonNull
    public SetValue excluding(@Nullable Object value) {
        HashSet result = new HashSet();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new SetValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public SetValue excludingAll(@NonNull CollectionValue values) {
        HashSet result = new HashSet();
        for (Object element : this.elements) {
            boolean reject = false;
            if (element == null) {
                for (Object value : values) {
                    if (value != null) continue;
                    reject = true;
                    break;
                }
            } else {
                for (Object value : values) {
                    if (value == null || !value.equals(element)) continue;
                    reject = true;
                    break;
                }
            }
            if (reject) continue;
            result.add(element);
        }
        if (result.size() < this.elements.size()) {
            return new SetValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public SetValue flatten() {
        HashSet<Object> flattened = new HashSet<Object>();
        if (this.flatten(flattened)) {
            return new SetValueImpl(this.getTypeId(), flattened);
        }
        return this;
    }

    @Override
    @NonNull
    public String getKind() {
        return "Set";
    }

    @Override
    @NonNull
    public SetValue including(@Nullable Object value) {
        assert (!(value instanceof InvalidValueException));
        HashSet<Object> result = new HashSet<Object>(this.elements);
        result.add(value);
        return new SetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public SetValue includingAll(@NonNull CollectionValue values) {
        HashSet<Object> result = new HashSet<Object>(this.elements);
        for (Object value : values) {
            result.add(value);
        }
        return new SetValueImpl(this.getTypeId(), result);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    @NonNull
    public SetValue minus(@NonNull UniqueCollectionValue set) {
        HashSet result = new HashSet(this.elements);
        result.removeAll(set.asCollection());
        return new SetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public OrderedSetValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseOrderedSetValueImpl(this.getOrderedSetTypeId(), values);
    }

    @Override
    @NonNull
    public SetValue symmetricDifference(@NonNull UniqueCollectionValue set) {
        HashSet<Object> result = new HashSet<Object>(this.elements);
        for (Object object : set.iterable()) {
            if (result.contains(object)) {
                result.remove(object);
                continue;
            }
            result.add(object);
        }
        return new SetValueImpl(this.getTypeId(), result);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), SparseSequenceValueImpl.createSequenceOfEach(this.elements));
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("Set");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends SetValueImpl
    implements SetValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new HashSet());
        }

        @Override
        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }
    }
}

