/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.library.AbstractIterationManager;
import org.eclipse.ocl.pivot.values.CollectionValue;

public abstract class AbstractEvaluatorIterationManager
extends AbstractIterationManager {
    @NonNull
    protected final CollectionValue collectionValue;
    @NonNull
    protected final OCLExpression body;
    @Nullable
    protected final TypedElement accumulatorVariable;
    @Nullable
    private Object accumulatorValue;

    protected static ValueIterator[] createIterators(@NonNull TypedElement[] referredIterators, @NonNull Evaluator evaluator, @NonNull CollectionValue collectionValue) {
        int iMax = referredIterators.length;
        ValueIterator[] iterators = new ValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            TypedElement referredIterator = referredIterators[i];
            if (referredIterator != null) {
                ValueIterator valueIterator = new ValueIterator(evaluator, collectionValue, referredIterator);
                if (!valueIterator.hasCurrent()) {
                    return null;
                }
                iterators[i] = valueIterator;
            }
            ++i;
        }
        return iterators;
    }

    public AbstractEvaluatorIterationManager(@NonNull Evaluator evaluator, @NonNull OCLExpression body, @NonNull CollectionValue collectionValue, @Nullable TypedElement accumulatorVariable, @Nullable Object accumulatorValue) {
        super(evaluator);
        this.collectionValue = collectionValue;
        this.body = body;
        this.accumulatorVariable = accumulatorVariable;
        this.accumulatorValue = accumulatorValue;
        if (accumulatorVariable != null) {
            this.getEvaluationEnvironment().add(accumulatorVariable, accumulatorValue);
        }
    }

    public AbstractEvaluatorIterationManager(@NonNull AbstractEvaluatorIterationManager iterationManager, @NonNull CollectionValue collectionValue) {
        super(iterationManager.evaluator);
        this.body = iterationManager.body;
        this.collectionValue = collectionValue;
        this.accumulatorValue = iterationManager.accumulatorValue;
        this.accumulatorVariable = iterationManager.accumulatorVariable;
    }

    @Override
    @Nullable
    public Object evaluateBody() {
        return this.evaluator.evaluate(this.body);
    }

    @Override
    @Nullable
    public Object getAccumulatorValue() {
        return this.accumulatorValue;
    }

    @NonNull
    public CollectionValue getCollectionValue() {
        return this.collectionValue;
    }

    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluator.getEvaluationEnvironment();
    }

    @Override
    @NonNull
    public CollectionValue getSourceCollection() {
        return this.collectionValue;
    }

    public String toString() {
        return this.body.toString();
    }

    @Override
    @Nullable
    public Object updateAccumulator(Object newValue) {
        this.accumulatorValue = newValue;
        TypedElement accumulatorVariable2 = this.accumulatorVariable;
        if (accumulatorVariable2 != null) {
            this.getEvaluationEnvironment().replace(accumulatorVariable2, this.accumulatorValue);
        }
        return null;
    }

    protected static class ValueIterator {
        private final EvaluationEnvironment evaluationEnvironment;
        @NonNull
        private final CollectionValue collectionValue;
        @NonNull
        private final TypedElement variable;
        private Iterator<? extends Object> javaIter;
        private Object value;

        public ValueIterator(@NonNull Evaluator evaluator, @NonNull CollectionValue collectionValue, @NonNull TypedElement variable) {
            this.evaluationEnvironment = evaluator.getEvaluationEnvironment();
            this.collectionValue = collectionValue;
            this.variable = variable;
            this.reset();
        }

        @Nullable
        public Object get() {
            return this.value;
        }

        public boolean hasCurrent() {
            return this.value != this;
        }

        @Nullable
        public Object next() {
            if (!this.javaIter.hasNext()) {
                this.value = this;
            } else {
                this.value = this.javaIter.next();
                this.evaluationEnvironment.replace(this.variable, this.value);
            }
            return this.value;
        }

        public Object reset() {
            this.javaIter = this.collectionValue.iterator();
            return this.next();
        }

        public String toString() {
            return String.valueOf(String.valueOf(this.variable)) + " = " + (this.value != this ? String.valueOf(this.value) : "<<END>>");
        }
    }
}

