/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryTernaryOperation;
import org.eclipse.ocl.pivot.library.LibraryUnaryOperation;

public abstract class AbstractPolyOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    @Override
    @Nullable
    public Object dispatch(@NonNull Evaluator evaluator, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        TypeId typeId = callExp.getTypeId();
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        if (arguments.size() == 0) {
            return this.evaluate(evaluator, typeId, sourceValue);
        }
        OCLExpression argument0 = arguments.get(0);
        assert (argument0 != null);
        Object firstArgument = evaluator.evaluate(argument0);
        if (arguments.size() == 1) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument);
        }
        OCLExpression argument1 = arguments.get(1);
        assert (argument1 != null);
        Object secondArgument = evaluator.evaluate(argument1);
        if (arguments.size() == 2) {
            return this.evaluate(evaluator, typeId, sourceValue, firstArgument, secondArgument);
        }
        Object[] argumentValues = new Object[arguments.size()];
        argumentValues[0] = firstArgument;
        argumentValues[1] = secondArgument;
        int i = 2;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        return this.evaluate(evaluator, typeId, sourceValue, argumentValues);
    }
}

