/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.library.AbstractEvaluatorIterationManager;
import org.eclipse.ocl.pivot.values.CollectionValue;

public class EvaluatorMultipleIterationManager
extends AbstractEvaluatorIterationManager {
    protected final AbstractEvaluatorIterationManager.ValueIterator[] iterators;
    protected boolean hasCurrent;

    public EvaluatorMultipleIterationManager(@NonNull Evaluator invokingEvaluator, @NonNull OCLExpression body, @NonNull CollectionValue collectionValue, @Nullable TypedElement accumulator, @Nullable Object accumulatorValue, TypedElement ... referredIterators) {
        super(invokingEvaluator.createNestedEvaluator(), body, collectionValue, accumulator, accumulatorValue);
        int iMax = referredIterators.length;
        AbstractEvaluatorIterationManager.ValueIterator[] iterators = new AbstractEvaluatorIterationManager.ValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            TypedElement referredIterator = referredIterators[i];
            if (referredIterator != null) {
                AbstractEvaluatorIterationManager.ValueIterator valueIterator = new AbstractEvaluatorIterationManager.ValueIterator(this.evaluator, collectionValue, referredIterator);
                if (!valueIterator.hasCurrent()) {
                    this.iterators = null;
                    this.hasCurrent = false;
                    return;
                }
                iterators[i] = valueIterator;
            }
            ++i;
        }
        this.iterators = iterators;
        this.hasCurrent = true;
    }

    @Override
    public boolean advanceIterators() {
        if (this.hasCurrent) {
            AbstractEvaluatorIterationManager.ValueIterator[] valueIteratorArray = this.iterators;
            int n = this.iterators.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractEvaluatorIterationManager.ValueIterator advancingIterator = valueIteratorArray[n2];
                advancingIterator.next();
                if (advancingIterator.hasCurrent()) {
                    AbstractEvaluatorIterationManager.ValueIterator[] valueIteratorArray2 = this.iterators;
                    int n3 = this.iterators.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AbstractEvaluatorIterationManager.ValueIterator previousIterator = valueIteratorArray2[n4];
                        if (previousIterator == advancingIterator) {
                            return true;
                        }
                        previousIterator.reset();
                        ++n4;
                    }
                }
                ++n2;
            }
            this.hasCurrent = false;
        }
        return false;
    }

    @NonNull
    public Object get(int i) {
        Object currentValue = this.iterators[i].get();
        if (currentValue == null) {
            throw new IllegalStateException("cannot get() after iteration complete");
        }
        return currentValue;
    }

    @Override
    public boolean hasCurrent() {
        return this.hasCurrent;
    }
}

