/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.collection;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.library.AbstractSimpleUnaryOperation;
import org.eclipse.ocl.pivot.library.numeric.NumericMinOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class CollectionMinOperation
extends AbstractSimpleUnaryOperation {
    @NonNull
    public static final CollectionMinOperation INSTANCE = new CollectionMinOperation();

    @Override
    @NonNull
    public Object evaluate(@Nullable Object sourceVal) {
        CollectionValue collectionValue = CollectionMinOperation.asCollectionValue(sourceVal);
        Object result = null;
        for (Object object : collectionValue.iterable()) {
            if (result == null) {
                result = object;
                continue;
            }
            if (object == null) continue;
            result = NumericMinOperation.INSTANCE.evaluate(result, object);
        }
        if (result == null) {
            throw new InvalidValueException(PivotMessages.EmptyCollection, collectionValue.getKind(), "min");
        }
        return result;
    }
}

