/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class OneIteration
extends AbstractIteration {
    @NonNull
    public static final OneIteration INSTANCE = new OneIteration();

    @Override
    @NonNull
    public MutableBoolean createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return new MutableBoolean();
    }

    @Override
    @NonNull
    protected Object resolveTerminalValue(@NonNull IterationManager iterationManager) {
        MutableBoolean accumulatorValue = (MutableBoolean)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        return accumulatorValue.isSet();
    }

    @Override
    @Nullable
    protected Object updateAccumulator(@NonNull IterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        if (bodyVal == null) {
            throw new InvalidValueException(PivotMessages.UndefinedBody, "one");
        }
        if (bodyVal == Boolean.FALSE) {
            return CARRY_ON;
        }
        if (bodyVal != Boolean.TRUE) {
            throw new InvalidValueException(PivotMessages.NonBooleanBody, "one");
        }
        MutableBoolean accumulatorValue = (MutableBoolean)iterationManager.getAccumulatorValue();
        assert (accumulatorValue != null);
        if (accumulatorValue.isSet()) {
            return Boolean.FALSE;
        }
        accumulatorValue.set();
        return CARRY_ON;
    }

    public static class MutableBoolean {
        private boolean value = false;

        public boolean isSet() {
            return this.value;
        }

        public void set() {
            this.value = true;
        }
    }
}

