/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.iterator;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.IterationManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractIteration;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class SelectIteration
extends AbstractIteration {
    @NonNull
    public static final SelectIteration INSTANCE = new SelectIteration();

    @Override
    @NonNull
    public CollectionValue.Accumulator createAccumulatorValue(@NonNull Evaluator evaluator, @NonNull TypeId accumulatorTypeId, @NonNull TypeId bodyTypeId) {
        return SelectIteration.createCollectionAccumulatorValue((CollectionTypeId)accumulatorTypeId);
    }

    @Override
    @Nullable
    protected Object updateAccumulator(@NonNull IterationManager iterationManager) {
        Object bodyVal = iterationManager.evaluateBody();
        assert (!(bodyVal instanceof InvalidValueException));
        if (bodyVal == null) {
            throw new InvalidValueException(PivotMessages.UndefinedBody, "select");
        }
        if (bodyVal == TRUE_VALUE) {
            Object value = iterationManager.get();
            CollectionValue.Accumulator accumulatorValue = (CollectionValue.Accumulator)iterationManager.getAccumulatorValue();
            assert (accumulatorValue != null);
            accumulatorValue.add(value);
        } else if (bodyVal != Boolean.FALSE) {
            throw new InvalidValueException(PivotMessages.NonBooleanBody, "select");
        }
        return CARRY_ON;
    }
}

