/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.oclany;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractUntypedBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class OclComparableComparisonOperation
extends AbstractUntypedBinaryOperation {
    @Override
    @NonNull
    public Boolean evaluate(@NonNull Evaluator evaluator, @Nullable Object left, @Nullable Object right) {
        StandardLibrary standardLibrary = evaluator.getStandardLibrary();
        CompleteInheritance leftType = evaluator.getIdResolver().getDynamicTypeOf(left).getInheritance(standardLibrary);
        CompleteInheritance rightType = evaluator.getIdResolver().getDynamicTypeOf(right).getInheritance(standardLibrary);
        CompleteInheritance commonType = leftType.getCommonInheritance(rightType);
        CompleteInheritance comparableType = standardLibrary.getOclComparableType().getInheritance(standardLibrary);
        CompleteInheritance selfType = standardLibrary.getOclSelfType().getInheritance(standardLibrary);
        Operation staticOperation = comparableType.lookupLocalOperation(standardLibrary, "compareTo", selfType);
        LibraryBinaryOperation implementation = null;
        try {
            if (staticOperation != null) {
                implementation = (LibraryBinaryOperation)commonType.lookupImplementation(standardLibrary, staticOperation);
            }
        }
        catch (Exception e) {
            throw new InvalidValueException(e, "No 'compareTo' implementation");
        }
        if (implementation != null) {
            Object comparison = implementation.evaluate(evaluator, TypeId.INTEGER, left, right);
            int intComparison = ValueUtil.asInteger(comparison);
            return this.getResultValue(intComparison);
        }
        throw new InvalidValueException("Unsupported compareTo for ''{0}''", left != null ? left.getClass().getName() : "null");
    }

    protected abstract boolean getResultValue(Integer var1);
}

