/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library.string;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.library.LibraryBinaryOperation;
import org.eclipse.ocl.pivot.library.LibraryTernaryOperation;
import org.eclipse.ocl.pivot.library.LibraryUnaryOperation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.SequenceValue;

public class StringTokenizeOperation
extends AbstractOperation
implements LibraryUnaryOperation,
LibraryBinaryOperation,
LibraryTernaryOperation {
    @NonNull
    public static final StringTokenizeOperation INSTANCE = new StringTokenizeOperation();
    @NonNull
    private static final String DELIMS = " \t\n\r\f";

    @Override
    @Nullable
    public Object dispatch(@NonNull Evaluator evaluator, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        String delims = DELIMS;
        boolean returnDelims = false;
        TypeId typeId = callExp.getTypeId();
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        if (arguments.size() > 0) {
            if (arguments.size() > 1) {
                if (arguments.size() > 2) {
                    throw new InvalidValueException(PivotMessages.InvalidArgument, arguments.get(2));
                }
                OCLExpression argument1 = arguments.get(1);
                assert (argument1 != null);
                Object secondArgument = evaluator.evaluate(argument1);
                returnDelims = StringTokenizeOperation.asBoolean(secondArgument);
            }
            OCLExpression argument0 = arguments.get(0);
            assert (argument0 != null);
            Object firstArgument = evaluator.evaluate(argument0);
            delims = StringTokenizeOperation.asString(firstArgument);
        }
        return this.evaluate(evaluator, (CollectionTypeId)typeId, sourceValue, delims, returnDelims);
    }

    @Override
    @NonNull
    public SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, DELIMS, false);
    }

    @Override
    @NonNull
    public SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        String delims = StringTokenizeOperation.asString(argumentValue);
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, delims, false);
    }

    @Override
    @NonNull
    public SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String delims = StringTokenizeOperation.asString(firstArgumentValue);
        boolean returnDelims = StringTokenizeOperation.asBoolean(secondArgumentValue);
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, delims, returnDelims);
    }

    @NonNull
    private SequenceValue evaluate(@NonNull Evaluator evaluator, @NonNull CollectionTypeId returnTypeId, @Nullable Object sourceValue, @NonNull String delims, boolean returnDelims) {
        String sourceString = StringTokenizeOperation.asString(sourceValue);
        StringTokenizer tokenizer = new StringTokenizer(sourceString, delims, returnDelims);
        ArrayList<String> results = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            results.add(nextToken);
        }
        return StringTokenizeOperation.createSequenceValue(returnTypeId, results);
    }
}

