/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.InheritanceFragment;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.messages.PivotMessages;
import org.eclipse.ocl.pivot.utilities.IndexableIterable;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class AbstractFragment
implements InheritanceFragment {
    @NonNull
    public final CompleteInheritance derivedInheritance;
    @NonNull
    public final CompleteInheritance baseInheritance;

    public AbstractFragment(@NonNull CompleteInheritance derivedInheritance, @NonNull CompleteInheritance baseInheritance) {
        this.derivedInheritance = derivedInheritance;
        this.baseInheritance = baseInheritance;
    }

    @Override
    @NonNull
    public Operation getActualOperation(@NonNull Operation apparentOperation) {
        Operation localOperation = this.getLocalOperation(apparentOperation);
        if (localOperation == null && this.derivedInheritance == this.baseInheritance) {
            localOperation = apparentOperation;
        }
        if (localOperation == null) {
            Operation bestOverload = null;
            CompleteInheritance bestInheritance = null;
            int bestDepth = -1;
            int minDepth = this.baseInheritance.getDepth();
            int depth = this.derivedInheritance.getDepth() - 1;
            while (depth >= minDepth) {
                IndexableIterable<InheritanceFragment> derivedSuperFragments = this.derivedInheritance.getSuperFragments(depth);
                for (InheritanceFragment derivedSuperFragment : derivedSuperFragments) {
                    Operation overload;
                    CompleteInheritance superInheritance = derivedSuperFragment.getBaseInheritance();
                    InheritanceFragment superFragment = superInheritance.getFragment(this.baseInheritance);
                    if (superFragment == null || (overload = superFragment.getLocalOperation(apparentOperation)) == null) continue;
                    if (bestInheritance == null) {
                        bestDepth = depth;
                        bestInheritance = superInheritance;
                        bestOverload = overload;
                        continue;
                    }
                    if (depth == bestDepth) {
                        bestOverload = null;
                        depth = -1;
                        break;
                    }
                    if (bestInheritance.isSubInheritanceOf(superInheritance)) continue;
                    bestOverload = null;
                    depth = -1;
                    break;
                }
                --depth;
            }
            if (bestOverload != null) {
                localOperation = bestOverload;
            } else if (bestInheritance == null) {
                localOperation = apparentOperation;
            } else {
                throw new InvalidValueException(PivotMessages.AmbiguousOperation, apparentOperation, this.derivedInheritance);
            }
        }
        return localOperation;
    }

    @Override
    @NonNull
    public final InheritanceFragment getBaseFragment() {
        return this.baseInheritance.getSelfFragment();
    }

    @Override
    @NonNull
    public final CompleteInheritance getBaseInheritance() {
        return this.baseInheritance;
    }

    @Override
    @NonNull
    public final CompleteInheritance getDerivedInheritance() {
        return this.derivedInheritance;
    }

    public String toString() {
        return String.valueOf(this.derivedInheritance.getName()) + "__" + this.baseInheritance.getName();
    }
}

