/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.BooleanLiteralExp;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionLiteralExp;
import org.eclipse.ocl.pivot.CollectionLiteralPart;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.EnumLiteralExp;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.IntegerLiteralExp;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.IteratorExp;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapLiteralExp;
import org.eclipse.ocl.pivot.MapLiteralPart;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NullLiteralExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Precedence;
import org.eclipse.ocl.pivot.PrimitiveType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.RealLiteralExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.StringLiteralExp;
import org.eclipse.ocl.pivot.TemplateBinding;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateSignature;
import org.eclipse.ocl.pivot.TemplateableElement;
import org.eclipse.ocl.pivot.TupleLiteralExp;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.internal.utilities.PivotConstantsInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.values.Unlimited;

public class AS2MonikerVisitor
extends AbstractExtendingVisitor<Object, AS2Moniker>
implements PivotConstantsInternal {
    private static boolean initialized = false;
    @Nullable
    protected final Map<TemplateParameter, Type> templateBindings;

    @Deprecated
    @Nullable
    private static Map<TemplateParameter, Type> getAllTemplateParameterSubstitutions(@Nullable Map<TemplateParameter, Type> map, @Nullable TemplateableElement templateableElement) {
        TemplateableElement eObject = templateableElement;
        while (eObject != null) {
            if (eObject instanceof TemplateableElement) {
                for (TemplateBinding templateBinding : eObject.getOwnedBindings()) {
                    for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getOwnedSubstitutions()) {
                        if (map == null) {
                            map = new HashMap<TemplateParameter, Type>();
                        }
                        map.put(templateParameterSubstitution.getFormal(), templateParameterSubstitution.getActual());
                    }
                }
            }
            if (eObject instanceof Class) {
                for (Class superType : ((Class)eObject).getSuperClasses()) {
                    map = AS2MonikerVisitor.getAllTemplateParameterSubstitutions(map, superType);
                }
            }
            eObject = eObject.eContainer();
        }
        return map;
    }

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            roleNames.put(PivotPackage.Literals.LOOP_EXP__OWNED_BODY, "argument");
        }
    }

    public AS2MonikerVisitor(@NonNull AS2Moniker context) {
        super(context);
        this.templateBindings = null;
        if (!initialized) {
            AS2MonikerVisitor.initialize();
        }
    }

    public AS2MonikerVisitor(@NonNull AS2Moniker context, @Nullable Map<TemplateParameter, Type> templateBindings) {
        super(context);
        this.templateBindings = templateBindings;
    }

    public void appendExpPrefix(@NonNull NamedElement object) {
        CallExp callExpParent;
        EObject parent = object.eContainer();
        if (parent instanceof CallExp && (callExpParent = (CallExp)parent).isIsImplicit()) {
            if (callExpParent instanceof IteratorExp) {
                if (callExpParent.getOwnedSource() == object) {
                    ((AS2Moniker)this.context).appendElement(((IteratorExp)callExpParent).getOwnedBody());
                    ((AS2Moniker)this.context).append("!");
                    ((AS2Moniker)this.context).appendRole(object);
                    ((AS2Moniker)this.context).append("~");
                    return;
                }
                ((AS2Moniker)this.context).appendParent(callExpParent, "!");
                ((AS2Moniker)this.context).appendRole(callExpParent);
                ((AS2Moniker)this.context).append("~");
                return;
            }
            if (callExpParent.getOwnedSource() == object) {
                object = callExpParent;
            }
        }
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).appendRole(object);
        ((AS2Moniker)this.context).append("~");
    }

    public String toString() {
        return ((AS2Moniker)this.context).toString();
    }

    @Override
    public Object visitAnnotation(@NonNull Annotation object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).append("'");
        ((AS2Moniker)this.context).append(String.valueOf(object.getName()));
        ((AS2Moniker)this.context).append("'");
        Object container = object.eContainer().eGet(object.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            for (Object element : (List)container) {
                if (element == object) break;
                if (!(element instanceof Annotation) || !((Annotation)element).getName().equals(object.getName())) continue;
                ++index;
            }
            if (index > 0) {
                ((AS2Moniker)this.context).append(index);
            }
        }
        return true;
    }

    @Override
    public Object visitBooleanLiteralExp(@NonNull BooleanLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append(Boolean.toString(object.isBooleanSymbol()));
        return true;
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        if (!object.getOwnedBindings().isEmpty()) {
            Type templateableClass = PivotUtil.getUnspecializedTemplateableElement(object);
            ((AS2Moniker)this.context).appendParent(templateableClass, "!");
            ((AS2Moniker)this.context).appendName(templateableClass);
            ((AS2Moniker)this.context).appendTemplateBindings(object, this.templateBindings);
        } else if (object.eContainer() instanceof TemplateParameterSubstitution) {
            TemplateParameter formal = ((TemplateParameterSubstitution)object.eContainer()).getFormal();
            int index = formal.getOwningSignature().getOwnedParameters().indexOf(formal);
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).append("?" + index);
        } else {
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).appendName(object);
            ((AS2Moniker)this.context).appendTemplateParameters(object);
        }
        if (object instanceof CollectionType) {
            CollectionType collectionType = (CollectionType)object;
            Number lower = collectionType.getLower();
            Number upper = collectionType.getUpper();
            if (lower.longValue() != 0L || !(upper instanceof Unlimited)) {
                ((AS2Moniker)this.context).append("_" + lower);
                if (!(upper instanceof Unlimited)) {
                    ((AS2Moniker)this.context).append("_" + upper);
                }
            }
        }
        return true;
    }

    @Override
    public Object visitCollectionLiteralExp(@NonNull CollectionLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getType());
        return true;
    }

    @Override
    public Object visitCollectionLiteralPart(@NonNull CollectionLiteralPart object) {
        ((AS2Moniker)this.context).appendParent(object, "@");
        ((AS2Moniker)this.context).appendIndex(object);
        return true;
    }

    @Override
    public Object visitConstraint(@NonNull Constraint object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).append(PivotUtilInternal.getStereotype(object));
        Object container = object.eContainer().eGet(object.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            String name2 = object.getName();
            for (Object content : (List)container) {
                Constraint sibling;
                if (content == object) break;
                if (!(content instanceof Constraint) || !PivotUtilInternal.getStereotype(sibling = (Constraint)content).equals(PivotUtilInternal.getStereotype(object))) continue;
                String name1 = sibling.getName();
                if (name1 != name2 && (name1 == null || !name1.equals(name2))) break;
                ++index;
            }
            ((AS2Moniker)this.context).append("~");
            if (name2 != null) {
                ((AS2Moniker)this.context).append(name2);
            }
            if (index != 0) {
                ((AS2Moniker)this.context).append("~");
                ((AS2Moniker)this.context).append(index);
            }
        }
        return true;
    }

    @Override
    public Object visitDetail(@NonNull Detail object) {
        ((AS2Moniker)this.context).appendParent(object, "/");
        ((AS2Moniker)this.context).append(object.getName());
        return true;
    }

    @Override
    public Object visitEnumLiteralExp(@NonNull EnumLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredLiteral());
        return true;
    }

    @Override
    public Object visitExpressionInOCL(@NonNull ExpressionInOCL object) {
        if (object.eContainer() != null) {
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).appendRole(object);
        } else {
            ((AS2Moniker)this.context).append("root");
        }
        return true;
    }

    @Override
    public Object visitIfExp(@NonNull IfExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("if");
        return true;
    }

    @Override
    public Object visitIntegerLiteralExp(@NonNull IntegerLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append(object.getIntegerSymbol().toString());
        return true;
    }

    @Override
    public Object visitInvalidLiteralExp(@NonNull InvalidLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("invalid");
        return true;
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        ((AS2Moniker)this.context).append(object.getName());
        Map<TemplateParameter, Type> bindings = AS2MonikerVisitor.getAllTemplateParameterSubstitutions(null, object);
        ((AS2Moniker)this.context).appendLambdaType(object.getContextType(), object.getParameterType(), object.getResultType(), bindings);
        return true;
    }

    @Override
    public Object visitLetExp(@NonNull LetExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("let");
        return true;
    }

    @Override
    public Object visitLoopExp(@NonNull LoopExp object) {
        OCLExpression body;
        this.appendExpPrefix(object);
        if (object.isIsImplicit() && (body = object.getOwnedBody()) instanceof CallExp) {
            Feature referredFeature = PivotUtil.getReferredFeature((CallExp)body);
            ((AS2Moniker)this.context).appendName(referredFeature);
            return true;
        }
        ((AS2Moniker)this.context).appendName(object.getReferredIteration());
        return true;
    }

    @Override
    public Object visitMapLiteralExp(@NonNull MapLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getType());
        return true;
    }

    @Override
    public Object visitMapLiteralPart(@NonNull MapLiteralPart object) {
        ((AS2Moniker)this.context).appendParent(object, "@");
        ((AS2Moniker)this.context).appendIndex(object);
        return true;
    }

    @Override
    public Object visitModel(@NonNull Model object) {
        ((AS2Moniker)this.context).append("ROOT");
        return true;
    }

    @Override
    public Object visitNamedElement(@NonNull NamedElement object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitNullLiteralExp(@NonNull NullLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("null");
        return true;
    }

    @Override
    public Object visitOperation(@NonNull Operation object) {
        if (!object.getOwnedBindings().isEmpty()) {
            ((AS2Moniker)this.context).appendParent(object, "!");
            ((AS2Moniker)this.context).appendName(object);
            Map<TemplateParameter, Type> bindings = AS2MonikerVisitor.getAllTemplateParameterSubstitutions(null, object);
            if (this.templateBindings != null && bindings == null) {
                bindings = this.templateBindings;
            }
            ((AS2Moniker)this.context).appendTemplateBindings(object, bindings);
            ((AS2Moniker)this.context).appendParameters(object, bindings);
            return true;
        }
        ((AS2Moniker)this.context).appendParent(object, "!");
        ((AS2Moniker)this.context).appendName(object);
        ((AS2Moniker)this.context).appendTemplateParameters(object);
        ((AS2Moniker)this.context).appendParameters(object, null);
        return true;
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredOperation());
        return true;
    }

    @Override
    public Object visitOppositePropertyCallExp(@NonNull OppositePropertyCallExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("~");
        ((AS2Moniker)this.context).appendName(object.getReferredProperty());
        return true;
    }

    @Override
    public Object visitPackage(@NonNull Package object) {
        ((AS2Moniker)this.context).append(PivotUtilInternal.getNsURI(object));
        return true;
    }

    @Override
    public Object visitPrecedence(@NonNull Precedence object) {
        ((AS2Moniker)this.context).appendParent(object, "~");
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitPrimitiveType(@NonNull PrimitiveType object) {
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredProperty());
        return true;
    }

    @Override
    public Object visitRealLiteralExp(@NonNull RealLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append(object.getRealSymbol().toString());
        return true;
    }

    @Override
    public String visitShadowExp(@NonNull ShadowExp shadowExp) {
        this.appendExpPrefix(shadowExp);
        ((AS2Moniker)this.context).append("tuple");
        return null;
    }

    @Override
    public Object visitStringLiteralExp(@NonNull StringLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("string");
        return true;
    }

    @Override
    public Object visitTemplateBinding(@NonNull TemplateBinding object) {
        TemplateSignature signature = object.getTemplateSignature();
        if (signature != null) {
            ((AS2Moniker)this.context).appendElement(signature.getOwningElement());
        }
        ((AS2Moniker)this.context).append("/");
        return true;
    }

    @Override
    public Object visitTemplateParameter(@NonNull TemplateParameter object) {
        TemplateableElement owningTemplateElement = object.getOwningSignature().getOwningElement();
        ((AS2Moniker)this.context).appendElement(owningTemplateElement);
        ((AS2Moniker)this.context).append("?");
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        ((AS2Moniker)this.context).appendElement(object.getOwningBinding());
        ((AS2Moniker)this.context).appendName(object.getFormal());
        return true;
    }

    @Override
    public Object visitTemplateSignature(@NonNull TemplateSignature object) {
        ((AS2Moniker)this.context).appendParent(object, "!");
        return true;
    }

    @Override
    public Object visitTupleLiteralExp(@NonNull TupleLiteralExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).append("tuple");
        return true;
    }

    @Override
    public Object visitTupleType(@NonNull TupleType object) {
        List<Property> ownedAttributes = object.getOwnedProperties();
        if (ownedAttributes.isEmpty()) {
            super.visitTupleType(object);
        } else {
            ((AS2Moniker)this.context).appendName(object);
            ((AS2Moniker)this.context).appendTupleType(ownedAttributes);
        }
        return true;
    }

    @Override
    public Object visitTypeExp(@NonNull TypeExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredType());
        return true;
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp object) {
        this.appendExpPrefix(object);
        Number unlimitedNaturalSymbol = object.getUnlimitedNaturalSymbol();
        ((AS2Moniker)this.context).append(unlimitedNaturalSymbol.toString());
        return true;
    }

    @Override
    public Object visitVariable(@NonNull Variable object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitVariableExp(@NonNull VariableExp object) {
        this.appendExpPrefix(object);
        ((AS2Moniker)this.context).appendName(object.getReferredVariable());
        return true;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for " + this.getClass().getSimpleName());
    }
}

