/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.manager.Orphanage;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.internal.utilities.AS2Moniker;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class ASSaverNormalizeVisitor
extends AbstractExtendingVisitor<Object, ASSaver> {
    public ASSaverNormalizeVisitor(@NonNull ASSaver context) {
        super(context);
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        List<Property> ownedAttributes = object.getOwnedProperties();
        ClassUtil.sort(ownedAttributes, PropertyComparator.INSTANCE);
        return null;
    }

    @Override
    public Object visitPackage(@NonNull Package object) {
        if (!(object instanceof Orphanage)) {
            List<Class> ownedTypes = object.getOwnedClasses();
            ClassUtil.sort(ownedTypes, TypeComparator.INSTANCE);
        }
        return null;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        return null;
    }

    protected static final class PropertyComparator
    implements Comparator<Property> {
        @NonNull
        public static final Comparator<Property> INSTANCE = new PropertyComparator();

        protected PropertyComparator() {
        }

        @Override
        public int compare(Property o1, Property o2) {
            int l2;
            assert (o1 != null);
            assert (o2 != null);
            int l1 = o1.isIsImplicit() ? 1 : 0;
            int n = l2 = o2.isIsImplicit() ? 1 : 0;
            if (l1 != l2) {
                return l1 - l2;
            }
            String n1 = o1.getName();
            String n2 = o2.getName();
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            return n1.compareTo(n2);
        }
    }

    protected static final class TypeComparator
    implements Comparator<Class> {
        @NonNull
        public static final Comparator<Class> INSTANCE = new TypeComparator();

        protected TypeComparator() {
        }

        @Override
        public int compare(Class o1, Class o2) {
            assert (o1 != null);
            assert (o2 != null);
            String n1 = AS2Moniker.toString(o1);
            String n2 = AS2Moniker.toString(o2);
            return n1.compareTo(n2);
        }
    }
}

